/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.Doc9303CountryCodes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import javax.naming.InvalidNameException;
import org.tinylog.Logger;

public class VdsHeader {
    public static final byte DC = -36;
    private String issuingCountry;
    private String signerIdentifier;
    private String certificateReference;
    private LocalDate issuingDate;
    private LocalDate sigDate;
    private byte docFeatureRef;
    private byte docTypeCat;
    private byte rawVersion;

    private VdsHeader() {
    }

    private VdsHeader(Builder builder) {
        this.issuingCountry = builder.issuingCountry;
        this.signerIdentifier = builder.signerIdentifier;
        this.certificateReference = builder.certificateReference;
        this.issuingDate = builder.issuingDate;
        this.sigDate = builder.sigDate;
        this.docFeatureRef = builder.docFeatureRef;
        this.docTypeCat = builder.docTypeCat;
        this.rawVersion = builder.rawVersion;
    }

    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public String getSignerIdentifier() {
        return this.signerIdentifier;
    }

    public String getCertificateReference() {
        return this.certificateReference;
    }

    public LocalDate getIssuingDate() {
        return this.issuingDate;
    }

    public LocalDate getSigDate() {
        return this.sigDate;
    }

    public byte getDocFeatureRef() {
        return this.docFeatureRef;
    }

    public byte getDocTypeCat() {
        return this.docTypeCat;
    }

    public byte getRawVersion() {
        return this.rawVersion;
    }

    public int getDocumentRef() {
        return ((this.docFeatureRef & 0xFF) << 8) + (this.docTypeCat & 0xFF);
    }

    public String getVdsType() {
        return DataEncoder.getFeatureEncoder().getVdsType(this.getDocumentRef());
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(-36);
            baos.write(this.rawVersion);
            baos.write(DataEncoder.encodeC40(this.issuingCountry));
            baos.write(DataEncoder.encodeC40(this.getEncodedSignerIdentifierandCertificateReference()));
            baos.write(DataEncoder.encodeDate(this.issuingDate));
            baos.write(DataEncoder.encodeDate(this.sigDate));
            baos.write(this.docFeatureRef);
            baos.write(this.docTypeCat);
        }
        catch (IOException e) {
            Logger.error((Object)("Error while encoding header data: " + e.getMessage()));
        }
        return baos.toByteArray();
    }

    private String getEncodedSignerIdentifierandCertificateReference() {
        if (this.rawVersion == 2) {
            return String.format("%s%5s", this.signerIdentifier, this.certificateReference).toUpperCase().replace(' ', '0');
        }
        if (this.rawVersion == 3) {
            return String.format("%s%02x%s", this.signerIdentifier, this.certificateReference.length(), this.certificateReference).toUpperCase();
        }
        return "";
    }

    public static VdsHeader fromByteBuffer(ByteBuffer rawdata) {
        byte magicByte = rawdata.get();
        if (magicByte != -36) {
            Logger.error((Object)String.format("Magic Constant mismatch: 0x%02X instead of 0xdc", magicByte));
            throw new IllegalArgumentException(String.format("Magic Constant mismatch: 0x%02X instead of 0xdc", magicByte));
        }
        VdsHeader vdsHeader = new VdsHeader();
        vdsHeader.rawVersion = rawdata.get();
        if (vdsHeader.rawVersion != 2 && vdsHeader.rawVersion != 3) {
            Logger.error((Object)String.format("Unsupported rawVersion: 0x%02X", vdsHeader.rawVersion));
            throw new IllegalArgumentException(String.format("Unsupported rawVersion: 0x%02X", vdsHeader.rawVersion));
        }
        vdsHeader.issuingCountry = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, 2));
        rawdata.mark();
        String signerIdentifierAndCertRefLength = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, 4));
        vdsHeader.signerIdentifier = signerIdentifierAndCertRefLength.substring(0, 4);
        if (vdsHeader.rawVersion == 3) {
            boolean gaadHack;
            int certRefLength = Integer.parseInt(signerIdentifierAndCertRefLength.substring(4), 16);
            Logger.debug((String)"version 4: certRefLength: {}", (Object[])new Object[]{certRefLength});
            boolean bl = gaadHack = vdsHeader.signerIdentifier.equals("DEME") || vdsHeader.signerIdentifier.equals("DES1");
            if (gaadHack) {
                Logger.debug((Object)"Maybe we found a German Arrival Attestation. GAAD Hack will be applied!");
                certRefLength = 3;
            }
            int bytesToDecode = (certRefLength - 1) / 3 * 2 + 2;
            Logger.debug((String)"version 4: bytesToDecode: {}", (Object[])new Object[]{bytesToDecode});
            vdsHeader.certificateReference = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, bytesToDecode));
            if (gaadHack) {
                vdsHeader.certificateReference = signerIdentifierAndCertRefLength.substring(4) + vdsHeader.certificateReference;
            }
        } else {
            rawdata.reset();
            String signerCertRef = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, 6));
            vdsHeader.certificateReference = signerCertRef.substring(4);
        }
        vdsHeader.issuingDate = DataParser.decodeDate(DataParser.getFromByteBuffer(rawdata, 3));
        vdsHeader.sigDate = DataParser.decodeDate(DataParser.getFromByteBuffer(rawdata, 3));
        vdsHeader.docFeatureRef = rawdata.get();
        vdsHeader.docTypeCat = rawdata.get();
        Logger.debug((String)"VdsHeader: {}", (Object[])new Object[]{vdsHeader});
        return vdsHeader;
    }

    public static class Builder {
        private String issuingCountry;
        private String signerIdentifier;
        private String certificateReference;
        private LocalDate issuingDate = LocalDate.now();
        private LocalDate sigDate = LocalDate.now();
        private byte docFeatureRef;
        private byte docTypeCat;
        private byte rawVersion = (byte)3;

        public Builder(String vdsType) {
            this.setDocumentType(vdsType);
        }

        public Builder setIssuingCountry(String issuingCountry) {
            this.issuingCountry = issuingCountry;
            return this;
        }

        public Builder setSignerIdentifier(String signerIdentifier) {
            this.signerIdentifier = signerIdentifier;
            return this;
        }

        public Builder setCertificateReference(String certificateReference) {
            this.certificateReference = certificateReference;
            return this;
        }

        public Builder setIssuingDate(LocalDate issuingDate) {
            this.issuingDate = issuingDate;
            return this;
        }

        public Builder setSigDate(LocalDate sigDate) {
            this.sigDate = sigDate;
            return this;
        }

        public Builder setRawVersion(int rawVersion) {
            this.rawVersion = (byte)rawVersion;
            return this;
        }

        public VdsHeader build() {
            return new VdsHeader(this);
        }

        public Builder setSignerCertRef(X509Certificate x509Cert, boolean setIssuingCountryFromX509Cert) {
            String[] signerCertRef = null;
            try {
                signerCertRef = DataEncoder.getSignerCertRef(x509Cert);
            }
            catch (InvalidNameException e) {
                Logger.error((Object)("Couldn't build header, because getSignerCertRef throws error: " + e.getMessage()));
            }
            this.signerIdentifier = signerCertRef[0];
            this.certificateReference = signerCertRef[1];
            if (setIssuingCountryFromX509Cert) {
                this.issuingCountry = Doc9303CountryCodes.convertToIcaoOrIso3(signerCertRef[0].substring(0, 2));
            }
            return this;
        }

        private void setDocumentType(String vdsType) {
            int docRef = DataEncoder.getFeatureEncoder().getDocumentRef(vdsType);
            this.docFeatureRef = (byte)(docRef >> 8 & 0xFF);
            this.docTypeCat = (byte)(docRef & 0xFF);
        }
    }
}

