/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import java.util.HashMap;

public enum IdbSignatureAlgorithm {
    SHA256_WITH_ECDSA(1),
    SHA384_WITH_ECDSA(2),
    SHA512_WITH_ECDSA(3);

    private final byte reference;
    private static HashMap<Byte, IdbSignatureAlgorithm> map;

    private IdbSignatureAlgorithm(byte reference) {
        this.reference = reference;
    }

    public static IdbSignatureAlgorithm valueOf(byte value) {
        return map.get(value);
    }

    public byte getValue() {
        return this.reference;
    }

    static {
        map = new HashMap();
        for (IdbSignatureAlgorithm algorithm : IdbSignatureAlgorithm.values()) {
            map.put(algorithm.reference, algorithm);
        }
    }
}

