/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.DerTlv;
import de.tsenger.vdstools.idb.IdbMessageType;
import java.io.IOException;

public class IdbMessage {
    private byte messageType;
    private byte[] messageContent;

    public IdbMessage(IdbMessageType messageType, byte[] messageContent) {
        this.messageType = messageType.getValue();
        this.messageContent = messageContent;
    }

    public IdbMessage(byte messageType, byte[] messageContent) {
        this.messageType = messageType;
        this.messageContent = messageContent;
    }

    public static IdbMessage fromDerTlv(DerTlv derTlv) {
        IdbMessageType messageType = IdbMessageType.valueOf(derTlv.getTag());
        byte[] messageContent = derTlv.getValue();
        return new IdbMessage(messageType, messageContent);
    }

    public static IdbMessage fromByteArray(byte[] rawMessageBytes) throws IOException {
        DerTlv tlvMessage = DerTlv.fromByteArray(rawMessageBytes);
        return IdbMessage.fromDerTlv(tlvMessage);
    }

    public byte[] getEncoded() throws IOException {
        return new DerTlv(this.messageType, this.messageContent).getEncoded();
    }

    public IdbMessageType getMessageType() {
        return IdbMessageType.valueOf(this.messageType);
    }

    public byte[] getMessageContent() {
        return this.messageContent;
    }
}

