/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import de.tsenger.vdstools.vds.DigitalSeal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.tinylog.Logger;

public class Verifier {
    private ECPublicKey ecPubKey;
    private int fieldBitLength = 256;
    private byte[] messageBytes;
    private byte[] signatureBytes;
    String signatureAlgorithmName = "SHA256WITHECDSA";

    public Verifier(DigitalSeal digitalSeal, X509Certificate sealSignerCertificate) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (!(sealSignerCertificate.getPublicKey() instanceof ECPublicKey)) {
            throw new IllegalArgumentException("Certificate should contain EC public key!");
        }
        this.ecPubKey = (ECPublicKey)sealSignerCertificate.getPublicKey();
        this.fieldBitLength = this.ecPubKey.getParams().getCurve().getField().getFieldSize();
        this.messageBytes = digitalSeal.getHeaderAndMessageBytes();
        this.signatureBytes = digitalSeal.getSignatureBytes();
        Logger.debug((String)"Public Key bytes: 0x{}", (Object[])new Object[]{Hex.toHexString((byte[])this.ecPubKey.getEncoded())});
        Logger.debug((String)"Field bit length: {}", (Object[])new Object[]{this.fieldBitLength});
        Logger.debug((String)"Message bytes: {}", (Object[])new Object[]{Hex.toHexString((byte[])this.messageBytes)});
        Logger.debug((String)"Signature bytes: {}", (Object[])new Object[]{Hex.toHexString((byte[])this.signatureBytes)});
    }

    public Result verify() {
        if (this.fieldBitLength <= 224) {
            this.signatureAlgorithmName = "SHA224withPLAIN-ECDSA";
        } else if (this.fieldBitLength <= 256) {
            this.signatureAlgorithmName = "SHA256withPLAIN-ECDSA";
        } else if (this.fieldBitLength <= 384) {
            this.signatureAlgorithmName = "SHA384withPLAIN-ECDSA";
        } else if (this.fieldBitLength <= 512) {
            this.signatureAlgorithmName = "SHA512withPLAIN-ECDSA";
        } else {
            Logger.error((Object)("Bit length of Field is out of definied value: " + this.fieldBitLength));
            return Result.VerifyError;
        }
        try {
            Logger.debug((Object)("Verify with signatureAlgorithmName: " + this.signatureAlgorithmName));
            Signature ecdsaVerify = Signature.getInstance(this.signatureAlgorithmName, "BC");
            ecdsaVerify.initVerify(this.ecPubKey);
            ecdsaVerify.update(this.messageBytes);
            if (ecdsaVerify.verify(this.signatureBytes)) {
                return Result.SignatureValid;
            }
            return Result.SignatureInvalid;
        }
        catch (NoSuchAlgorithmException e1) {
            Logger.error((String)"NoSuchAlgorithmException: {}", (Object[])new Object[]{e1.getLocalizedMessage()});
            return Result.VerifyError;
        }
        catch (InvalidKeyException e2) {
            Logger.error((String)"InvalidKeyException: {}", (Object[])new Object[]{e2.getLocalizedMessage()});
            return Result.VerifyError;
        }
        catch (SignatureException e3) {
            Logger.error((String)"SignatureException: {}", (Object[])new Object[]{e3.getLocalizedMessage()});
            return Result.VerifyError;
        }
        catch (NoSuchProviderException e4) {
            Logger.error((String)"NoSuchProviderException: {}", (Object[])new Object[]{e4.getLocalizedMessage()});
            return Result.VerifyError;
        }
    }

    public static enum Result {
        SignatureValid,
        SignatureInvalid,
        VerifyError;

    }
}

