/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.DerTlv;
import de.tsenger.vdstools.vds.dto.FeaturesDto;
import de.tsenger.vdstools.vds.dto.SealDto;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.tinylog.Logger;

public class FeatureConverter {
    public static String DEFAULT_SEAL_CODINGS = "/SealCodings.json";
    private List<SealDto> sealDtoList;
    private static Map<String, Integer> vdsTypes = new HashMap<String, Integer>();
    private static Map<Integer, String> vdsTypesReverse = new HashMap<Integer, String>();
    private static Set<String> vdsFeatures = new TreeSet<String>();

    public FeatureConverter() {
        this(null);
    }

    public FeatureConverter(InputStream is) {
        Gson gson = new Gson();
        Type listType = new TypeToken<List<SealDto>>(){}.getType();
        if (is == null) {
            is = this.getClass().getResourceAsStream(DEFAULT_SEAL_CODINGS);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.sealDtoList = (List)gson.fromJson((Reader)reader, listType);
        for (SealDto sealDto : this.sealDtoList) {
            vdsTypes.put(sealDto.documentType, Integer.parseInt(sealDto.documentRef, 16));
            vdsTypesReverse.put(Integer.parseInt(sealDto.documentRef, 16), sealDto.documentType);
            for (FeaturesDto featureDto : sealDto.features) {
                vdsFeatures.add(featureDto.name);
            }
        }
    }

    public Set<String> getAvailableVdsTypes() {
        return new TreeSet<String>(vdsTypes.keySet());
    }

    public int getDocumentRef(String vdsType) {
        return vdsTypes.get(vdsType);
    }

    public String getVdsType(Integer docRef) {
        return vdsTypesReverse.get(docRef);
    }

    public Set<String> getAvailableVdsFeatures() {
        return vdsFeatures;
    }

    public String getFeatureName(String vdsType, DerTlv derTlv) {
        if (!vdsTypes.containsKey(vdsType)) {
            Logger.warn((Object)("No seal type with name '" + vdsType + "' was found."));
            return null;
        }
        SealDto sealDto = this.getSealDto(vdsType);
        if (sealDto == null) {
            return null;
        }
        return this.getFeatureName(sealDto, derTlv.getTag());
    }

    public byte getTag(String vdsType, String feature) {
        if (!vdsTypes.containsKey(vdsType)) {
            Logger.warn((Object)("No VdsSeal type with name '" + vdsType + "' was found."));
            return 0;
        }
        if (!vdsFeatures.contains(feature)) {
            Logger.warn((Object)("No VdsSeal feature with name '" + feature + "' was found."));
            return 0;
        }
        SealDto sealDto = this.getSealDto(vdsType);
        if (sealDto == null) {
            return 0;
        }
        return this.getTag(sealDto, feature);
    }

    public <T> T decodeFeature(String vdsType, DerTlv derTlv) {
        if (!vdsTypes.containsKey(vdsType)) {
            Logger.warn((Object)("No seal type with name '" + vdsType + "' was found."));
            return null;
        }
        SealDto sealDto = this.getSealDto(vdsType);
        if (sealDto == null) {
            return null;
        }
        return this.decodeFeature(sealDto, derTlv);
    }

    public <T> DerTlv encodeFeature(String vdsType, String feature, T inputValue) throws IllegalArgumentException {
        if (!vdsTypes.containsKey(vdsType)) {
            Logger.warn((Object)("No VdsSeal type with name '" + vdsType + "' was found."));
            return null;
        }
        if (!vdsFeatures.contains(feature)) {
            Logger.warn((Object)("No VdsSeal feature with name '" + feature + "' was found."));
            return null;
        }
        SealDto sealDto = this.getSealDto(vdsType);
        return this.encodeFeature(sealDto, feature, inputValue);
    }

    private <T> DerTlv encodeFeature(SealDto sealDto, String feature, T inputValue) throws IllegalArgumentException {
        byte tag = this.getTag(sealDto, feature);
        if (tag == 0) {
            Logger.warn((Object)("VdsType: " + sealDto.documentType + " has no Feature " + feature));
            throw new IllegalArgumentException("VdsType: " + sealDto.documentType + " has no Feature " + feature);
        }
        String coding = this.getCoding(sealDto, feature);
        byte[] value = null;
        switch (coding) {
            case "C40": {
                String valueStr = ((String)inputValue).replaceAll("\r", "").replaceAll("\n", "");
                value = DataEncoder.encodeC40(valueStr);
                break;
            }
            case "ByteArray": {
                value = (byte[])inputValue;
                break;
            }
            case "Utf8String": {
                try {
                    value = ((String)inputValue).getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.error((Object)("Couldn't encode String " + (String)inputValue + " to UTF-8 bytes: " + e.getMessage()));
                }
                break;
            }
            default: {
                value = (byte[])inputValue;
            }
        }
        return new DerTlv(tag, value);
    }

    private <T> T decodeFeature(SealDto sealDto, DerTlv derTlv) {
        String coding;
        byte tag = derTlv.getTag();
        switch (coding = this.getCoding(sealDto, tag)) {
            case "C40": {
                String featureValue = DataParser.decodeC40(derTlv.getValue());
                String featureName = this.getFeatureName(sealDto, tag);
                if (featureName.startsWith("MRZ")) {
                    featureValue = featureValue.replace(' ', '<');
                }
                return (T)featureValue;
            }
            case "ByteArray": {
                return (T)derTlv.getValue();
            }
            case "Utf8String": {
                return (T)new String(derTlv.getValue(), StandardCharsets.UTF_8);
            }
        }
        return (T)derTlv.getValue();
    }

    private byte getTag(SealDto sealDto, String feature) {
        for (FeaturesDto featureDto : sealDto.features) {
            if (!featureDto.name.equalsIgnoreCase(feature)) continue;
            return (byte)featureDto.tag;
        }
        return 0;
    }

    private String getFeatureName(SealDto sealDto, int tag) {
        for (FeaturesDto featureDto : sealDto.features) {
            if (featureDto.tag != tag) continue;
            return featureDto.name;
        }
        return null;
    }

    private String getCoding(SealDto sealDto, String feature) {
        for (FeaturesDto featureDto : sealDto.features) {
            if (!featureDto.name.equalsIgnoreCase(feature)) continue;
            return featureDto.coding;
        }
        return null;
    }

    private String getCoding(SealDto sealDto, byte tag) {
        for (FeaturesDto featureDto : sealDto.features) {
            if (featureDto.tag != tag) continue;
            return featureDto.coding;
        }
        return null;
    }

    private FeaturesDto getFeatureDto(SealDto sealDto, byte tag) {
        for (FeaturesDto featureDto : sealDto.features) {
            if (featureDto.tag != tag) continue;
            return featureDto;
        }
        return null;
    }

    private SealDto getSealDto(String vdsType) {
        for (SealDto sealDto : this.sealDtoList) {
            if (!sealDto.documentType.equals(vdsType)) continue;
            return sealDto;
        }
        return null;
    }
}

