/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.tinylog.Logger;

public class Doc9303CountryCodes {
    private static final Map<String, String> doc9303Codes = new HashMap<String, String>();

    public static String convertToIcaoOrIso3(String alpha2Code) {
        if (doc9303Codes.containsKey(alpha2Code)) {
            return doc9303Codes.get(alpha2Code);
        }
        Locale locale = new Locale("", alpha2Code);
        try {
            return locale.getISO3Country();
        }
        catch (MissingResourceException e) {
            Logger.warn((Object)("unbekannter Country Code. " + e.getMessage()));
            return null;
        }
    }

    static {
        doc9303Codes.put("EU", "EUE");
        doc9303Codes.put("UN", "UNO");
        doc9303Codes.put("DE", "D<<");
        doc9303Codes.put("UT", "UTO");
        doc9303Codes.put("IA", "IAO");
        doc9303Codes.put("NT", "NTZ");
        doc9303Codes.put("AN", "ANT");
        doc9303Codes.put("AN", "ANT");
    }
}

