/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import de.tsenger.vdstools.DerTlv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterOutputStream;
import org.tinylog.Logger;

public class DataParser {
    public static byte[] getFromByteBuffer(ByteBuffer buffer, int size) {
        byte[] tmpByteArray = new byte[size];
        if (buffer.position() + size <= buffer.capacity()) {
            buffer.get(tmpByteArray);
        }
        return tmpByteArray;
    }

    public static String decodeMaskedDate(byte[] maskedDateBytes) throws IllegalArgumentException {
        if (maskedDateBytes.length != 4) {
            throw new IllegalArgumentException("expected four bytes for masked date decoding");
        }
        byte mask = maskedDateBytes[0];
        long intval = (long)DataParser.toUnsignedInt(maskedDateBytes[1]) * 256L * 256L + (long)DataParser.toUnsignedInt(maskedDateBytes[2]) * 256L + (long)DataParser.toUnsignedInt(maskedDateBytes[3]);
        int day = (int)(intval % 1000000L / 10000L);
        int month = (int)(intval / 1000000L);
        int year = (int)(intval % 10000L);
        char[] dateCharArray = String.format("%02d%02d%04d", month, day, year).toCharArray();
        for (int i = 0; i < 8; ++i) {
            byte unknownBit = (byte)(mask >> 7 - i & 1);
            if (unknownBit != 1) continue;
            dateCharArray[i] = 120;
        }
        String dateString = String.valueOf(dateCharArray);
        String formattedDateString = dateString.replaceAll("(.{2})(.{2})(.{4})", "$3-$1-$2").toLowerCase();
        return formattedDateString;
    }

    public static LocalDate decodeDate(byte[] dateBytes) {
        if (dateBytes.length != 3) {
            throw new IllegalArgumentException("expected three bytes for date decoding");
        }
        long intval = (long)DataParser.toUnsignedInt(dateBytes[0]) * 256L * 256L + (long)DataParser.toUnsignedInt(dateBytes[1]) * 256L + (long)DataParser.toUnsignedInt(dateBytes[2]);
        int day = (int)(intval % 1000000L / 10000L);
        int month = (int)(intval / 1000000L);
        int year = (int)(intval % 10000L);
        return LocalDate.of(year, month, day);
    }

    public static LocalDateTime decodeDateTime(byte[] dateTimeBytes) {
        if (dateTimeBytes.length != 6) {
            throw new IllegalArgumentException("expected three bytes for date decoding");
        }
        BigInteger dateBigInt = new BigInteger(dateTimeBytes);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("MMddyyyyHHmmss");
        LocalDateTime localDateTime = LocalDateTime.parse(String.format("%014d", dateBigInt), pattern);
        return localDateTime;
    }

    public static List<DerTlv> parseDerTLvs(byte[] rawBytes) {
        ByteBuffer rawData = ByteBuffer.wrap(rawBytes);
        ArrayList<DerTlv> derTlvList = new ArrayList<DerTlv>();
        while (rawData.hasRemaining()) {
            byte tag = rawData.get();
            int le = rawData.get() & 0xFF;
            if (le == 129) {
                le = rawData.get() & 0xFF;
            } else if (le == 130) {
                le = (rawData.get() & 0xFF) * 256 + (rawData.get() & 0xFF);
            } else if (le == 131) {
                le = (rawData.get() & 0xFF) * 4096 + (rawData.get() & 0xFF) * 256 + (rawData.get() & 0xFF);
            } else if (le > 127) {
                Logger.error((Object)String.format("can't decode length: 0x%02X", le));
                throw new IllegalArgumentException(String.format("can't decode length: 0x%02X", le));
            }
            byte[] val = DataParser.getFromByteBuffer(rawData, le);
            derTlvList.add(new DerTlv(tag, val));
        }
        return derTlvList;
    }

    private static int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    public static String decodeC40(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < bytes.length; ++idx) {
            int temp;
            if (idx % 2 != 0) continue;
            byte i1 = bytes[idx];
            byte i2 = bytes[idx + 1];
            if (i1 == -2) {
                sb.append((char)(i2 - 1));
                continue;
            }
            int v16 = (DataParser.toUnsignedInt(i1) << 8) + DataParser.toUnsignedInt(i2) - 1;
            int u1 = temp = v16 / 1600;
            v16 -= temp * 1600;
            int u2 = temp = v16 / 40;
            int u3 = v16 - temp * 40;
            if (u1 != 0) {
                sb.append(DataParser.toChar(u1));
            }
            if (u2 != 0) {
                sb.append(DataParser.toChar(u2));
            }
            if (u3 == 0) continue;
            sb.append(DataParser.toChar(u3));
        }
        return sb.toString();
    }

    private static char toChar(int intValue) {
        if (intValue == 3) {
            return ' ';
        }
        if (intValue >= 4 && intValue <= 13) {
            return (char)(intValue + 44);
        }
        if (intValue >= 14 && intValue <= 39) {
            return (char)(intValue + 51);
        }
        return '?';
    }

    public static byte[] decodeBase256(String s) {
        char[] ca = s.toCharArray();
        byte[] ba = new byte[ca.length];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)ca[i];
        }
        return ba;
    }

    public static byte[] unzip(byte[] bytesToDecompress) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InflaterOutputStream infos = new InflaterOutputStream(bos);
        infos.write(bytesToDecompress);
        infos.finish();
        byte[] decompressedBytes = bos.toByteArray();
        bos.close();
        infos.close();
        return decompressedBytes;
    }
}

