/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import de.tsenger.vdstools.FeatureConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.util.Arrays;
import org.tinylog.Logger;

public class DataEncoder {
    private static FeatureConverter featureEncoder = null;

    public static String[] getSignerCertRef(X509Certificate cert) throws InvalidNameException {
        String[] signerCertRef = new String[2];
        LdapName ln = new LdapName(cert.getSubjectX500Principal().getName());
        String c = "";
        String cn = "";
        for (Rdn rdn : ln.getRdns()) {
            if (rdn.getType().equalsIgnoreCase("CN")) {
                cn = (String)rdn.getValue();
                Logger.debug((Object)("CN is: " + cn));
                continue;
            }
            if (!rdn.getType().equalsIgnoreCase("C")) continue;
            c = (String)rdn.getValue();
            Logger.debug((Object)("C is: " + c));
        }
        signerCertRef[0] = String.format("%s%s", c, cn).toUpperCase();
        signerCertRef[1] = cert.getSerialNumber().toString(16);
        Logger.info((Object)("generated signerCertRef: " + signerCertRef[0] + signerCertRef[1]));
        return signerCertRef;
    }

    public static byte[] encodeDate(String dateString) throws ParseException {
        LocalDate dt = LocalDate.parse(dateString);
        return DataEncoder.encodeDate(dt);
    }

    public static byte[] encodeDate(LocalDate localDate) {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("MMddyyyy");
        String formattedDate = localDate.format(pattern);
        int dateInt = Integer.parseInt(formattedDate);
        return new byte[]{(byte)(dateInt >>> 16), (byte)(dateInt >>> 8), (byte)dateInt};
    }

    public static byte[] encodeDateTime(LocalDateTime localDatetime) {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("MMddyyyyHHmmss");
        String formattedDate = localDatetime.format(pattern);
        BigInteger dateInt = new BigInteger(formattedDate);
        return dateInt.toByteArray();
    }

    public static byte[] encodeMaskedDate(String dateString) {
        if (!dateString.matches("(.{4})-(.{2})-(.{2})")) {
            throw new IllegalArgumentException("Date string must be formated as yyyy-MM-dd.");
        }
        String formattedDate = dateString.replaceAll("(.{4})-(.{2})-(.{2})", "$2$3$1").toLowerCase();
        int dateInt = Integer.parseInt(formattedDate.replaceAll("x", "0"));
        char[] dateCharArray = formattedDate.toCharArray();
        byte mask = 0;
        for (int i = 0; i < 8; ++i) {
            if (dateCharArray[i] != 'x') continue;
            mask = (byte)(mask | 128 >> i);
        }
        byte[] encodedDateString = new byte[]{mask, (byte)(dateInt >>> 16), (byte)(dateInt >>> 8), (byte)dateInt};
        return encodedDateString;
    }

    public static byte[] encodeC40(String dataString) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        dataString = dataString.toUpperCase().replaceAll("<", " ");
        int len = dataString.length();
        for (int i = 0; i < len; ++i) {
            int sum;
            int c2;
            int c1;
            if (i % 3 != 0) continue;
            if (i + 2 < len) {
                c1 = DataEncoder.getC40Value(dataString.charAt(i));
                c2 = DataEncoder.getC40Value(dataString.charAt(i + 1));
                int c3 = DataEncoder.getC40Value(dataString.charAt(i + 2));
                sum = 1600 * c1 + 40 * c2 + c3 + 1;
                out.write(sum / 256);
                out.write(sum % 256);
                continue;
            }
            if (i + 1 < len) {
                c1 = DataEncoder.getC40Value(dataString.charAt(i));
                c2 = DataEncoder.getC40Value(dataString.charAt(i + 1));
                sum = 1600 * c1 + 40 * c2 + 1;
                out.write(sum / 256);
                out.write(sum % 256);
                continue;
            }
            out.write(254);
            out.write(DataEncoder.toUnsignedInt((byte)dataString.charAt(i)) + 1);
        }
        return out.toByteArray();
    }

    private static int getC40Value(char c) {
        int value = DataEncoder.toUnsignedInt((byte)c);
        if (value == 32) {
            return 3;
        }
        if (value >= 48 && value <= 57) {
            return value - 44;
        }
        if (value >= 65 && value <= 90) {
            return value - 51;
        }
        throw new IllegalArgumentException("Not a C40 encodable char: " + c + "value: " + value);
    }

    public static int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    public static String encodeBase256(byte[] ba) {
        char[] ca = new char[ba.length];
        for (int i = 0; i < ba.length; ++i) {
            ca[i] = (char)(ba[i] & 0xFF);
        }
        return new String(ca);
    }

    public static byte[] zip(byte[] bytesToCompress) throws IOException {
        Deflater compresser = new Deflater(9);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream defos = new DeflaterOutputStream((OutputStream)bos, compresser);
        defos.write(bytesToCompress);
        defos.finish();
        byte[] compressedBytes = bos.toByteArray();
        bos.close();
        defos.close();
        Logger.debug((Object)("Zip ratio " + (float)bytesToCompress.length / (float)compressedBytes.length + ", input size " + bytesToCompress.length + ", compressed size " + compressedBytes.length));
        return compressedBytes;
    }

    public static FeatureConverter getFeatureEncoder() {
        if (featureEncoder == null) {
            featureEncoder = new FeatureConverter();
        }
        return featureEncoder;
    }

    public static void setFeatureEncoder(FeatureConverter featureEncoder) {
        DataEncoder.featureEncoder = featureEncoder;
    }

    public static byte[] buildCertificateReference(X509Certificate cert) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1", "BC");
            byte[] certSha1 = messageDigest.digest(cert.getEncoded());
            return Arrays.copyOfRange((byte[])certSha1, (int)15, (int)20);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateEncodingException e) {
            Logger.error((Object)("Failed building Certificate Reference: " + e.getMessage()));
            return null;
        }
    }
}

