/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.DerTlv;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.encoders.Hex;
import org.tinylog.Logger;

public class VdsSignature {
    public static final byte TAG = -1;
    private byte[] plainSignatureBytes;

    public VdsSignature(byte[] plainSignatureBytes) {
        this.plainSignatureBytes = plainSignatureBytes;
    }

    public byte[] getDerSignatureBytes() {
        byte[] r = new byte[this.plainSignatureBytes.length / 2];
        byte[] s = new byte[this.plainSignatureBytes.length / 2];
        System.arraycopy(this.plainSignatureBytes, 0, r, 0, r.length);
        System.arraycopy(this.plainSignatureBytes, r.length, s, 0, s.length);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, r)));
        v.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, s)));
        DERSequence derSeq = new DERSequence(v);
        byte[] derSignatureBytes = null;
        try {
            derSignatureBytes = derSeq.getEncoded();
            Logger.debug((Object)("Signature sequence bytes: 0x" + Hex.toHexString((byte[])derSignatureBytes)));
        }
        catch (IOException e) {
            Logger.error((Object)"Couldn't parse r and s to DER Sequence Signature Bytes.");
        }
        return derSignatureBytes;
    }

    public byte[] getPlainSignatureBytes() {
        return this.plainSignatureBytes;
    }

    public byte[] getEncoded() throws IOException {
        DerTlv derSignature = new DerTlv(-1, this.plainSignatureBytes);
        return derSignature.getEncoded();
    }

    public static VdsSignature fromByteArray(byte[] rawBytes) throws IOException {
        if (rawBytes[0] != -1) {
            throw new IllegalArgumentException(String.format("VdsSignature shall have tag %2X, but tag %2X was found instead.", (byte)-1, rawBytes[0]));
        }
        DerTlv derTlv = DerTlv.fromByteArray(rawBytes);
        return new VdsSignature(derTlv.getValue());
    }
}

