/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.DerTlv;
import de.tsenger.vdstools.Signer;
import de.tsenger.vdstools.vds.VdsHeader;
import de.tsenger.vdstools.vds.VdsMessage;
import de.tsenger.vdstools.vds.VdsSignature;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.tinylog.Logger;
import org.tinylog.Supplier;

public class DigitalSeal {
    private String vdsType;
    private VdsHeader vdsHeader;
    private VdsMessage vdsMessage;
    private VdsSignature vdsSignature;

    private DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = vdsSignature;
        this.vdsType = vdsHeader.getVdsType();
    }

    public DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = this.createVdsSignature(vdsHeader, vdsMessage, signer);
        this.vdsType = vdsHeader.getVdsType();
    }

    public String getVdsType() {
        return this.vdsType;
    }

    public String getIssuingCountry() {
        return this.vdsHeader.getIssuingCountry();
    }

    public String getSignerCertRef() {
        BigInteger certRefInteger = new BigInteger(this.vdsHeader.getCertificateReference(), 16);
        return String.format("%s%x", this.vdsHeader.getSignerIdentifier(), certRefInteger).toUpperCase();
    }

    public String getSignerIdentifier() {
        return this.vdsHeader.getSignerIdentifier();
    }

    public String getCertificateReference() {
        return this.vdsHeader.getCertificateReference();
    }

    public LocalDate getIssuingDate() {
        return this.vdsHeader.getIssuingDate();
    }

    public LocalDate getSigDate() {
        return this.vdsHeader.getSigDate();
    }

    public byte getDocFeatureRef() {
        return this.vdsHeader.getDocFeatureRef();
    }

    public byte getDocTypeCat() {
        return this.vdsHeader.getDocTypeCat();
    }

    public byte[] getHeaderAndMessageBytes() {
        return Arrays.concatenate((byte[])this.vdsHeader.getEncoded(), (byte[])this.vdsMessage.getEncoded());
    }

    public byte[] getEncoded() throws IOException {
        return Arrays.concatenate((byte[])this.vdsHeader.getEncoded(), (byte[])this.vdsMessage.getEncoded(), (byte[])this.vdsSignature.getEncoded());
    }

    public byte[] getSignatureBytes() {
        return this.vdsSignature.getPlainSignatureBytes();
    }

    public String getRawString() throws IOException {
        return DataEncoder.encodeBase256(this.getEncoded());
    }

    public <T> T getFeature(String feature) {
        return this.vdsMessage.getDocumentFeature(feature);
    }

    public static DigitalSeal fromRawString(String rawString) {
        DigitalSeal seal = null;
        try {
            seal = DigitalSeal.parseVdsSeal(DataParser.decodeBase256(rawString));
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage());
        }
        return seal;
    }

    public static DigitalSeal fromByteArray(byte[] rawBytes) {
        DigitalSeal seal = null;
        try {
            seal = DigitalSeal.parseVdsSeal(rawBytes);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage());
        }
        return seal;
    }

    private static DigitalSeal parseVdsSeal(byte[] rawBytes) throws IOException {
        ByteBuffer rawData = ByteBuffer.wrap(rawBytes);
        Logger.trace((String)"rawData: {}", (Supplier[])new Supplier[]{() -> Hex.toHexString((byte[])rawBytes)});
        VdsHeader vdsHeader = VdsHeader.fromByteBuffer(rawData);
        VdsSignature vdsSignature = null;
        int messageStartPosition = rawData.position();
        List<DerTlv> derTlvList = DataParser.parseDerTLvs(Arrays.copyOfRange((byte[])rawBytes, (int)messageStartPosition, (int)rawBytes.length));
        ArrayList<DerTlv> featureList = new ArrayList<DerTlv>(derTlvList.size() - 1);
        for (DerTlv derTlv : derTlvList) {
            if (derTlv.getTag() == -1) {
                vdsSignature = VdsSignature.fromByteArray(derTlv.getEncoded());
                continue;
            }
            featureList.add(derTlv);
        }
        VdsMessage vdsMessage = new VdsMessage(vdsHeader.getVdsType(), featureList);
        return new DigitalSeal(vdsHeader, vdsMessage, vdsSignature);
    }

    private VdsSignature createVdsSignature(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        byte[] headerMessage = Arrays.concatenate((byte[])vdsHeader.getEncoded(), (byte[])vdsMessage.getEncoded());
        try {
            byte[] signatureBytes = signer.sign(headerMessage);
            return new VdsSignature(signatureBytes);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            Logger.error((Object)("Signature creation failed: " + e.getMessage()));
            return null;
        }
    }
}

