/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.DerTlv;
import de.tsenger.vdstools.idb.IdbHeader;
import de.tsenger.vdstools.idb.IdbMessageGroup;
import de.tsenger.vdstools.idb.IdbSignature;
import de.tsenger.vdstools.idb.IdbSignerCertificate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import org.tinylog.Logger;

public class IdbPayload {
    private IdbHeader idbHeader;
    private IdbMessageGroup idbMessageGroup;
    private IdbSignerCertificate idbSignerCertificate;
    private IdbSignature idbSignature;

    public IdbPayload(IdbHeader idbHeader, IdbMessageGroup idbMessageGroup, IdbSignerCertificate idbSignerCertificate, IdbSignature idbSignature) {
        this.idbHeader = idbHeader;
        this.idbMessageGroup = idbMessageGroup;
        this.idbSignerCertificate = idbSignerCertificate;
        this.idbSignature = idbSignature;
    }

    public IdbHeader getIdbHeader() {
        return this.idbHeader;
    }

    public IdbMessageGroup getIdbMessageGroup() {
        return this.idbMessageGroup;
    }

    public IdbSignerCertificate getIdbSignerCertificate() {
        return this.idbSignerCertificate;
    }

    public IdbSignature getIdbSignature() {
        return this.idbSignature;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.idbHeader.getEncoded());
        bos.write(this.idbMessageGroup.getEncoded());
        if (this.idbSignerCertificate != null) {
            bos.write(this.idbMessageGroup.getEncoded());
        }
        if (this.idbSignature != null) {
            bos.write(this.idbSignature.getEncoded());
        } else if (this.idbHeader.getSignatureAlgorithm() != null) {
            Logger.error((Object)"Missing Signature Field! This field should be present if a signature algorithm has been specified in the header.");
            return null;
        }
        return bos.toByteArray();
    }

    public static IdbPayload fromByteArray(byte[] rawBytes, boolean isSigned) throws CertificateException, IOException {
        IdbHeader idbHeader = null;
        IdbMessageGroup idbMessageGroup = null;
        IdbSignerCertificate idbSignerCertificate = null;
        IdbSignature idbSignature = null;
        int offset = 0;
        idbHeader = isSigned ? IdbHeader.fromByteArray(Arrays.copyOfRange(rawBytes, offset, offset += 12)) : IdbHeader.fromByteArray(Arrays.copyOfRange(rawBytes, offset, offset += 2));
        List<DerTlv> derTlvList = DataParser.parseDerTLvs(Arrays.copyOfRange(rawBytes, offset, rawBytes.length));
        block5: for (DerTlv derTlv : derTlvList) {
            switch (derTlv.getTag()) {
                case 97: {
                    idbMessageGroup = IdbMessageGroup.fromByteArray(derTlv.getEncoded());
                    continue block5;
                }
                case 126: {
                    idbSignerCertificate = IdbSignerCertificate.fromByteArray(derTlv.getEncoded());
                    continue block5;
                }
                case 127: {
                    idbSignature = IdbSignature.fromByteArray(derTlv.getEncoded());
                    continue block5;
                }
            }
            throw new IllegalArgumentException(String.format("Found unknown tag %2X in IdbPayload!", derTlv.getTag()));
        }
        return new IdbPayload(idbHeader, idbMessageGroup, idbSignerCertificate, idbSignature);
    }
}

