/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import java.util.HashMap;

public enum IdbMessageType {
    VISA(1),
    EMERGENCY_TRAVEL_DOCUMENT(2),
    PROOF_OF_TESTING(3),
    PROOF_OF_VACCINATION(4),
    PROOF_OF_RECOVERY(5),
    DIGITALTRAVEL_AUTHORIZATION(6),
    MRZ_TD1(7),
    MRZ_TD3(8),
    CAN(9),
    EF_CARDACCESS(10);

    private final byte reference;
    private static HashMap<Byte, IdbMessageType> map;

    private IdbMessageType(byte reference) {
        this.reference = reference;
    }

    public static IdbMessageType valueOf(byte messageTag) {
        return map.get(messageTag);
    }

    public byte getValue() {
        return this.reference;
    }

    static {
        map = new HashMap();
        for (IdbMessageType messageType : IdbMessageType.values()) {
            map.put(messageType.reference, messageType);
        }
    }
}

