/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.DerTlv;
import de.tsenger.vdstools.idb.IdbMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IdbMessageGroup {
    public static final byte TAG = 97;
    private List<IdbMessage> messagesList = new ArrayList<IdbMessage>();

    public IdbMessageGroup() {
    }

    public IdbMessageGroup(IdbMessage idbMessage) {
        this.addMessage(idbMessage);
    }

    public void addMessage(IdbMessage idbMessage) {
        this.messagesList.add(idbMessage);
    }

    public List<IdbMessage> getMessagesList() {
        return this.messagesList;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream messages = new ByteArrayOutputStream();
        for (IdbMessage message : this.messagesList) {
            messages.write(message.getEncoded());
        }
        return new DerTlv(97, messages.toByteArray()).getEncoded();
    }

    public static IdbMessageGroup fromByteArray(byte[] rawBytes) throws IOException {
        if (rawBytes[0] != 97) {
            throw new IllegalArgumentException(String.format("IdbMessageGroup shall have tag %2X, but tag %2X was found instead.", (byte)97, rawBytes[0]));
        }
        rawBytes = DerTlv.fromByteArray(rawBytes).getValue();
        IdbMessageGroup messageGroup = new IdbMessageGroup();
        List<DerTlv> derTlvMessagesList = DataParser.parseDerTLvs(rawBytes);
        for (DerTlv derTlvMessage : derTlvMessagesList) {
            messageGroup.addMessage(IdbMessage.fromDerTlv(derTlvMessage));
        }
        return messageGroup;
    }
}

