/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.tinylog.Logger;

public class Signer {
    private BCECPrivateKey ecPrivKey;

    public Signer(ECPrivateKey privKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        this.ecPrivKey = (BCECPrivateKey)privKey;
    }

    public Signer(KeyStore keyStore, String keyStorePassword, String keyAlias) {
        try {
            this.ecPrivKey = (BCECPrivateKey)keyStore.getKey(keyAlias, keyStorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            Logger.error((Object)("getPrivateKeyByAlias failed: " + e.getMessage()));
        }
    }

    public int getFieldSize() {
        return this.ecPrivKey.getParameters().getCurve().getFieldSize();
    }

    public byte[] sign(byte[] dataToSign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidAlgorithmParameterException, IOException, NoSuchProviderException {
        Signature ecdsaSign;
        if (this.ecPrivKey == null) {
            throw new InvalidKeyException("private key not initialized. Load from file or generate new one.");
        }
        int fieldBitLength = this.getFieldSize();
        if (fieldBitLength <= 224) {
            ecdsaSign = Signature.getInstance("SHA224withPLAIN-ECDSA", "BC");
        } else if (fieldBitLength <= 256) {
            ecdsaSign = Signature.getInstance("SHA256withPLAIN-ECDSA", "BC");
        } else if (fieldBitLength <= 384) {
            ecdsaSign = Signature.getInstance("SHA384withPLAIN-ECDSA", "BC");
        } else if (fieldBitLength <= 512) {
            ecdsaSign = Signature.getInstance("SHA512withPLAIN-ECDSA", "BC");
        } else {
            Logger.error((Object)("Bit length of Field is out of definied value: " + fieldBitLength));
            throw new InvalidAlgorithmParameterException("Bit length of Field is out of definied value (224 to 512 bits): " + fieldBitLength);
        }
        Logger.info((Object)("ECDSA algorithm: " + ecdsaSign.getAlgorithm()));
        ecdsaSign.initSign((PrivateKey)this.ecPrivKey);
        ecdsaSign.update(dataToSign);
        return ecdsaSign.sign();
    }
}

