/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import java.util.HashMap;

public enum VdsType {
    ARRIVAL_ATTESTATION(64770),
    ICAO_EMERGENCY_TRAVEL_DOCUMENT(24067),
    ICAO_VISA(23809),
    ADDRESS_STICKER_PASSPORT(63498),
    ADDRESS_STICKER_ID(63752),
    RESIDENCE_PERMIT(64262),
    SOCIAL_INSURANCE_CARD(64516),
    SUPPLEMENTARY_SHEET(64006),
    ALIENS_LAW(510),
    TEMP_PASSPORT(62989),
    TEMP_PERSO(63243),
    FICTION_CERT(62732);

    private final int reference;
    private static HashMap<Integer, VdsType> map;

    private VdsType(int reference) {
        this.reference = reference;
    }

    public static VdsType valueOf(int vdsType) {
        return map.get(vdsType);
    }

    public int getValue() {
        return this.reference;
    }

    static {
        map = new HashMap();
        for (VdsType vdsType : VdsType.values()) {
            map.put(vdsType.reference, vdsType);
        }
    }
}

