/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.encoders.Hex;
import org.tinylog.Logger;

public class VdsSignature {
    private byte[] rawSignatureBytes;
    private byte[] signatureBytes = null;

    public VdsSignature(byte[] rawSignatureBytes) {
        this.rawSignatureBytes = rawSignatureBytes;
        this.parseSignature(rawSignatureBytes);
    }

    public byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public byte[] getRawSignatureBytes() {
        return this.rawSignatureBytes;
    }

    public byte[] getRawBytes() throws IOException {
        return DataEncoder.buildTLVStructure((byte)-1, this.rawSignatureBytes);
    }

    private void parseSignature(byte[] rsBytes) {
        byte[] r = new byte[rsBytes.length / 2];
        byte[] s = new byte[rsBytes.length / 2];
        System.arraycopy(rsBytes, 0, r, 0, r.length);
        System.arraycopy(rsBytes, r.length, s, 0, s.length);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, r)));
        v.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, s)));
        DERSequence derSeq = new DERSequence(v);
        try {
            this.signatureBytes = derSeq.getEncoded();
            Logger.debug((Object)("Signature sequence bytes: 0x" + Hex.toHexString((byte[])this.signatureBytes)));
        }
        catch (IOException e) {
            Logger.error((Object)"Couldn't parse r and s to signatureBytes.");
        }
    }
}

