/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.seals.AddressStickerIdCard;
import de.tsenger.vdstools.seals.AddressStickerPass;
import de.tsenger.vdstools.seals.AliensLaw;
import de.tsenger.vdstools.seals.ArrivalAttestation;
import de.tsenger.vdstools.seals.Feature;
import de.tsenger.vdstools.seals.FictionCert;
import de.tsenger.vdstools.seals.IcaoEmergencyTravelDocument;
import de.tsenger.vdstools.seals.IcaoVisa;
import de.tsenger.vdstools.seals.MessageTlv;
import de.tsenger.vdstools.seals.ResidencePermit;
import de.tsenger.vdstools.seals.SocialInsuranceCard;
import de.tsenger.vdstools.seals.SupplementarySheet;
import de.tsenger.vdstools.seals.TempPassport;
import de.tsenger.vdstools.seals.TempPerso;
import de.tsenger.vdstools.seals.VdsType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.tinylog.Logger;

public class VdsMessage {
    private List<MessageTlv> messageTlvList;
    private HashMap<Feature, Object> featureMap = new LinkedHashMap<Feature, Object>(2);
    private VdsType vdsType = null;

    public VdsMessage(List<MessageTlv> messageTlvList) {
        this.messageTlvList = (ArrayList)messageTlvList;
    }

    public VdsMessage(VdsType vdsType) {
        this.vdsType = vdsType;
        this.messageTlvList = new ArrayList<MessageTlv>(5);
    }

    public VdsType getVdsType() {
        return this.vdsType;
    }

    public byte[] getRawBytes() {
        if (!this.featureMap.isEmpty()) {
            if (this.messageTlvList.size() != 0) {
                Logger.warn((Object)("messageTlvList for " + this.vdsType.name() + " is NOT empty(size: " + this.messageTlvList.size() + ")! Parsing featureMap will override messageTlvList."));
            }
            this.parseFeatures();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (MessageTlv feature : this.messageTlvList) {
                baos.write(DataEncoder.buildTLVStructure(feature.getTag(), feature.getValue()));
            }
        }
        catch (IOException e) {
            Logger.error((Object)("Can't build raw bytes: " + e.getMessage()));
            return new byte[0];
        }
        return baos.toByteArray();
    }

    private void parseFeatures() {
        switch (this.vdsType) {
            case RESIDENCE_PERMIT: {
                this.messageTlvList = ResidencePermit.parseFeatures(this.featureMap);
                break;
            }
            case ADDRESS_STICKER_ID: {
                this.messageTlvList = AddressStickerIdCard.parseFeatures(this.featureMap);
                break;
            }
            case ADDRESS_STICKER_PASSPORT: {
                this.messageTlvList = AddressStickerPass.parseFeatures(this.featureMap);
                break;
            }
            case ALIENS_LAW: {
                this.messageTlvList = AliensLaw.parseFeatures(this.featureMap);
                break;
            }
            case ARRIVAL_ATTESTATION: {
                this.messageTlvList = ArrivalAttestation.parseFeatures(this.featureMap);
                break;
            }
            case FICTION_CERT: {
                this.messageTlvList = FictionCert.parseFeatures(this.featureMap);
                break;
            }
            case ICAO_EMERGENCY_TRAVEL_DOCUMENT: {
                this.messageTlvList = IcaoEmergencyTravelDocument.parseFeatures(this.featureMap);
                break;
            }
            case ICAO_VISA: {
                this.messageTlvList = IcaoVisa.parseFeatures(this.featureMap);
                break;
            }
            case SOCIAL_INSURANCE_CARD: {
                try {
                    this.messageTlvList = SocialInsuranceCard.parseFeatures(this.featureMap);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.error((Object)("Couldn't build VdsMessage for SocialInsuranceCard: " + e.getMessage()));
                }
                break;
            }
            case SUPPLEMENTARY_SHEET: {
                this.messageTlvList = SupplementarySheet.parseFeatures(this.featureMap);
                break;
            }
            case TEMP_PASSPORT: {
                this.messageTlvList = TempPassport.parseFeatures(this.featureMap);
                break;
            }
            case TEMP_PERSO: {
                this.messageTlvList = TempPerso.parseFeatures(this.featureMap);
                break;
            }
            default: {
                Logger.warn((Object)("unknown VdsType: " + (Object)((Object)this.vdsType)));
            }
        }
    }

    public void addMessageTlv(MessageTlv tlv) {
        this.messageTlvList.add(tlv);
    }

    public List<MessageTlv> getMessageTlvList() {
        return this.messageTlvList;
    }

    public void addDocumentFeature(Feature feature, Object obj) {
        this.featureMap.put(feature, obj);
    }
}

