/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.seals.VdsType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import org.tinylog.Logger;

public class VdsHeader {
    public static final byte DC = -36;
    private byte[] rawBytes = null;
    public String issuingCountry;
    public String signerIdentifier;
    public String certificateReference;
    public LocalDate issuingDate;
    public LocalDate sigDate;
    public byte docFeatureRef;
    public byte docTypeCat;
    public byte rawVersion;

    public int getDocumentRef() {
        return ((this.docFeatureRef & 0xFF) << 8) + (this.docTypeCat & 0xFF);
    }

    public void setDocumentType(VdsType vdsType) {
        this.docFeatureRef = (byte)(vdsType.getValue() >> 8 & 0xFF);
        this.docTypeCat = (byte)(vdsType.getValue() & 0xFF);
    }

    public VdsType getVdsType() {
        return VdsType.valueOf(this.getDocumentRef());
    }

    public byte[] getRawBytes() {
        if (this.rawBytes == null) {
            this.encode();
        }
        return this.rawBytes;
    }

    private void encode() {
        if (this.sigDate == null) {
            this.sigDate = LocalDate.now();
        }
        if (this.issuingDate == null) {
            this.issuingDate = LocalDate.now();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(-36);
            baos.write(this.rawVersion);
            baos.write(DataEncoder.encodeC40(this.issuingCountry));
            baos.write(DataEncoder.encodeC40(this.getEncodedSignerIdentifierandCertificateReference()));
            baos.write(DataEncoder.encodeDate(this.issuingDate));
            baos.write(DataEncoder.encodeDate(this.sigDate));
            baos.write(this.docFeatureRef);
            baos.write(this.docTypeCat);
        }
        catch (IOException e) {
            Logger.error((Object)("Error while encoding header data: " + e.getMessage()));
        }
        this.rawBytes = baos.toByteArray();
    }

    private String getEncodedSignerIdentifierandCertificateReference() {
        if (this.rawVersion == 2) {
            return String.format("%s%5s", this.signerIdentifier, this.certificateReference).toUpperCase().replace(' ', '0');
        }
        if (this.rawVersion == 3) {
            return String.format("%s%02x%s", this.signerIdentifier, this.certificateReference.length(), this.certificateReference).toUpperCase();
        }
        return "";
    }

    public String toString() {
        return "rawVersion: " + (this.rawVersion & 0xFF) + "\nissuingCountry: " + this.issuingCountry + "\nsignerIdentifier: " + this.signerIdentifier + "\ncertificateReference: " + this.certificateReference + "\nissuingDate: " + this.issuingDate + "\nsigDate: " + this.sigDate + "\ndocFeatureRef: " + String.format("%02X ", this.docFeatureRef) + ", docTypeCat: " + String.format("%02X ", this.docTypeCat);
    }
}

