/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.seals.DigitalSeal;
import de.tsenger.vdstools.seals.Feature;
import de.tsenger.vdstools.seals.MessageTlv;
import de.tsenger.vdstools.seals.VdsHeader;
import de.tsenger.vdstools.seals.VdsMessage;
import de.tsenger.vdstools.seals.VdsSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tinylog.Logger;

public class SupplementarySheet
extends DigitalSeal {
    public SupplementarySheet(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        super(vdsHeader, vdsMessage, vdsSignature);
        this.parseMessageTlvList(vdsMessage.getMessageTlvList());
    }

    private void parseMessageTlvList(List<MessageTlv> tlvList) {
        block4: for (MessageTlv tlv : tlvList) {
            switch (tlv.getTag()) {
                case 4: {
                    String mrz = DataParser.decodeC40(tlv.getValue()).replace(' ', '<');
                    StringBuilder sb = new StringBuilder(mrz);
                    sb.insert(36, '\n');
                    this.featureMap.put(Feature.MRZ, sb.toString());
                    continue block4;
                }
                case 5: {
                    String suppSheetNumber = DataParser.decodeC40(tlv.getValue());
                    this.featureMap.put(Feature.SHEET_NUMBER, suppSheetNumber);
                    continue block4;
                }
            }
            Logger.warn((Object)("found unknown tag: 0x" + String.format("%02X ", tlv.getTag())));
        }
    }

    public static List<MessageTlv> parseFeatures(Map<Feature, Object> featureMap) {
        ArrayList<MessageTlv> messageTlvList = new ArrayList<MessageTlv>(featureMap.size());
        block4: for (Map.Entry<Feature, Object> entry : featureMap.entrySet()) {
            switch (entry.getKey()) {
                case MRZ: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = DataEncoder.encodeC40(valueStr);
                    messageTlvList.add(new MessageTlv(4, valueBytes.length, valueBytes));
                    continue block4;
                }
                case SHEET_NUMBER: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = DataEncoder.encodeC40(valueStr);
                    messageTlvList.add(new MessageTlv(5, valueBytes.length, valueBytes));
                    continue block4;
                }
            }
            Logger.warn((Object)("Feature " + entry.getKey().toString() + " is not supported in ResidencePermit."));
        }
        return messageTlvList;
    }
}

