/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.seals.DigitalSeal;
import de.tsenger.vdstools.seals.Feature;
import de.tsenger.vdstools.seals.MessageTlv;
import de.tsenger.vdstools.seals.VdsHeader;
import de.tsenger.vdstools.seals.VdsMessage;
import de.tsenger.vdstools.seals.VdsSignature;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tinylog.Logger;

public class SocialInsuranceCard
extends DigitalSeal {
    public SocialInsuranceCard(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        super(vdsHeader, vdsMessage, vdsSignature);
        this.parseMessageTlvList(vdsMessage.getMessageTlvList());
    }

    private void parseMessageTlvList(List<MessageTlv> tlvList) throws IllegalArgumentException {
        block6: for (MessageTlv tlv : tlvList) {
            switch (tlv.getTag()) {
                case 1: {
                    String socialInsuranceNumber = DataParser.decodeC40(tlv.getValue());
                    this.featureMap.put(Feature.SOCIAL_INSURANCE_NUMBER, socialInsuranceNumber);
                    continue block6;
                }
                case 2: {
                    String surName = new String(tlv.getValue(), StandardCharsets.UTF_8);
                    this.featureMap.put(Feature.SURNAME, surName);
                    continue block6;
                }
                case 3: {
                    String firstName = new String(tlv.getValue(), StandardCharsets.UTF_8);
                    this.featureMap.put(Feature.FIRST_NAME, firstName);
                    continue block6;
                }
                case 4: {
                    String birthName = new String(tlv.getValue(), StandardCharsets.UTF_8);
                    this.featureMap.put(Feature.BIRTH_NAME, birthName);
                    continue block6;
                }
            }
            Logger.warn((Object)("found unknown tag: 0x" + String.format("%02X ", tlv.getTag())));
        }
    }

    public static List<MessageTlv> parseFeatures(Map<Feature, Object> featureMap) throws UnsupportedEncodingException {
        ArrayList<MessageTlv> messageTlvList = new ArrayList<MessageTlv>(featureMap.size());
        block6: for (Map.Entry<Feature, Object> entry : featureMap.entrySet()) {
            switch (entry.getKey()) {
                case SOCIAL_INSURANCE_NUMBER: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = DataEncoder.encodeC40(valueStr);
                    messageTlvList.add(new MessageTlv(1, valueBytes.length, valueBytes));
                    continue block6;
                }
                case SURNAME: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = valueStr.getBytes("UTF-8");
                    messageTlvList.add(new MessageTlv(2, valueBytes.length, valueBytes));
                    continue block6;
                }
                case FIRST_NAME: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = valueStr.getBytes("UTF-8");
                    messageTlvList.add(new MessageTlv(3, valueBytes.length, valueBytes));
                    continue block6;
                }
                case BIRTH_NAME: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = valueStr.getBytes("UTF-8");
                    messageTlvList.add(new MessageTlv(4, valueBytes.length, valueBytes));
                    continue block6;
                }
            }
            Logger.warn((Object)("Feature " + entry.getKey().toString() + " is not supported in ResidencePermit."));
        }
        return messageTlvList;
    }
}

