/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.seals.DigitalSeal;
import de.tsenger.vdstools.seals.Feature;
import de.tsenger.vdstools.seals.MessageTlv;
import de.tsenger.vdstools.seals.VdsHeader;
import de.tsenger.vdstools.seals.VdsMessage;
import de.tsenger.vdstools.seals.VdsSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tinylog.Logger;

public class IcaoVisa
extends DigitalSeal {
    public IcaoVisa(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        super(vdsHeader, vdsMessage, vdsSignature);
        this.parseMessageTlvList(vdsMessage.getMessageTlvList());
    }

    private void parseMessageTlvList(List<MessageTlv> tlvList) {
        block9: for (MessageTlv tlv : tlvList) {
            switch (tlv.getTag()) {
                case 1: {
                    String short_mrz = DataParser.decodeC40(tlv.getValue()).replace(' ', '<');
                    String mrz = String.format("%1$-88s", short_mrz).replace(' ', '<');
                    StringBuilder sb = new StringBuilder(mrz);
                    sb.insert(44, '\n');
                    this.featureMap.put(Feature.MRZ, sb.toString());
                    continue block9;
                }
                case 2: {
                    String short_mrz = DataParser.decodeC40(tlv.getValue()).replace(' ', '<');
                    String mrz = String.format("%1$-72s", short_mrz).replace(' ', '<');
                    StringBuilder sb = new StringBuilder(mrz);
                    sb.insert(36, '\n');
                    this.featureMap.put(Feature.MRZ, sb.toString());
                    continue block9;
                }
                case 3: {
                    int numberOfEntries = tlv.getValue()[0] & 0xFF;
                    this.featureMap.put(Feature.NUMBER_OF_ENTRIES, numberOfEntries);
                    continue block9;
                }
                case 4: {
                    this.decodeDuration(tlv.getValue());
                    continue block9;
                }
                case 5: {
                    String passportNumber = DataParser.decodeC40(tlv.getValue());
                    this.featureMap.put(Feature.PASSPORT_NUMBER, passportNumber);
                    continue block9;
                }
                case 6: {
                    byte[] visaType = tlv.getValue();
                    this.featureMap.put(Feature.VISA_TYPE, visaType);
                    continue block9;
                }
                case 7: {
                    byte[] additionalFeatures = tlv.getValue();
                    this.featureMap.put(Feature.ADDITIONAL_FEATURES, additionalFeatures);
                    continue block9;
                }
            }
            Logger.warn((Object)("found unknown tag: 0x" + String.format("%02X ", tlv.getTag())));
        }
    }

    private void decodeDuration(byte[] bytes) {
        if (bytes.length != 3) {
            throw new IllegalArgumentException("expected three bytes for date decoding");
        }
        int durationOfStay_days = bytes[0] & 0xFF;
        int durationOfStay_months = bytes[1] & 0xFF;
        int durationOfStay_years = bytes[2] & 0xFF;
        this.featureMap.put(Feature.DURATION_OF_STAY_YEARS, durationOfStay_years);
        this.featureMap.put(Feature.DURATION_OF_STAY_MONTHS, durationOfStay_months);
        this.featureMap.put(Feature.DURATION_OF_STAY_DAYS, durationOfStay_days);
    }

    public static List<MessageTlv> parseFeatures(Map<Feature, Object> featureMap) {
        ArrayList<MessageTlv> messageTlvList = new ArrayList<MessageTlv>(featureMap.size());
        byte[] durationBytes = new byte[3];
        block11: for (Map.Entry<Feature, Object> entry : featureMap.entrySet()) {
            switch (entry.getKey()) {
                case MRZ: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = DataEncoder.encodeC40(valueStr);
                    messageTlvList.add(new MessageTlv(2, valueBytes.length, valueBytes));
                    continue block11;
                }
                case NUMBER_OF_ENTRIES: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = DataEncoder.encodeC40(valueStr);
                    messageTlvList.add(new MessageTlv(3, valueBytes.length, valueBytes));
                    continue block11;
                }
                case DURATION_OF_STAY_DAYS: {
                    durationBytes[0] = (byte)((Byte)entry.getValue() & 0xFF);
                    continue block11;
                }
                case DURATION_OF_STAY_MONTHS: {
                    durationBytes[1] = (byte)((Byte)entry.getValue() & 0xFF);
                    continue block11;
                }
                case DURATION_OF_STAY_YEARS: {
                    durationBytes[2] = (byte)((Byte)entry.getValue() & 0xFF);
                    continue block11;
                }
                case DURATION_OF_STAY_RAWBYTES: {
                    durationBytes = (byte[])entry.getValue();
                    continue block11;
                }
                case PASSPORT_NUMBER: {
                    String valueStr = ((String)entry.getValue()).replaceAll("\r", "").replaceAll("\n", "");
                    byte[] valueBytes = DataEncoder.encodeC40(valueStr);
                    messageTlvList.add(new MessageTlv(5, valueBytes.length, valueBytes));
                    continue block11;
                }
                case VISA_TYPE: {
                    byte[] valueBytes = (byte[])entry.getValue();
                    messageTlvList.add(new MessageTlv(6, valueBytes.length, valueBytes));
                    continue block11;
                }
                case ADDITIONAL_FEATURES: {
                    byte[] valueBytes = (byte[])entry.getValue();
                    messageTlvList.add(new MessageTlv(7, valueBytes.length, valueBytes));
                    continue block11;
                }
            }
            Logger.warn((Object)("Feature " + entry.getKey().toString() + " is not supported in ResidencePermit."));
        }
        messageTlvList.add(new MessageTlv(4, durationBytes.length, durationBytes));
        return messageTlvList;
    }
}

