/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.seals;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.Signer;
import de.tsenger.vdstools.seals.Feature;
import de.tsenger.vdstools.seals.MessageTlv;
import de.tsenger.vdstools.seals.VdsHeader;
import de.tsenger.vdstools.seals.VdsMessage;
import de.tsenger.vdstools.seals.VdsSignature;
import de.tsenger.vdstools.seals.VdsType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.EnumMap;
import java.util.List;
import org.bouncycastle.util.Arrays;

public class DigitalSeal {
    private VdsType vdsType;
    private VdsHeader vdsHeader;
    private VdsMessage vdsMessage;
    private VdsSignature vdsSignature;
    private String rawString;
    protected EnumMap<Feature, Object> featureMap = new EnumMap(Feature.class);

    public DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = vdsSignature;
        this.vdsType = VdsType.valueOf(vdsHeader.getDocumentRef());
    }

    public static DigitalSeal getInstance(String rawString) {
        DigitalSeal seal = DataParser.parseVdsSeal(rawString);
        seal.rawString = rawString;
        return seal;
    }

    public static DigitalSeal getInstance(VdsMessage vdsMessage, X509Certificate cert, Signer signer) {
        DigitalSeal seal = DataEncoder.buildDigitalSeal(vdsMessage, cert, signer);
        return seal;
    }

    public static DigitalSeal getInstance(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        DigitalSeal seal = DataEncoder.buildDigitalSeal(vdsHeader, vdsMessage, signer);
        return seal;
    }

    public VdsType getVdsType() {
        return this.vdsType;
    }

    public List<MessageTlv> getMessageTlvList() {
        return this.vdsMessage.getMessageTlvList();
    }

    public EnumMap<Feature, Object> getFeatureMap() {
        return this.featureMap.clone();
    }

    public String getIssuingCountry() {
        return this.vdsHeader.issuingCountry;
    }

    public String getSignerCertRef() {
        BigInteger certRefInteger = new BigInteger(this.vdsHeader.certificateReference, 16);
        return String.format("%s%x", this.vdsHeader.signerIdentifier, certRefInteger).toUpperCase();
    }

    public String getSignerIdentifier() {
        return this.vdsHeader.signerIdentifier;
    }

    public String getCertificateReference() {
        return this.vdsHeader.certificateReference;
    }

    public LocalDate getIssuingDate() {
        return this.vdsHeader.issuingDate;
    }

    public LocalDate getSigDate() {
        return this.vdsHeader.sigDate;
    }

    public byte getDocFeatureRef() {
        return this.vdsHeader.docFeatureRef;
    }

    public byte getDocTypeCat() {
        return this.vdsHeader.docTypeCat;
    }

    public byte[] getHeaderAndMessageBytes() {
        return Arrays.concatenate((byte[])this.vdsHeader.getRawBytes(), (byte[])this.vdsMessage.getRawBytes());
    }

    public byte[] getEncodedBytes() throws IOException {
        return Arrays.concatenate((byte[])this.vdsHeader.getRawBytes(), (byte[])this.vdsMessage.getRawBytes(), (byte[])this.vdsSignature.getRawBytes());
    }

    public byte[] getSignatureBytes() {
        return this.vdsSignature.getSignatureBytes();
    }

    public String getRawString() {
        return this.rawString;
    }

    public Object getFeature(Feature feature) {
        try {
            return this.featureMap.get((Object)feature);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFeature(Feature feature, Object object) {
        this.featureMap.put(feature, object);
    }
}

