/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import de.tsenger.vdstools.seals.DigitalSeal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.tinylog.Logger;

public class Verifier {
    private ECPublicKey ecPubKey;
    private int keySize = 256;
    private byte[] messageBytes;
    private byte[] signatureBytes;
    String signaturAlgorithmName = "SHA256WITHECDSA";

    public Verifier(DigitalSeal digitalSeal, X509Certificate sealSignerCertificate) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (!(sealSignerCertificate.getPublicKey() instanceof ECPublicKey)) {
            throw new IllegalArgumentException("Certificate should contain EC public key!");
        }
        this.ecPubKey = (ECPublicKey)sealSignerCertificate.getPublicKey();
        this.keySize = this.ecPubKey.getParams().getCurve().getField().getFieldSize();
        this.messageBytes = digitalSeal.getHeaderAndMessageBytes();
        this.signatureBytes = digitalSeal.getSignatureBytes();
        Logger.debug((String)"Public Key bytes: 0x{}", (Object[])new Object[]{Hex.toHexString((byte[])this.ecPubKey.getEncoded())});
        Logger.debug((String)"Public Key size: {}", (Object[])new Object[]{this.keySize});
        Logger.debug((String)"Message bytes: {}", (Object[])new Object[]{Hex.toHexString((byte[])this.messageBytes)});
        Logger.debug((String)"Signature bytes: {}", (Object[])new Object[]{Hex.toHexString((byte[])this.signatureBytes)});
    }

    public Result verify() {
        if (this.signatureBytes[1] > 70) {
            this.signaturAlgorithmName = "SHA384WITHECDSA";
        } else if (this.signatureBytes[1] < 63) {
            this.signaturAlgorithmName = "SHA224WITHECDSA";
        }
        try {
            Signature ecdsaVerify = Signature.getInstance(this.signaturAlgorithmName, "BC");
            ecdsaVerify.initVerify(this.ecPubKey);
            ecdsaVerify.update(this.messageBytes);
            if (ecdsaVerify.verify(this.signatureBytes)) {
                return Result.SignatureValid;
            }
            return Result.SignatureInvalid;
        }
        catch (NoSuchAlgorithmException e1) {
            Logger.error((String)"NoSuchAlgorithmException: {}", (Object[])new Object[]{e1.getLocalizedMessage()});
            return Result.VerifyError;
        }
        catch (InvalidKeyException e2) {
            Logger.error((String)"InvalidKeyException: {}", (Object[])new Object[]{e2.getLocalizedMessage()});
            return Result.VerifyError;
        }
        catch (SignatureException e3) {
            Logger.error((String)"SignatureException: {}", (Object[])new Object[]{e3.getLocalizedMessage()});
            return Result.VerifyError;
        }
        catch (NoSuchProviderException e4) {
            Logger.error((String)"NoSuchProviderException: {}", (Object[])new Object[]{e4.getLocalizedMessage()});
            return Result.VerifyError;
        }
    }

    public static enum Result {
        SignatureValid,
        SignatureInvalid,
        VerifyError;

    }
}

