/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import de.tsenger.vdstools.seals.AddressStickerIdCard;
import de.tsenger.vdstools.seals.AddressStickerPass;
import de.tsenger.vdstools.seals.AliensLaw;
import de.tsenger.vdstools.seals.ArrivalAttestation;
import de.tsenger.vdstools.seals.DigitalSeal;
import de.tsenger.vdstools.seals.FictionCert;
import de.tsenger.vdstools.seals.IcaoEmergencyTravelDocument;
import de.tsenger.vdstools.seals.IcaoVisa;
import de.tsenger.vdstools.seals.MessageTlv;
import de.tsenger.vdstools.seals.ResidencePermit;
import de.tsenger.vdstools.seals.SocialInsuranceCard;
import de.tsenger.vdstools.seals.SupplementarySheet;
import de.tsenger.vdstools.seals.TempPassport;
import de.tsenger.vdstools.seals.TempPerso;
import de.tsenger.vdstools.seals.VdsHeader;
import de.tsenger.vdstools.seals.VdsMessage;
import de.tsenger.vdstools.seals.VdsSignature;
import de.tsenger.vdstools.seals.VdsType;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.tinylog.Logger;
import org.tinylog.Supplier;

public class DataParser {
    public static DigitalSeal parseVdsSeal(String rawString) {
        byte[] rawBytes = DataParser.decodeBase256(rawString);
        Logger.trace((String)"rawString: {}", (Object[])new Object[]{rawString});
        return DataParser.parseVdsSeal(rawBytes);
    }

    public static DigitalSeal parseVdsSeal(byte[] rawBytes) {
        ByteBuffer rawData = ByteBuffer.wrap(rawBytes);
        Logger.trace((String)"rawData: {}", (Supplier[])new Supplier[]{() -> Hex.toHexString((byte[])rawBytes)});
        VdsHeader vdsHeader = DataParser.decodeHeader(rawData);
        VdsMessage vdsMessage = new VdsMessage(vdsHeader.getVdsType());
        VdsSignature vdsSignature = null;
        int messageStartPosition = rawData.position();
        int signatureStartPosition = 0;
        byte[] vdsMessageRawDataBytes = null;
        while (rawData.hasRemaining()) {
            int le;
            int tag = rawData.get() & 0xFF;
            if (tag == 255) {
                signatureStartPosition = rawData.position() - 1;
            }
            if ((le = rawData.get() & 0xFF) == 129) {
                le = rawData.get() & 0xFF;
            } else if (le == 130) {
                le = (rawData.get() & 0xFF) * 256 + (rawData.get() & 0xFF);
            } else if (le == 131) {
                le = (rawData.get() & 0xFF) * 4096 + (rawData.get() & 0xFF) * 256 + (rawData.get() & 0xFF);
            } else if (le > 127) {
                Logger.error((Object)String.format("can't decode length: 0x%02X", le));
                throw new IllegalArgumentException(String.format("can't decode length: 0x%02X", le));
            }
            byte[] val = DataParser.getFromByteBuffer(rawData, le);
            if (tag == 255) {
                vdsSignature = new VdsSignature(val);
                vdsMessageRawDataBytes = Arrays.copyOfRange(rawData.array(), messageStartPosition, signatureStartPosition);
                break;
            }
            vdsMessage.addMessageTlv(new MessageTlv((byte)(tag & 0xFF), le, val));
        }
        if (!Arrays.equals(vdsMessageRawDataBytes, vdsMessage.getRawBytes())) {
            Logger.error((Object)"Message raw bytes and calculated message raw bytes from vdsMessage.getRawBytes are not equal!");
            Logger.debug((Object)("Expected: " + Hex.toHexString(vdsMessageRawDataBytes) + " Actual: " + Hex.toHexString((byte[])vdsMessage.getRawBytes())));
            return null;
        }
        VdsType vdsType = VdsType.valueOf(vdsHeader.getDocumentRef());
        switch (vdsType) {
            case ARRIVAL_ATTESTATION: {
                return new ArrivalAttestation(vdsHeader, vdsMessage, vdsSignature);
            }
            case SOCIAL_INSURANCE_CARD: {
                return new SocialInsuranceCard(vdsHeader, vdsMessage, vdsSignature);
            }
            case ICAO_VISA: {
                return new IcaoVisa(vdsHeader, vdsMessage, vdsSignature);
            }
            case RESIDENCE_PERMIT: {
                return new ResidencePermit(vdsHeader, vdsMessage, vdsSignature);
            }
            case ICAO_EMERGENCY_TRAVEL_DOCUMENT: {
                return new IcaoEmergencyTravelDocument(vdsHeader, vdsMessage, vdsSignature);
            }
            case SUPPLEMENTARY_SHEET: {
                return new SupplementarySheet(vdsHeader, vdsMessage, vdsSignature);
            }
            case ADDRESS_STICKER_ID: {
                return new AddressStickerIdCard(vdsHeader, vdsMessage, vdsSignature);
            }
            case ADDRESS_STICKER_PASSPORT: {
                return new AddressStickerPass(vdsHeader, vdsMessage, vdsSignature);
            }
            case ALIENS_LAW: {
                return new AliensLaw(vdsHeader, vdsMessage, vdsSignature);
            }
            case TEMP_PASSPORT: {
                return new TempPassport(vdsHeader, vdsMessage, vdsSignature);
            }
            case TEMP_PERSO: {
                return new TempPerso(vdsHeader, vdsMessage, vdsSignature);
            }
            case FICTION_CERT: {
                return new FictionCert(vdsHeader, vdsMessage, vdsSignature);
            }
        }
        Logger.warn((String)"unknown VDS type with reference: {}", (Object[])new Object[]{String.format("0x%02X", vdsHeader.getDocumentRef())});
        return null;
    }

    public static VdsHeader decodeHeader(ByteBuffer rawdata) {
        byte magicByte = rawdata.get();
        if (magicByte != -36) {
            Logger.error((Object)String.format("Magic Constant mismatch: 0x%02X instead of 0xdc", magicByte));
            throw new IllegalArgumentException(String.format("Magic Constant mismatch: 0x%02X instead of 0xdc", magicByte));
        }
        VdsHeader vdsHeader = new VdsHeader();
        vdsHeader.rawVersion = rawdata.get();
        if (vdsHeader.rawVersion != 2 && vdsHeader.rawVersion != 3) {
            Logger.error((Object)String.format("Unsupported rawVersion: 0x%02X", vdsHeader.rawVersion));
            throw new IllegalArgumentException(String.format("Unsupported rawVersion: 0x%02X", vdsHeader.rawVersion));
        }
        vdsHeader.issuingCountry = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, 2));
        rawdata.mark();
        String signerIdentifierAndCertRefLength = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, 4));
        vdsHeader.signerIdentifier = signerIdentifierAndCertRefLength.substring(0, 4);
        if (vdsHeader.rawVersion == 3) {
            boolean gaadHack;
            int certRefLength = Integer.parseInt(signerIdentifierAndCertRefLength.substring(4), 16);
            Logger.debug((String)"version 4: certRefLength: {}", (Object[])new Object[]{certRefLength});
            boolean bl = gaadHack = vdsHeader.signerIdentifier.equals("DEME") || vdsHeader.signerIdentifier.equals("DES1");
            if (gaadHack) {
                Logger.debug((Object)"Maybe we found a German Arrival Attestation. GAAD Hack will be applied!");
                certRefLength = 3;
            }
            int bytesToDecode = (certRefLength - 1) / 3 * 2 + 2;
            Logger.debug((String)"version 4: bytesToDecode: {}", (Object[])new Object[]{bytesToDecode});
            vdsHeader.certificateReference = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, bytesToDecode));
            if (gaadHack) {
                vdsHeader.certificateReference = signerIdentifierAndCertRefLength.substring(4) + vdsHeader.certificateReference;
            }
        } else {
            rawdata.reset();
            String signerCertRef = DataParser.decodeC40(DataParser.getFromByteBuffer(rawdata, 6));
            vdsHeader.certificateReference = signerCertRef.substring(4);
        }
        vdsHeader.issuingDate = DataParser.decodeDate(DataParser.getFromByteBuffer(rawdata, 3));
        vdsHeader.sigDate = DataParser.decodeDate(DataParser.getFromByteBuffer(rawdata, 3));
        vdsHeader.docFeatureRef = rawdata.get();
        vdsHeader.docTypeCat = rawdata.get();
        Logger.debug((String)"VdsHeader: {}", (Object[])new Object[]{vdsHeader});
        return vdsHeader;
    }

    private static byte[] getFromByteBuffer(ByteBuffer buffer, int size) {
        byte[] tmpByteArray = new byte[size];
        if (buffer.position() + size <= buffer.capacity()) {
            buffer.get(tmpByteArray);
        }
        return tmpByteArray;
    }

    public static LocalDate decodeDate(byte[] bytes) {
        if (bytes.length != 3) {
            throw new IllegalArgumentException("expected three bytes for date decoding");
        }
        long intval = (long)DataParser.toUnsignedInt(bytes[0]) * 256L * 256L + (long)DataParser.toUnsignedInt(bytes[1]) * 256L + (long)DataParser.toUnsignedInt(bytes[2]);
        int day = (int)(intval % 1000000L / 10000L);
        int month = (int)(intval / 1000000L);
        int year = (int)(intval % 10000L);
        return LocalDate.of(year, month, day);
    }

    private static int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    public static String decodeC40(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < bytes.length; ++idx) {
            int temp;
            if (idx % 2 != 0) continue;
            byte i1 = bytes[idx];
            byte i2 = bytes[idx + 1];
            if (i1 == -2) {
                sb.append((char)(i2 - 1));
                continue;
            }
            int v16 = (DataParser.toUnsignedInt(i1) << 8) + DataParser.toUnsignedInt(i2) - 1;
            int u1 = temp = v16 / 1600;
            v16 -= temp * 1600;
            int u2 = temp = v16 / 40;
            int u3 = v16 - temp * 40;
            if (u1 != 0) {
                sb.append(DataParser.toChar(u1));
            }
            if (u2 != 0) {
                sb.append(DataParser.toChar(u2));
            }
            if (u3 == 0) continue;
            sb.append(DataParser.toChar(u3));
        }
        return sb.toString();
    }

    private static char toChar(int intValue) {
        if (intValue == 3) {
            return ' ';
        }
        if (intValue >= 4 && intValue <= 13) {
            return (char)(intValue + 44);
        }
        if (intValue >= 14 && intValue <= 39) {
            return (char)(intValue + 51);
        }
        return '?';
    }

    public static byte[] decodeBase256(String s) {
        char[] ca = s.toCharArray();
        byte[] ba = new byte[ca.length];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)ca[i];
        }
        return ba;
    }
}

