/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import de.tsenger.vdstools.Doc9303CountryCodes;
import de.tsenger.vdstools.Signer;
import de.tsenger.vdstools.seals.DigitalSeal;
import de.tsenger.vdstools.seals.VdsHeader;
import de.tsenger.vdstools.seals.VdsMessage;
import de.tsenger.vdstools.seals.VdsSignature;
import de.tsenger.vdstools.seals.VdsType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.tinylog.Logger;

public class DataEncoder {
    public static DigitalSeal buildDigitalSeal(VdsMessage vdsMessage, X509Certificate cert, Signer signer) {
        VdsHeader vdsHeader = DataEncoder.buildHeader(vdsMessage.getVdsType(), cert);
        VdsSignature vdsSignature = DataEncoder.createVdsSignature(vdsHeader, vdsMessage, signer);
        return new DigitalSeal(vdsHeader, vdsMessage, vdsSignature);
    }

    public static DigitalSeal buildDigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        VdsSignature vdsSignature = DataEncoder.createVdsSignature(vdsHeader, vdsMessage, signer);
        return new DigitalSeal(vdsHeader, vdsMessage, vdsSignature);
    }

    public static VdsSignature createVdsSignature(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        byte[] headerMessage = Arrays.concatenate((byte[])vdsHeader.getRawBytes(), (byte[])vdsMessage.getRawBytes());
        try {
            byte[] signatureBytes = signer.sign(headerMessage);
            return new VdsSignature(signatureBytes);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            Logger.error((Object)("Signature creation failed: " + e.getMessage()));
            return null;
        }
    }

    public static VdsHeader buildHeader(VdsType vdsType, X509Certificate cert) {
        return DataEncoder.buildHeader(vdsType, cert, null, (byte)3, LocalDate.now());
    }

    public static VdsHeader buildHeader(VdsType vdsType, X509Certificate cert, String issuingCountry) {
        return DataEncoder.buildHeader(vdsType, cert, issuingCountry, (byte)3, LocalDate.now());
    }

    public static VdsHeader buildHeader(VdsType vdsType, X509Certificate cert, String issuingCountry, byte rawVersion, LocalDate issuingDate) {
        VdsHeader header = new VdsHeader();
        header.setDocumentType(vdsType);
        header.rawVersion = rawVersion;
        try {
            String[] signerCertRef = DataEncoder.getSignerCertRef(cert);
            header.signerIdentifier = signerCertRef[0];
            header.certificateReference = signerCertRef[1];
        }
        catch (InvalidNameException e) {
            Logger.error((Object)("Couldn't build header, because getSignerCertRef throws error: " + e.getMessage()));
        }
        header.issuingCountry = issuingCountry != null ? issuingCountry : Doc9303CountryCodes.convertToIcaoOrIso3(header.signerIdentifier.substring(0, 2));
        header.issuingDate = issuingDate;
        return header;
    }

    public static byte[] buildTLVStructure(byte tag, byte[] value) throws IOException {
        DEROctetString dos = new DEROctetString(value);
        byte[] encodeBytes = dos.getEncoded();
        encodeBytes[0] = tag;
        return encodeBytes;
    }

    public static String[] getSignerCertRef(X509Certificate cert) throws InvalidNameException {
        String[] signerCertRef = new String[2];
        LdapName ln = new LdapName(cert.getSubjectDN().getName());
        String c = "";
        String cn = "";
        for (Rdn rdn : ln.getRdns()) {
            if (rdn.getType().equalsIgnoreCase("CN")) {
                cn = (String)rdn.getValue();
                Logger.debug((Object)("CN is: " + cn));
                continue;
            }
            if (!rdn.getType().equalsIgnoreCase("C")) continue;
            c = (String)rdn.getValue();
            Logger.debug((Object)("C is: " + c));
        }
        signerCertRef[0] = String.format("%s%s", c, cn).toUpperCase();
        signerCertRef[1] = cert.getSerialNumber().toString(16);
        Logger.info((Object)("generated signerCertRef: " + signerCertRef[0] + signerCertRef[1]));
        return signerCertRef;
    }

    public static byte[] encodeDate(String dateString) throws ParseException {
        LocalDate dt = LocalDate.parse(dateString);
        return DataEncoder.encodeDate(dt);
    }

    public static byte[] encodeDate(LocalDate localDate) {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("MMddyyyy");
        String formattedDate = localDate.format(pattern);
        int dateInt = Integer.parseInt(formattedDate);
        return new byte[]{(byte)(dateInt >>> 16), (byte)(dateInt >>> 8), (byte)dateInt};
    }

    public static byte[] encodeC40(String dataString) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        dataString = dataString.toUpperCase().replaceAll("<", " ");
        int len = dataString.length();
        for (int i = 0; i < len; ++i) {
            int sum;
            int c2;
            int c1;
            if (i % 3 != 0) continue;
            if (i + 2 < len) {
                c1 = DataEncoder.getC40Value(dataString.charAt(i));
                c2 = DataEncoder.getC40Value(dataString.charAt(i + 1));
                int c3 = DataEncoder.getC40Value(dataString.charAt(i + 2));
                sum = 1600 * c1 + 40 * c2 + c3 + 1;
                out.write(sum / 256);
                out.write(sum % 256);
                continue;
            }
            if (i + 1 < len) {
                c1 = DataEncoder.getC40Value(dataString.charAt(i));
                c2 = DataEncoder.getC40Value(dataString.charAt(i + 1));
                sum = 1600 * c1 + 40 * c2 + 1;
                out.write(sum / 256);
                out.write(sum % 256);
                continue;
            }
            out.write(254);
            out.write(DataEncoder.toUnsignedInt((byte)dataString.charAt(i)) + 1);
        }
        return out.toByteArray();
    }

    private static int getC40Value(char c) {
        int value = DataEncoder.toUnsignedInt((byte)c);
        if (value == 32) {
            return 3;
        }
        if (value >= 48 && value <= 57) {
            return value - 44;
        }
        if (value >= 65 && value <= 90) {
            return value - 51;
        }
        throw new IllegalArgumentException("Not a C40 encodable char: " + c + "value: " + value);
    }

    public static int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    public static String encodeBase256(byte[] ba) {
        char[] ca = new char[ba.length];
        for (int i = 0; i < ba.length; ++i) {
            ca[i] = (char)(ba[i] & 0xFF);
        }
        return new String(ca);
    }
}

