/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.supabasesecurityspringbootstarter.security;

import de.tschuehly.supabasesecurityspringbootstarter.exception.ClaimsCannotBeNullException;
import de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseAuthenticationToken;
import de.tschuehly.supabasesecurityspringbootstarter.types.SupabaseUser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\n"}, d2={"Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "()V", "authenticate", "Lorg/springframework/security/core/Authentication;", "token", "supports", "", "authentication", "Ljava/lang/Class;", "supabase-spring-boot-starter"})
public final class SupabaseAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    public Authentication authenticate(@NotNull Authentication token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        SupabaseAuthenticationToken cfr_ignored_0 = (SupabaseAuthenticationToken)token;
        if (((SupabaseAuthenticationToken)token).getClaims() == null) {
            throw new ClaimsCannotBeNullException(token + " claims are null");
        }
        return (Authentication)SupabaseAuthenticationToken.Companion.authenticated(new SupabaseUser(((SupabaseAuthenticationToken)token).getClaims()));
    }

    public boolean supports(@NotNull Class<?> authentication) {
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        return Intrinsics.areEqual(authentication, SupabaseAuthenticationToken.class);
    }
}

