/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.supabasesecurityspringbootstarter.controller;

import de.tschuehly.supabasesecurityspringbootstarter.exception.SuccessfulRegistrationConfirmationEmailSentException;
import de.tschuehly.supabasesecurityspringbootstarter.service.SupabaseUserService;
import de.tschuehly.supabasesecurityspringbootstarter.types.SupabaseUser;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"api/user"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J.\u0010\u0011\u001a\u00020\f2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J.\u0010\u0016\u001a\u00020\f2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\u0018\u001a\u00020\u0014H\u0017J,\u0010\u0019\u001a\u00020\f2\u0010\b\u0001\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u0014H\u0017J\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001e\u001a\u00020\u0014H\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lde/tschuehly/supabasesecurityspringbootstarter/controller/SupabaseUserController;", "", "supabaseUserService", "Lde/tschuehly/supabasesecurityspringbootstarter/service/SupabaseUserService;", "(Lde/tschuehly/supabasesecurityspringbootstarter/service/SupabaseUserService;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseUserService", "()Lde/tschuehly/supabasesecurityspringbootstarter/service/SupabaseUserService;", "authorizeWithJwtOrResetPassword", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "login", "credentials", "", "", "logout", "register", "sendPasswordResetEmail", "email", "setRoles", "roles", "", "userId", "updatePassword", "password", "supabase-spring-boot-starter"})
public class SupabaseUserController {
    @NotNull
    private final SupabaseUserService supabaseUserService;
    @NotNull
    private final Logger logger;

    public SupabaseUserController(@NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.supabaseUserService = supabaseUserService;
        Logger logger = LoggerFactory.getLogger(SupabaseUserController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SupabaseUserController::class.java)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseUserService getSupabaseUserService() {
        return this.supabaseUserService;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @PostMapping(value={"/register"})
    public void register(@RequestParam @NotNull Map<String, String> credentials, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter(credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String email = credentials.get("email");
        String password = credentials.get("password");
        if (email != null && password != null) {
            this.getLogger().debug("User with the email " + email + " is trying to register");
            SupabaseUser user = this.getSupabaseUserService().registerWithEmail(((Object)StringsKt.trim((CharSequence)email)).toString(), ((Object)StringsKt.trim((CharSequence)password)).toString(), response);
            this.getLogger().debug("User with the mail " + user.getEmail() + " successfully registered, Confirmation Mail sent");
            throw new SuccessfulRegistrationConfirmationEmailSentException("User with the mail " + user.getEmail() + " successfully registered, Confirmation Mail sent");
        }
    }

    @PostMapping(value={"/login"})
    public void login(@RequestParam @NotNull Map<String, String> credentials, @NotNull HttpServletResponse response, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter(credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String email = credentials.get("email");
        String password = credentials.get("password");
        if (email != null && password != null) {
            this.getLogger().debug("User with the email " + email + " is trying to login");
            this.getSupabaseUserService().login(((Object)StringsKt.trim((CharSequence)email)).toString(), ((Object)StringsKt.trim((CharSequence)password)).toString(), response);
            this.getLogger().debug("User: " + email + " successfully logged in");
        }
    }

    @PostMapping(value={"/jwt"})
    public void authorizeWithJwtOrResetPassword(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.getSupabaseUserService().authorizeWithJwtOrResetPassword(request, response);
    }

    @GetMapping(value={"/logout"})
    public void logout(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.getSupabaseUserService().logout(request, response);
    }

    @PutMapping(value={"/setRoles"})
    @ResponseBody
    public void setRoles(@RequestParam @Nullable List<String> roles, @NotNull HttpServletRequest request, @RequestParam @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (Intrinsics.areEqual((Object)userId, (Object)"")) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "UserId required");
        }
        this.getSupabaseUserService().setRolesWithRequest(request, userId, roles);
    }

    @PostMapping(value={"/sendPasswordResetEmail"})
    @ResponseBody
    public void sendPasswordResetEmail(@RequestParam @NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.getLogger().debug("User with the email " + email + " requested a password reset");
        this.getSupabaseUserService().sendPasswordRecoveryEmail(email);
    }

    @PostMapping(value={"/updatePassword"})
    @ResponseBody
    public void updatePassword(@NotNull HttpServletRequest request, @RequestParam @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.getSupabaseUserService().updatePassword(request, password);
    }
}

