/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.supabasesecurityspringbootstarter.service;

import de.tschuehly.supabasesecurityspringbootstarter.config.SupabaseProperties;
import de.tschuehly.supabasesecurityspringbootstarter.exception.InvalidLoginCredentialsException;
import de.tschuehly.supabasesecurityspringbootstarter.exception.PasswordRecoveryEmailSent;
import de.tschuehly.supabasesecurityspringbootstarter.exception.SuccessfulPasswordUpdate;
import de.tschuehly.supabasesecurityspringbootstarter.exception.UserAlreadyRegisteredException;
import de.tschuehly.supabasesecurityspringbootstarter.exception.UserNeedsToConfirmEmailBeforeLoginException;
import de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseAuthenticationProvider;
import de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseJwtFilter;
import de.tschuehly.supabasesecurityspringbootstarter.types.SupabaseUser;
import io.supabase.gotrue.GoTrueClient;
import io.supabase.gotrue.http.GoTrueHttpException;
import io.supabase.gotrue.types.GoTrueTokenResponse;
import io.supabase.gotrue.types.GoTrueUserAttributes;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J \u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001cH\u0016J(\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010'H\u0016J(\u0010(\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001c2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010'H\u0016J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lde/tschuehly/supabasesecurityspringbootstarter/service/SupabaseUserService;", "", "supabaseProperties", "Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;", "supabaseGoTrueClient", "Lio/supabase/gotrue/GoTrueClient;", "Lde/tschuehly/supabasesecurityspringbootstarter/types/SupabaseUser;", "Lio/supabase/gotrue/types/GoTrueTokenResponse;", "supabaseAuthenticationProvider", "Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseAuthenticationProvider;", "(Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;Lio/supabase/gotrue/GoTrueClient;Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseAuthenticationProvider;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseAuthenticationProvider", "()Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseAuthenticationProvider;", "getSupabaseGoTrueClient", "()Lio/supabase/gotrue/GoTrueClient;", "getSupabaseProperties", "()Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;", "authorizeWithJwtOrResetPassword", "Ljakarta/servlet/http/HttpServletResponse;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "login", "username", "", "password", "logout", "", "registerWithEmail", "email", "sendPasswordRecoveryEmail", "setRoles", "serviceRoleJWT", "userId", "roles", "", "setRolesWithRequest", "updatePassword", "supabase-spring-boot-starter"})
public class SupabaseUserService {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final GoTrueClient<SupabaseUser, GoTrueTokenResponse> supabaseGoTrueClient;
    @NotNull
    private final SupabaseAuthenticationProvider supabaseAuthenticationProvider;
    @NotNull
    private final Logger logger;

    public SupabaseUserService(@NotNull SupabaseProperties supabaseProperties, @NotNull GoTrueClient<SupabaseUser, GoTrueTokenResponse> supabaseGoTrueClient, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Intrinsics.checkNotNullParameter(supabaseGoTrueClient, (String)"supabaseGoTrueClient");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        this.supabaseProperties = supabaseProperties;
        this.supabaseGoTrueClient = supabaseGoTrueClient;
        this.supabaseAuthenticationProvider = supabaseAuthenticationProvider;
        Logger logger = LoggerFactory.getLogger(SupabaseUserService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SupabaseUserService::class.java)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public GoTrueClient<SupabaseUser, GoTrueTokenResponse> getSupabaseGoTrueClient() {
        return this.supabaseGoTrueClient;
    }

    @NotNull
    public SupabaseAuthenticationProvider getSupabaseAuthenticationProvider() {
        return this.supabaseAuthenticationProvider;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public SupabaseUser registerWithEmail(@NotNull String email, @NotNull String password, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            return (SupabaseUser)this.getSupabaseGoTrueClient().signUpWithEmail(email, password);
        }
        catch (GoTrueHttpException e) {
            String string = e.getData();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"User already registered", (boolean)false, (int)2, null) : false;
            if (bl) {
                throw new UserAlreadyRegisteredException("User: " + email + " already registered", e);
            }
            this.getLogger().error(e.getData());
            throw e;
        }
    }

    @NotNull
    public HttpServletResponse login(@NotNull String username, @NotNull String password, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            GoTrueTokenResponse resp = (GoTrueTokenResponse)this.getSupabaseGoTrueClient().signInWithEmail(username, password);
            SupabaseJwtFilter.Companion.setJWTCookie$default(SupabaseJwtFilter.Companion, response, resp.getAccessToken(), this.getSupabaseProperties(), 0, 4, null);
        }
        catch (GoTrueHttpException e) {
            String string = e.getData();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Invalid login credentials", (boolean)false, (int)2, null) : false;
            if (bl) {
                String msg = username + " either does not exist or has tried to login with the wrong password";
                this.getLogger().debug(msg);
                throw new InvalidLoginCredentialsException(msg, e);
            }
            String string2 = e.getData();
            boolean bl2 = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Email not confirmed", (boolean)false, (int)2, null) : false;
            if (bl2) {
                String msg = username + " needs to confirm email before he can login";
                this.getLogger().debug(msg);
                throw new UserNeedsToConfirmEmailBeforeLoginException(msg);
            }
            this.getLogger().error(e.getData());
            throw e;
        }
        return response;
    }

    @NotNull
    public HttpServletResponse authorizeWithJwtOrResetPassword(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String header = request.getHeader("HX-Current-URL");
        if (header != null) {
            Object object = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.tschuehly.supabasesecurityspringbootstarter.types.SupabaseUser");
            SupabaseUser user = (SupabaseUser)object;
            if (StringsKt.contains$default((CharSequence)header, (CharSequence)"type=recovery", (boolean)false, (int)2, null)) {
                this.getLogger().debug("User: " + user.getEmail() + " is trying to reset his password");
                response.setHeader("HX-Redirect", this.getSupabaseProperties().getPasswordRecoveryPage());
            }
        }
        return response;
    }

    public void logout(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        block4: {
            Cookie[] cookieArray;
            Cookie[] cookieArray2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                SecurityContextHolder.getContext().setAuthentication(null);
                cookieArray2 = request.getCookies();
                if (cookieArray2 == null) break block4;
                Cookie[] cookieArray3 = cookieArray2;
                int n = cookieArray3.length;
                for (int i = 0; i < n; ++i) {
                    Cookie[] cookieArray4;
                    Cookie[] it = cookieArray4 = cookieArray3[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"JWT")) continue;
                    cookieArray = cookieArray4;
                    break block3;
                }
                cookieArray = cookieArray2 = null;
            }
            if (cookieArray != null) {
                Cookie[] it = cookieArray2;
                boolean bl = false;
                String cookieString = "JWT=" + it.getValue() + "; HttpOnly; Path=/;Max-Age=0;";
                if (this.getSupabaseProperties().getSslOnly()) {
                    cookieString = cookieString + "Secure;";
                }
                response.setHeader("Set-Cookie", cookieString);
                response.setHeader("HX-Redirect", "/");
            }
        }
    }

    public void setRolesWithRequest(@NotNull HttpServletRequest request, @NotNull String userId, @Nullable List<String> roles) {
        block3: {
            Cookie[] cookieArray;
            Cookie[] cookieArray2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
                cookieArray2 = request.getCookies();
                if (cookieArray2 == null) break block3;
                Cookie[] cookieArray3 = cookieArray2;
                int n = cookieArray3.length;
                for (int i = 0; i < n; ++i) {
                    Cookie[] cookieArray4;
                    Cookie[] it = cookieArray4 = cookieArray3[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"JWT")) continue;
                    cookieArray = cookieArray4;
                    break block2;
                }
                cookieArray = cookieArray2 = null;
            }
            if (cookieArray != null) {
                Cookie[] it = cookieArray2;
                boolean bl = false;
                String string = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
                this.setRoles(string, userId, roles);
            }
        }
    }

    public void setRoles(@NotNull String serviceRoleJWT, @NotNull String userId, @Nullable List<String> roles) {
        Intrinsics.checkNotNullParameter((Object)serviceRoleJWT, (String)"serviceRoleJWT");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        List list = roles;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List roleArray = list;
        this.getSupabaseGoTrueClient().updateUserAppMetadata(serviceRoleJWT, userId, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"roles", (Object)roleArray)));
        this.getLogger().debug("The roles of the user with id " + userId + " were updated to " + roleArray);
    }

    public void sendPasswordRecoveryEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.getSupabaseGoTrueClient().resetPasswordForEmail(email);
        throw new PasswordRecoveryEmailSent("User with " + email + " has requested a password recovery email");
    }

    public void updatePassword(@NotNull HttpServletRequest request, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Cookie[] cookieArray = request.getCookies();
        if (cookieArray != null) {
            Cookie cookie;
            block3: {
                Cookie cookie2;
                Cookie[] cookieArray2 = cookieArray;
                int n = cookieArray2.length;
                for (int i = 0; i < n; ++i) {
                    Cookie cookie3;
                    Cookie it = cookie3 = cookieArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"JWT")) continue;
                    cookie2 = cookie3;
                    break block3;
                }
                cookie2 = cookie = null;
            }
            if (cookie != null) {
                Cookie cookie4 = cookie;
                boolean bl = false;
                GoTrueClient<SupabaseUser, GoTrueTokenResponse> goTrueClient = this.getSupabaseGoTrueClient();
                String string = cookie4.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cookie.value");
                goTrueClient.updateUser(string, new GoTrueUserAttributes(null, password, null, 5, null));
                Object object = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.tschuehly.supabasesecurityspringbootstarter.types.SupabaseUser");
                SupabaseUser user = (SupabaseUser)object;
                String msg = "User with the mail: " + user.getEmail() + " updated his password successfully";
                this.getLogger().debug(msg);
                throw new SuccessfulPasswordUpdate(msg);
            }
        }
    }
}

