/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.supabasesecurityspringbootstarter.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import de.tschuehly.supabasesecurityspringbootstarter.config.SupabaseProperties;
import de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseAuthenticationToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseJwtFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "supabaseProperties", "Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;", "(Lorg/springframework/security/authentication/AuthenticationManager;Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;)V", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "Companion", "supabase-spring-boot-starter"})
public final class SupabaseJwtFilter
extends OncePerRequestFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticationManager authenticationManager;
    @NotNull
    private final SupabaseProperties supabaseProperties;

    public SupabaseJwtFilter(@NotNull AuthenticationManager authenticationManager, @NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.authenticationManager = authenticationManager;
        this.supabaseProperties = supabaseProperties;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain2) {
        String jwtValue;
        String string;
        String header;
        Cookie cookie;
        block8: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)filterChain2, (String)"filterChain");
            Cookie[] cookieArray = request.getCookies();
            if (cookieArray != null) {
                Cookie[] cookieArray2 = cookieArray;
                int n = cookieArray2.length;
                for (int i = 0; i < n; ++i) {
                    Cookie cookie2;
                    Cookie it = cookie2 = cookieArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"JWT")) continue;
                    cookie = cookie2;
                    break block8;
                }
                cookie = null;
            } else {
                cookie = null;
            }
        }
        Cookie cookie3 = cookie;
        String string2 = header = request.getHeader("HX-Current-URL");
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"#access_token=", (boolean)false, (int)2, null) : false;
        if (bl) {
            string = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)header, (String)"&", null, (int)2, null), (String)"#access_token=", null, (int)2, null);
        } else {
            Cookie cookie4 = cookie3;
            string = cookie4 != null ? cookie4.getValue() : null;
        }
        String string3 = jwtValue = string;
        if (string3 != null) {
            String jwt = string3;
            boolean bl2 = false;
            try {
                Map claims = JWT.require((Algorithm)Algorithm.HMAC256((String)this.supabaseProperties.getJwtSecret())).build().verify(jwt).getClaims();
                Intrinsics.checkNotNullExpressionValue((Object)claims, (String)"claims");
                Authentication authentication = this.authenticationManager.authenticate((Authentication)SupabaseAuthenticationToken.Companion.unauthenticated(claims));
                SecurityContext context = SecurityContextHolder.createEmptyContext();
                context.setAuthentication(authentication);
                SecurityContextHolder.setContext((SecurityContext)context);
                de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseJwtFilter$Companion.setJWTCookie$default(Companion, response, jwtValue, this.supabaseProperties, 0, 4, null);
            }
            catch (TokenExpiredException e) {
                Companion.setJWTCookie(response, jwtValue, this.supabaseProperties, 0);
            }
        }
        filterChain2.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseJwtFilter$Companion;", "", "()V", "setJWTCookie", "", "Ljakarta/servlet/http/HttpServletResponse;", "accessToken", "", "supabaseProperties", "Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;", "maxAge", "", "supabase-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void setJWTCookie(@NotNull HttpServletResponse $this$setJWTCookie, @NotNull String accessToken, @NotNull SupabaseProperties supabaseProperties, int maxAge) {
            void it;
            Cookie cookie;
            Intrinsics.checkNotNullParameter((Object)$this$setJWTCookie, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
            Cookie cookie2 = cookie = new Cookie("JWT", accessToken);
            HttpServletResponse httpServletResponse = $this$setJWTCookie;
            boolean bl = false;
            it.setSecure(supabaseProperties.getSslOnly());
            it.setHttpOnly(true);
            it.setPath("/");
            it.setMaxAge(maxAge);
            httpServletResponse.addCookie(cookie);
            $this$setJWTCookie.setHeader("HX-Redirect", supabaseProperties.getSuccessfulLoginRedirectPage());
        }

        public static /* synthetic */ void setJWTCookie$default(Companion companion, HttpServletResponse httpServletResponse, String string, SupabaseProperties supabaseProperties, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 6000;
            }
            companion.setJWTCookie(httpServletResponse, string, supabaseProperties, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

