/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.supabasesecurityspringbootstarter.config;

import de.tschuehly.supabasesecurityspringbootstarter.config.SupabaseAutoConfiguration$supabaseGoTrueClient$;
import de.tschuehly.supabasesecurityspringbootstarter.config.SupabaseProperties;
import de.tschuehly.supabasesecurityspringbootstarter.controller.SupabaseUserController;
import de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseAuthenticationProvider;
import de.tschuehly.supabasesecurityspringbootstarter.security.SupabaseSecurityConfig;
import de.tschuehly.supabasesecurityspringbootstarter.service.SupabaseUserService;
import de.tschuehly.supabasesecurityspringbootstarter.types.SupabaseUser;
import io.supabase.gotrue.GoTrueClient;
import io.supabase.gotrue.http.GoTrueHttpClient;
import io.supabase.gotrue.http.GoTrueHttpClientApache;
import io.supabase.gotrue.json.GoTrueJsonConverter;
import io.supabase.gotrue.json.GoTrueJsonConverterJackson;
import io.supabase.gotrue.types.GoTrueTokenResponse;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnProperty(prefix="supabase", name={"projectId"})
@ComponentScan(value={"de.tschuehly.supabasesecurityspringbootstarter"})
@EnableConfigurationProperties(value={SupabaseProperties.class})
@Import(value={SupabaseSecurityConfig.class})
@PropertySource(value={"classpath:application-supabase.properties"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J$\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseAutoConfiguration;", "", "supabaseProperties", "Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;", "(Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseProperties", "()Lde/tschuehly/supabasesecurityspringbootstarter/config/SupabaseProperties;", "supabaseController", "Lde/tschuehly/supabasesecurityspringbootstarter/controller/SupabaseUserController;", "supabaseUserService", "Lde/tschuehly/supabasesecurityspringbootstarter/service/SupabaseUserService;", "supabaseGoTrueClient", "Lio/supabase/gotrue/GoTrueClient;", "Lde/tschuehly/supabasesecurityspringbootstarter/types/SupabaseUser;", "Lio/supabase/gotrue/types/GoTrueTokenResponse;", "supabaseService", "supabaseAuthenticationProvider", "Lde/tschuehly/supabasesecurityspringbootstarter/security/SupabaseAuthenticationProvider;", "supabase-spring-boot-starter"})
public class SupabaseAutoConfiguration {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Logger logger;

    public SupabaseAutoConfiguration(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.supabaseProperties = supabaseProperties;
        Logger logger = LoggerFactory.getLogger(SupabaseAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SupabaseAutoConfiguration::class.java)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserService supabaseService(@NotNull GoTrueClient<SupabaseUser, GoTrueTokenResponse> supabaseGoTrueClient, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider) {
        Intrinsics.checkNotNullParameter(supabaseGoTrueClient, (String)"supabaseGoTrueClient");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        this.getLogger().debug("Registering the SupabaseUserService");
        return new SupabaseUserService(this.getSupabaseProperties(), supabaseGoTrueClient, supabaseAuthenticationProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserController supabaseController(@NotNull SupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.getLogger().debug("Registering the SupabaseUserController");
        return new SupabaseUserController(supabaseUserService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GoTrueClient<SupabaseUser, GoTrueTokenResponse> supabaseGoTrueClient(@NotNull SupabaseProperties supabaseProperties) {
        void headers$iv;
        void url$iv;
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.getLogger().debug("Registering the supabaseGoTrueClient");
        GoTrueClient.Companion companion = GoTrueClient.Companion;
        String string = "https://" + supabaseProperties.getProjectId() + ".supabase.co/auth/v1";
        String string2 = supabaseProperties.getAnonKey();
        Intrinsics.checkNotNull((Object)string2);
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"apiKey", (Object)string2));
        boolean $i$f$customApacheJacksonGoTrueClient = false;
        return new GoTrueClient((GoTrueHttpClient)new GoTrueHttpClientApache((String)url$iv, (Map)headers$iv, (Function0)supabaseGoTrueClient$$inlined$customApacheJacksonGoTrueClient$1.INSTANCE, (GoTrueJsonConverter)new GoTrueJsonConverterJackson()), (GoTrueJsonConverter)new GoTrueJsonConverterJackson(), SupabaseUser.class, GoTrueTokenResponse.class);
    }
}

