/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.thymeleaf;

import de.tschuehly.spring.viewcomponent.core.IViewContext;
import de.tschuehly.spring.viewcomponent.thymeleaf.ThymeleafViewComponentException;
import de.tschuehly.spring.viewcomponent.thymeleaf.ViewComponentExpressionException;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.View;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.EngineEventUtils;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IText;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.templatemode.TemplateMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentTagProcessor;", "Lorg/thymeleaf/processor/element/AbstractAttributeTagProcessor;", "dialectPrefix", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Ljava/lang/String;Lorg/springframework/context/ApplicationContext;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "doProcess", "", "context", "Lorg/thymeleaf/context/ITemplateContext;", "tag", "Lorg/thymeleaf/model/IProcessableElementTag;", "attributeName", "Lorg/thymeleaf/engine/AttributeName;", "attributeValue", "structureHandler", "Lorg/thymeleaf/processor/element/IElementTagStructureHandler;", "renderViewComponent", "response", "Ljakarta/servlet/http/HttpServletResponse;", "viewContext", "Lde/tschuehly/spring/viewcomponent/core/IViewContext;", "locale", "Ljava/util/Locale;", "Companion", "spring-view-component-thymeleaf"})
@SourceDebugExtension(value={"SMAP\nThymeleafViewComponentTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThymeleafViewComponentTagProcessor.kt\nde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentTagProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class ThymeleafViewComponentTagProcessor
extends AbstractAttributeTagProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    private final Logger logger;
    @NotNull
    public static final String ATTR_NAME = "component";
    public static final int PRECEDENCE = 10000;

    public ThymeleafViewComponentTagProcessor(@NotNull String dialectPrefix, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)dialectPrefix, (String)"dialectPrefix");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 10000, true);
        this.applicationContext = applicationContext;
        this.logger = LoggerFactory.getLogger(ThymeleafViewComponentTagProcessor.class);
    }

    protected void doProcess(@NotNull ITemplateContext context, @NotNull IProcessableElementTag tag, @NotNull AttributeName attributeName, @NotNull String attributeValue, @NotNull IElementTagStructureHandler structureHandler) {
        IViewContext iViewContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        Intrinsics.checkNotNullParameter((Object)structureHandler, (String)"structureHandler");
        IStandardExpression expression = EngineEventUtils.computeAttributeExpression((ITemplateContext)context, (IProcessableElementTag)tag, (AttributeName)attributeName, (String)attributeValue);
        WebEngineContext webContext = (WebEngineContext)context;
        try {
            Object object = expression.execute((IExpressionContext)webContext);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.IViewContext");
            iViewContext = (IViewContext)object;
        }
        catch (ClassCastException e) {
            throw new ViewComponentExpressionException("Could not execute expression: \"" + expression.getStringRepresentation() + "\" as ViewContext, did you forget the brackets? ${" + expression.getStringRepresentation() + "}, did you pass \"" + expression.getStringRepresentation() + "\" as ViewContextProperty?");
        }
        catch (Exception e) {
            this.logger.error("Could not execute expression: \"" + expression.getStringRepresentation() + "\"");
            throw new ThymeleafViewComponentException(e.getMessage(), e.getCause());
        }
        IViewContext viewContext = iViewContext;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Object object = servletRequestAttributes != null ? servletRequestAttributes.getResponse() : null;
        Intrinsics.checkNotNull((Object)object);
        HttpServletResponse response = object;
        Locale locale = webContext.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
        String wrapper = this.renderViewComponent(response, viewContext, locale);
        IText viewComponentBody = webContext.getModelFactory().createText((CharSequence)wrapper);
        structureHandler.replaceWith((CharSequence)viewComponentBody, true);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderViewComponent(HttpServletResponse response, IViewContext viewContext, Locale locale) {
        String string;
        Object object;
        View viewName;
        ContentCachingResponseWrapper wrapper = new ContentCachingResponseWrapper(response);
        Object object2 = this.applicationContext.getBean(ThymeleafViewResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getBean(...)");
        ThymeleafViewResolver thymeleafViewResolver = (ThymeleafViewResolver)object2;
        View view = thymeleafViewResolver.resolveViewName(IViewContext.Companion.getViewComponentTemplateWithoutSuffix(viewContext), locale);
        if (view == null) {
            throw new ThymeleafViewComponentException("No ViewName", null);
        }
        View view2 = viewName = view;
        String string2 = viewContext.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        Object object3 = string2;
        if (((CharSequence)object3).length() > 0) {
            void it;
            char c = ((String)object3).charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            View view3 = view2;
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            CharSequence charSequence = string4;
            view2 = view3;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
            object = object3;
            int n = 1;
            String string5 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = object3;
        }
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)viewContext));
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Object object4 = servletRequestAttributes != null ? servletRequestAttributes.getRequest() : null;
        Intrinsics.checkNotNull((Object)object4);
        view2.render(map, object4, (HttpServletResponse)wrapper);
        byte[] byArray = wrapper.getContentAsByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContentAsByteArray(...)");
        object3 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        object = charset;
        return new String((byte[])object3, (Charset)object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentTagProcessor$Companion;", "", "<init>", "()V", "ATTR_NAME", "", "PRECEDENCE", "", "spring-view-component-thymeleaf"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

