/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.thymeleaf;

import de.tschuehly.spring.viewcomponent.core.ViewComponentAutoConfiguration;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.thymeleaf.ThymeleafViewComponentDialect;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@Import(value={ViewComponentAutoConfiguration.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0012\u00a8\u0006\u0019"}, d2={"Lde/tschuehly/spring/viewcomponent/thymeleaf/ThymeleafViewComponentAutoConfiguration;", "", "<init>", "()V", "templateEngine", "Lorg/thymeleaf/spring6/SpringTemplateEngine;", "properties", "Lorg/springframework/boot/autoconfigure/thymeleaf/ThymeleafProperties;", "templateResolvers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/thymeleaf/templateresolver/ITemplateResolver;", "dialects", "Lorg/thymeleaf/dialect/IDialect;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "fileViewComponentTemplateResolver", "Lorg/thymeleaf/templateresolver/FileTemplateResolver;", "viewComponentProperties", "Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;", "viewComponentTemplateResolver", "Lorg/thymeleaf/templateresolver/ClassLoaderTemplateResolver;", "configureResolver", "", "templateResolver", "Lorg/thymeleaf/templateresolver/AbstractConfigurableTemplateResolver;", "spring-view-component-thymeleaf"})
public class ThymeleafViewComponentAutoConfiguration {
    @Bean
    @NotNull
    public SpringTemplateEngine templateEngine(@NotNull ThymeleafProperties properties, @NotNull ObjectProvider<ITemplateResolver> templateResolvers, @NotNull ObjectProvider<IDialect> dialects, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(templateResolvers, (String)"templateResolvers");
        Intrinsics.checkNotNullParameter(dialects, (String)"dialects");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.setEnableSpringELCompiler(properties.isEnableSpringElCompiler());
        engine.setRenderHiddenMarkersBeforeCheckboxes(properties.isRenderHiddenMarkersBeforeCheckboxes());
        templateResolvers.orderedStream().forEach(arg_0 -> ThymeleafViewComponentAutoConfiguration.templateEngine$lambda$1(arg_0 -> ThymeleafViewComponentAutoConfiguration.templateEngine$lambda$0(engine, arg_0), arg_0));
        dialects.orderedStream().forEach(arg_0 -> ThymeleafViewComponentAutoConfiguration.templateEngine$lambda$3(arg_0 -> ThymeleafViewComponentAutoConfiguration.templateEngine$lambda$2(engine, arg_0), arg_0));
        engine.addDialect((IDialect)new ThymeleafViewComponentDialect(applicationContext));
        return engine;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.view-component.local-development"}, havingValue="true")
    @NotNull
    public FileTemplateResolver fileViewComponentTemplateResolver(@NotNull ViewComponentProperties viewComponentProperties) {
        FileTemplateResolver fileTemplateResolver;
        Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
        FileTemplateResolver it = fileTemplateResolver = new FileTemplateResolver();
        boolean bl = false;
        this.configureResolver((AbstractConfigurableTemplateResolver)it);
        it.setPrefix(viewComponentProperties.getViewComponentRoot() + "/");
        return fileTemplateResolver;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.view-component.local-development"}, havingValue="false", matchIfMissing=true)
    @NotNull
    public ClassLoaderTemplateResolver viewComponentTemplateResolver(@NotNull ViewComponentProperties viewComponentProperties) {
        ClassLoaderTemplateResolver classLoaderTemplateResolver;
        Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
        ClassLoaderTemplateResolver it = classLoaderTemplateResolver = new ClassLoaderTemplateResolver();
        boolean bl = false;
        this.configureResolver((AbstractConfigurableTemplateResolver)it);
        it.setPrefix("");
        return classLoaderTemplateResolver;
    }

    private void configureResolver(AbstractConfigurableTemplateResolver templateResolver) {
        templateResolver.setSuffix(".html");
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setCacheable(false);
        templateResolver.setCharacterEncoding("UTF-8");
        templateResolver.setOrder(Integer.valueOf(1));
        templateResolver.setCheckExistence(true);
    }

    private static final Unit templateEngine$lambda$0(SpringTemplateEngine $engine, ITemplateResolver templateResolver) {
        $engine.addTemplateResolver(templateResolver);
        return Unit.INSTANCE;
    }

    private static final void templateEngine$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit templateEngine$lambda$2(SpringTemplateEngine $engine, IDialect dialect) {
        $engine.addDialect(dialect);
        return Unit.INSTANCE;
    }

    private static final void templateEngine$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

