/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.jte;

import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.jte.JteViewContextAspect;
import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.springframework.boot.autoconfigure.JteProperties;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lde/tschuehly/spring/viewcomponent/jte/JteConfiguration;", "Lorg/springframework/beans/factory/BeanClassLoaderAware;", "<init>", "()V", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "setClassLoader", "(Ljava/lang/ClassLoader;)V", "jteViewContextAspect", "Lde/tschuehly/spring/viewcomponent/jte/JteViewContextAspect;", "templateEngine", "Lgg/jte/TemplateEngine;", "jteProperties", "Lgg/jte/springframework/boot/autoconfigure/JteProperties;", "jteTemplateEngine", "viewComponentProperties", "Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "setBeanClassLoader", "", "spring-view-component-jte"})
@SourceDebugExtension(value={"SMAP\nJteConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JteConfiguration.kt\nde/tschuehly/spring/viewcomponent/jte/JteConfiguration\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,58:1\n37#2,2:59\n*S KotlinDebug\n*F\n+ 1 JteConfiguration.kt\nde/tschuehly/spring/viewcomponent/jte/JteConfiguration\n*L\n37#1:59,2\n*E\n"})
public class JteConfiguration
implements BeanClassLoaderAware {
    @Nullable
    private ClassLoader classLoader;

    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Bean
    @NotNull
    public JteViewContextAspect jteViewContextAspect(@NotNull TemplateEngine templateEngine, @NotNull JteProperties jteProperties) {
        Intrinsics.checkNotNullParameter((Object)templateEngine, (String)"templateEngine");
        Intrinsics.checkNotNullParameter((Object)jteProperties, (String)"jteProperties");
        return new JteViewContextAspect(templateEngine, jteProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={TemplateEngine.class})
    @NotNull
    public TemplateEngine jteTemplateEngine(@NotNull ViewComponentProperties viewComponentProperties, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (!viewComponentProperties.getLocalDevelopment()) {
            Object object = this.getClassLoader();
            if (object == null || (object = ((ClassLoader)object).getResource("")) == null || (object = ((URL)object).toURI()) == null) {
                throw new RuntimeException("ClassLoader is null");
            }
            TemplateEngine templateEngine = TemplateEngine.createPrecompiled((Path)Path.of((URI)object), (ContentType)ContentType.Html, (ClassLoader)this.getClassLoader());
            Intrinsics.checkNotNullExpressionValue((Object)templateEngine, (String)"createPrecompiled(...)");
            return templateEngine;
        }
        String[] stringArray = new String[]{"/"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)viewComponentProperties.getViewComponentRoot(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        CodeResolver codeResolver = (CodeResolver)new DirectoryCodeResolver(FileSystems.getDefault().getPath("", Arrays.copyOf(split, split.length)));
        TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)codeResolver, (Path)Paths.get("jte-classes", new String[0]), (ContentType)ContentType.Html, (ClassLoader)this.getClassLoader());
        Intrinsics.checkNotNullExpressionValue((Object)templateEngine, (String)"create(...)");
        return templateEngine;
    }

    @Bean
    @Primary
    @NotNull
    public JteProperties jteProperties(@NotNull ViewComponentProperties viewComponentProperties) {
        JteProperties jteProperties;
        Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
        JteProperties it = jteProperties = new JteProperties();
        boolean bl = false;
        it.setTemplateSuffix(".jte");
        it.setTemplateLocation(viewComponentProperties.getViewComponentRoot());
        it.setDevelopmentMode(viewComponentProperties.getLocalDevelopment());
        return jteProperties;
    }

    public void setBeanClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.setClassLoader(classLoader);
    }
}

