/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.jte;

import de.tschuehly.spring.viewcomponent.core.ViewComponentAutoConfiguration;
import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.jte.JteViewContextAspect;
import de.tschuehly.spring.viewcomponent.jte.ViewComponentCodeResolver;
import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ViewComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={ViewComponentProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/tschuehly/spring/viewcomponent/jte/JteViewComponentAutoConfiguration;", "", "viewComponentProperties", "Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;Lorg/springframework/context/ApplicationContext;)V", "jteTemplateEngine", "Lgg/jte/TemplateEngine;", "jteViewContextAspect", "Lde/tschuehly/spring/viewcomponent/jte/JteViewContextAspect;", "templateEngine", "spring-view-component-jte"})
public class JteViewComponentAutoConfiguration {
    @NotNull
    private final ViewComponentProperties viewComponentProperties;
    @NotNull
    private final ApplicationContext applicationContext;

    public JteViewComponentAutoConfiguration(@NotNull ViewComponentProperties viewComponentProperties, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.viewComponentProperties = viewComponentProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    @NotNull
    public JteViewContextAspect jteViewContextAspect(@NotNull TemplateEngine templateEngine) {
        Intrinsics.checkNotNullParameter((Object)templateEngine, (String)"templateEngine");
        return new JteViewContextAspect(templateEngine, this.viewComponentProperties);
    }

    @Bean
    @NotNull
    public TemplateEngine jteTemplateEngine(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (this.viewComponentProperties.getLocalDevelopment()) {
            TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)new ViewComponentCodeResolver(applicationContext, this.viewComponentProperties.getJteTemplateDirectories()), (Path)Paths.get("jte-classes", new String[0]), (ContentType)ContentType.Html, (ClassLoader)applicationContext.getClassLoader());
            Intrinsics.checkNotNullExpressionValue((Object)templateEngine, (String)"create(\n                \u2026classLoader\n            )");
            return templateEngine;
        }
        TemplateEngine templateEngine = TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
        Intrinsics.checkNotNullExpressionValue((Object)templateEngine, (String)"createPrecompiled(\n     \u2026ontentType.Html\n        )");
        return templateEngine;
    }
}

