/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.condition;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/tschuehly/spring/viewcomponent/core/condition/DevToolsExistsCondition;", "Lorg/springframework/context/annotation/Condition;", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "matches", "", "context", "Lorg/springframework/context/annotation/ConditionContext;", "metadata", "Lorg/springframework/core/type/AnnotatedTypeMetadata;", "spring-view-component-core"})
public final class DevToolsExistsCondition
implements Condition {
    @NotNull
    private final Logger logger;

    public DevToolsExistsCondition() {
        Logger logger = LoggerFactory.getLogger(DevToolsExistsCondition.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public boolean matches(@NotNull ConditionContext context, @NotNull AnnotatedTypeMetadata metadata) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        boolean isLocalDevelopment = Boolean.parseBoolean(context.getEnvironment().getProperty("spring.view-component.local-development"));
        try {
            Class.forName("org.springframework.boot.devtools.restart.Restarter", false, context.getClassLoader());
            bl = true;
        }
        catch (ClassNotFoundException e) {
            this.logger.error("In order to use hot-reload function, spring-dev-tools needed");
            bl = false;
        }
        boolean isDevToolsExists = bl;
        return isLocalDevelopment && isDevToolsExists;
    }
}

