/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core;

import de.tschuehly.spring.viewcomponent.core.component.ViewComponentProperties;
import de.tschuehly.spring.viewcomponent.core.condition.DevToolsExistsCondition;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentChangeListener;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"de.tschuehly.spring.viewcomponent.core"})
@EnableConfigurationProperties(value={ViewComponentProperties.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration;", "", "<init>", "()V", "LocalDevConfig", "spring-view-component-core"})
public class ViewComponentAutoConfiguration {

    @Configuration
    @Conditional(value={DevToolsExistsCondition.class})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration$LocalDevConfig;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "viewComponentFileSystemWatcher", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "viewComponentProperties", "Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentProperties;", "spring-view-component-core"})
    public static class LocalDevConfig {
        @NotNull
        private final Logger logger;

        public LocalDevConfig() {
            Logger logger = LoggerFactory.getLogger(LocalDevConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
        }

        @NotNull
        public Logger getLogger() {
            return this.logger;
        }

        @Bean
        @NotNull
        public FileSystemWatcher viewComponentFileSystemWatcher(@NotNull ApplicationContext applicationContext, @NotNull ViewComponentProperties viewComponentProperties) {
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            Intrinsics.checkNotNullParameter((Object)viewComponentProperties, (String)"viewComponentProperties");
            FileSystemWatcher fileSystemWatcher = new FileSystemWatcher();
            File viewComponentDirectory = new File(viewComponentProperties.getViewComponentRoot());
            File templateRoot = new File(viewComponentProperties.getStandaloneTemplateRoot());
            fileSystemWatcher.addSourceDirectory(viewComponentDirectory);
            fileSystemWatcher.addSourceDirectory(templateRoot);
            this.getLogger().info("Watching for template changes at: " + viewComponentDirectory.getAbsoluteFile().getPath());
            this.getLogger().info("Watching for template changes at: " + templateRoot.getAbsoluteFile().getPath());
            fileSystemWatcher.addListener((FileChangeListener)new ViewComponentChangeListener(applicationContext));
            fileSystemWatcher.start();
            return fileSystemWatcher;
        }
    }
}

