/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.component;

import de.tschuehly.spring.viewcomponent.core.IViewContext;
import de.tschuehly.spring.viewcomponent.core.exception.ViewComponentException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/tschuehly/spring/viewcomponent/core/component/ViewComponentAspect;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "isViewComponent", "", "renderInject", "Lde/tschuehly/spring/viewcomponent/core/IViewContext;", "joinPoint", "Lorg/aspectj/lang/ProceedingJoinPoint;", "spring-view-component-core"})
public class ViewComponentAspect {
    @NotNull
    private final ApplicationContext applicationContext;

    public ViewComponentAspect(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Pointcut(value="@within(de.tschuehly.spring.viewcomponent.core.component.ViewComponent)")
    public void isViewComponent() {
    }

    @Around(value="isViewComponent() && execution(public de.tschuehly.spring.viewcomponent.core.IViewContext+ *(..))")
    @NotNull
    public IViewContext renderInject(@NotNull ProceedingJoinPoint joinPoint) {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Object returnValue = joinPoint.proceed();
        if (!IViewContext.class.isAssignableFrom(returnValue.getClass())) {
            throw new ViewComponentException(returnValue.getClass() + " needs to implement ViewContext abstract class");
        }
        Intrinsics.checkNotNull((Object)returnValue, (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.IViewContext");
        IViewContext viewContext = (IViewContext)returnValue;
        IViewContext.Companion.setApplicationContext(this.getApplicationContext());
        return viewContext;
    }
}

