/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J\b\u0010\u0010\u001a\u00020\nH\u0007J\n\u0010\u0011\u001a\u00020\f*\u00020\fR\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lde/tschuehly/spring/viewcomponent/core/IntegrationTestBase;", "", "()V", "testRestTemplate", "Lorg/springframework/boot/test/web/client/TestRestTemplate;", "getTestRestTemplate", "()Lorg/springframework/boot/test/web/client/TestRestTemplate;", "setTestRestTemplate", "(Lorg/springframework/boot/test/web/client/TestRestTemplate;)V", "assertEndpointReturns", "", "url", "", "expectedHtml", "testIndexComponent", "testLayoutComponent", "testSimpleComponent", "rmWhitespaceBetweenHtmlTags", "spring-view-component-core_testFixtures"})
public abstract class IntegrationTestBase {
    @Autowired
    public TestRestTemplate testRestTemplate;

    @NotNull
    public final TestRestTemplate getTestRestTemplate() {
        TestRestTemplate testRestTemplate = this.testRestTemplate;
        if (testRestTemplate != null) {
            return testRestTemplate;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testRestTemplate");
        return null;
    }

    public final void setTestRestTemplate(@NotNull TestRestTemplate testRestTemplate) {
        Intrinsics.checkNotNullParameter((Object)testRestTemplate, (String)"<set-?>");
        this.testRestTemplate = testRestTemplate;
    }

    @Test
    public final void testIndexComponent() {
        String expectedHtml = "<html>\n    <head><script src=\"http://localhost:35729/livereload.js\"></script></head>\n    <div>\n        <h1>This is the IndexViewComponent</h1>\n    </div>\n    <a href=\"/\">IndexViewComponent</a><br>\n    <a href=\"/simple\">SimpleViewComponent</a><br>\n    <a href=\"/layout\">LayoutViewComponent</a><br>\n</html>";
        this.assertEndpointReturns("/", expectedHtml);
    }

    @Test
    public final void testSimpleComponent() {
        String expectedHtml = "<div>\n    <h2>This is the SimpleViewComponent</h2>\n    <div>Hello World</div>\n    <div>\n      <input id=\"helloWorld\" name=\"helloWorld\" value=\"Hello World\">\n    </div>\n</div>";
        this.assertEndpointReturns("/simple", expectedHtml);
    }

    @Test
    public final void testLayoutComponent() {
        String expectedHtml = "<html>\n<nav>This is a Navbar</nav>\n<body>\n<div><h2>This is the SimpleViewComponent</h2>\n  <div>Hello World</div>\n  <div>\n    <input id=\"helloWorld\" name=\"helloWorld\" value=\"Hello World\">\n  </div>\n</div>\n</body>\n<footer>This is a footer</footer>\n</html>";
        this.assertEndpointReturns("/layout", expectedHtml);
    }

    public final void assertEndpointReturns(@NotNull String url, @NotNull String expectedHtml) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)expectedHtml, (String)"expectedHtml");
        ResponseEntity responseEntity = this.getTestRestTemplate().exchange(url, HttpMethod.GET, null, String.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"exchange(...)");
        ResponseEntity response = responseEntity;
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        String string = (String)response.getBody();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.rmWhitespaceBetweenHtmlTags(expectedHtml), (Object)(string != null ? this.rmWhitespaceBetweenHtmlTags(string) : null));
    }

    @NotNull
    public final String rmWhitespaceBetweenHtmlTags(@NotNull String $this$rmWhitespaceBetweenHtmlTags) {
        Intrinsics.checkNotNullParameter((Object)$this$rmWhitespaceBetweenHtmlTags, (String)"<this>");
        CharSequence charSequence = $this$rmWhitespaceBetweenHtmlTags;
        Regex regex = new Regex("(?<=>)(\\s*)(?=\\w)");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("(?<=\\w)(\\s*)(?=<)");
        string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("(?<=>)(\\s*)(?=<)");
        string = "";
        return ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)regex.replace(charSequence, string), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null))).toString();
    }
}

