/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.processor;

import de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction;
import de.tschuehly.spring.viewcomponent.core.action.GetViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PatchViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PostViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PutViewAction;
import de.tschuehly.spring.viewcomponent.core.action.ViewActionMethod;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentParser;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentProcessingException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SupportedAnnotationTypes(value={"de.tschuehly.spring.viewcomponent.core.component.ViewComponent"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\u00020\u0006*\u00020 H\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\u0006*\u00020 H\u0002J\u0018\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040#*\u00020 H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "buildType", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "rootDir", "", "checkIfMethodIsPublic", "", "method", "Ljavax/lang/model/element/Element;", "element", "getSrcDir", "Ljava/nio/file/Path;", "messager", "Ljavax/annotation/processing/Messager;", "getSrcHtmlFile", "Ljava/io/File;", "srcDirPath", "viewComponentName", "Ljavax/lang/model/element/Name;", "getViewActionMethods", "", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionMethod;", "process", "", "annotations", "", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "getJavaRootDir", "Ljavax/annotation/processing/ProcessingEnvironment;", "getKotlinRootDir", "getRootDirAndBuildType", "Lkotlin/Pair;", "spring-view-component-core"})
@SourceDebugExtension(value={"SMAP\nViewComponentProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentProcessor.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1855#2,2:194\n766#2:196\n857#2,2:197\n1603#2,9:199\n1855#2:208\n1856#2:210\n1612#2:211\n1#3:209\n*S KotlinDebug\n*F\n+ 1 ViewComponentProcessor.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentProcessor\n*L\n127#1:194,2\n143#1:196\n143#1:197,2\n143#1:199,9\n143#1:208\n143#1:210\n143#1:211\n143#1:209\n*E\n"})
public final class ViewComponentProcessor
extends AbstractProcessor {
    @Nullable
    private String rootDir;
    @Nullable
    private ViewComponentParser.BuildType buildType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                Object object;
                String viewComponentName;
                Messager messager = this.processingEnv.getMessager();
                Filer filer = this.processingEnv.getFiler();
                if (this.rootDir == null || this.buildType == null) {
                    boolean bl;
                    ProcessingEnvironment processingEnvironment = this.processingEnv;
                    Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
                    Pair<String, ViewComponentParser.BuildType> rootDirAndBuildType = this.getRootDirAndBuildType(processingEnvironment);
                    this.rootDir = (String)rootDirAndBuildType.getFirst();
                    this.buildType = (ViewComponentParser.BuildType)((Object)rootDirAndBuildType.getSecond());
                    boolean bl2 = bl = this.rootDir != null || this.buildType != null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                }
                String separator = FileSystems.getDefault().getSeparator();
                String string = String.valueOf(element.getEnclosingElement());
                Intrinsics.checkNotNull((Object)separator);
                String packagePath = StringsKt.replace$default((String)string, (String)".", (String)separator, (boolean)false, (int)4, null);
                String string2 = this.rootDir;
                Intrinsics.checkNotNull((Object)string2);
                Path srcDir = this.getSrcDir(string2, messager);
                String[] stringArray = new String[]{packagePath};
                Path viewComponentDir = FileSystems.getDefault().getPath(((Object)srcDir).toString(), stringArray);
                Intrinsics.checkNotNull((Object)viewComponentDir);
                Name name = element.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getSimpleName(...)");
                Intrinsics.checkNotNull((Object)messager);
                File srcHtmlFile = this.getSrcHtmlFile(viewComponentDir, name, messager);
                Intrinsics.checkNotNull((Object)element);
                List<ViewActionMethod> methodList = this.getViewActionMethods(element);
                Intrinsics.checkNotNullExpressionValue((Object)element.getSimpleName().toString().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                ViewComponentParser.BuildType buildType = this.buildType;
                Intrinsics.checkNotNull((Object)((Object)buildType));
                ViewComponentParser viewComponentParser = new ViewComponentParser(srcHtmlFile, buildType, methodList, viewComponentName, messager);
                String generatedFile = viewComponentParser.parseFile(false);
                if (generatedFile == null || StringsKt.endsWith$default((String)generatedFile, (String)"kt", (boolean)false, (int)2, null)) continue;
                FileObject fil = filer.getResource(StandardLocation.SOURCE_OUTPUT, StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)generatedFile, (String)"/", null, (int)2, null), (String)"/", (String)".", (boolean)false, (int)4, null), StringsKt.substringAfterLast$default((String)generatedFile, (String)"/", null, (int)2, null));
                Closeable closeable = fil.openReader(true);
                Object object2 = null;
                try {
                    Reader it = (Reader)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    object = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
                String generatedSourceText = object;
                JavaFileObject srcFile = this.processingEnv.getFiler().createSourceFile(StringsKt.replace$default((String)StringsKt.replace$default((String)generatedFile, (String)"/", (String)".", (boolean)false, (int)4, null), (String)".java", (String)"", (boolean)false, (int)4, null), new Element[0]);
                object2 = srcFile.openWriter();
                object = null;
                try {
                    Writer it = (Writer)object2;
                    boolean bl = false;
                    it.write(generatedSourceText);
                    it.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
            }
        }
        return true;
    }

    private final Path getSrcDir(String rootDir, Messager messager) {
        Path mainPath;
        block2: {
            Object object = new String[]{"src", "main"};
            mainPath = FileSystems.getDefault().getPath(rootDir, (String)object);
            Path path = mainPath.resolve("kotlin");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            object = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path2 = mainPath.resolve("kotlin");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                return path2;
            }
            Path path3 = mainPath.resolve("java");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            object = path3;
            linkOptionArray = new LinkOption[]{};
            if (Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path4 = mainPath.resolve("java");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                return path4;
            }
            Messager messager2 = messager;
            if (messager2 == null) break block2;
            messager2.printMessage(Diagnostic.Kind.ERROR, "No src main found");
        }
        throw new ViewComponentProcessingException(mainPath + "/src/main/[java,kotlin] not found", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJavaRootDir(ProcessingEnvironment $this$getJavaRootDir) {
        try {
            String fileName = "rootDirFind_" + new Date().toInstant().toEpochMilli();
            JavaFileObject sourceFile = $this$getJavaRootDir.getFiler().createSourceFile(fileName, new Element[0]);
            Closeable closeable = sourceFile.openWriter();
            Throwable throwable = null;
            try {
                Writer it = (Writer)closeable;
                boolean bl = false;
                it.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return ((Object)Paths.get(sourceFile.toUri())).toString();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to determine source file path!");
            $this$getJavaRootDir.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not get create class file");
            throw new ViewComponentProcessingException("Could not get create class file", null);
        }
    }

    private final String getKotlinRootDir(ProcessingEnvironment $this$getKotlinRootDir) {
        String string = $this$getKotlinRootDir.getOptions().get("kapt.kotlin.generated");
        if (string != null) {
            String filePath = string;
            boolean bl = false;
            return filePath;
        }
        return null;
    }

    private final Pair<String, ViewComponentParser.BuildType> getRootDirAndBuildType(ProcessingEnvironment $this$getRootDirAndBuildType) {
        String filePath;
        String string = this.getKotlinRootDir($this$getRootDirAndBuildType);
        if (string == null) {
            string = this.getJavaRootDir($this$getRootDirAndBuildType);
        }
        if (StringsKt.contains$default((CharSequence)(filePath = string), (CharSequence)"target", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"target"};
            return TuplesKt.to(StringsKt.split$default((CharSequence)filePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0), (Object)((Object)ViewComponentParser.BuildType.MAVEN));
        }
        if (StringsKt.contains$default((CharSequence)filePath, (CharSequence)"build", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"build"};
            return TuplesKt.to(StringsKt.split$default((CharSequence)filePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0), (Object)((Object)ViewComponentParser.BuildType.GRADLE));
        }
        $this$getRootDirAndBuildType.getMessager().printMessage(Diagnostic.Kind.ERROR, "No build or target folder found");
        throw new ViewComponentProcessingException("No build or target folder found", null);
    }

    private final File getSrcHtmlFile(Path srcDirPath, Name viewComponentName, Messager messager) {
        Object[] objectArray = new String[]{".html", ".jte", ".kte", ".th"};
        List fileEndings = CollectionsKt.listOf((Object[])objectArray);
        List testedFiles = new ArrayList();
        Iterable $this$forEach$iv = fileEndings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileEnding = (String)element$iv;
            boolean bl = false;
            Path path = srcDirPath.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            File file = path.resolve(viewComponentName + fileEnding).toFile();
            if (file.exists()) {
                messager.printMessage(Diagnostic.Kind.NOTE, "Found ViewComponent Template at " + file.getPath());
                Intrinsics.checkNotNull((Object)file);
                return file;
            }
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            testedFiles.add(string);
        }
        messager.printMessage(Diagnostic.Kind.ERROR, "Couldn't find a template for " + viewComponentName + " tried at following paths: " + testedFiles);
        throw new ViewComponentProcessingException("Couldn't find a file at " + srcDirPath, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ViewActionMethod> getViewActionMethods(Element element) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List<? extends Element> list = element.getEnclosedElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEnclosedElements(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element it = (Element)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ElementKind.METHOD)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ViewActionMethod viewActionMethod;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element method = (Element)element$iv$iv;
            boolean bl2 = false;
            if (method.getAnnotation(GetViewAction.class) != null) {
                GetViewAction get;
                Intrinsics.checkNotNull((Object)method.getAnnotation(GetViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.GetViewAction");
                Intrinsics.checkNotNull((Object)method);
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), get.path(), GetViewAction.class);
            } else if (method.getAnnotation(PostViewAction.class) != null) {
                PostViewAction post;
                Intrinsics.checkNotNull((Object)method.getAnnotation(PostViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PostViewAction");
                Intrinsics.checkNotNull((Object)method);
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), post.path(), PostViewAction.class);
            } else if (method.getAnnotation(PutViewAction.class) != null) {
                PutViewAction put;
                Intrinsics.checkNotNull((Object)method.getAnnotation(PutViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PutViewAction");
                Intrinsics.checkNotNull((Object)method);
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), put.path(), PutViewAction.class);
            } else if (method.getAnnotation(PatchViewAction.class) != null) {
                PatchViewAction patch;
                Intrinsics.checkNotNull((Object)method.getAnnotation(PatchViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PatchViewAction");
                Intrinsics.checkNotNull((Object)method);
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), patch.path(), PatchViewAction.class);
            } else if (method.getAnnotation(DeleteViewAction.class) != null) {
                DeleteViewAction delete;
                Intrinsics.checkNotNull((Object)method.getAnnotation(DeleteViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction");
                Intrinsics.checkNotNull((Object)method);
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), delete.path(), DeleteViewAction.class);
            } else {
                viewActionMethod = null;
            }
            if (viewActionMethod == null) continue;
            ViewActionMethod it$iv$iv = viewActionMethod;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List methodList = (List)destination$iv$iv;
        return methodList;
    }

    private final void checkIfMethodIsPublic(Element method, Element element) {
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ViewComponentProcessingException("Method: " + element.getSimpleName() + "::" + method.getSimpleName() + " needs to be public", null);
        }
    }
}

