/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core;

import de.tschuehly.spring.viewcomponent.core.ViewComponentChangeListener;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\b"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration;", "", "()V", "viewComponentFileSystemWatcher", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "StartWatcherConfiguration", "spring-view-component-core"})
public class ViewComponentAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"viewcomponent.localDevelopment"})
    @NotNull
    public FileSystemWatcher viewComponentFileSystemWatcher(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        FileSystemWatcher fileSystemWatcher = new FileSystemWatcher(true, Duration.ofMillis(500L), Duration.ofMillis(300L));
        if (new File("src/main/kotlin").isDirectory()) {
            fileSystemWatcher.addSourceDirectory(new File("src/main/kotlin/"));
        }
        if (new File("src/main/java").isDirectory()) {
            fileSystemWatcher.addSourceDirectory(new File("src/main/java/"));
        }
        fileSystemWatcher.addListener((FileChangeListener)new ViewComponentChangeListener((ApplicationEventPublisher)applicationContext));
        return fileSystemWatcher;
    }

    @Configuration
    @ConditionalOnProperty(value={"viewcomponent.localDevelopment"})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration$StartWatcherConfiguration;", "", "fileSystemWatcher", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "(Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;)V", "getFileSystemWatcher", "()Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "startWatcher", "", "spring-view-component-core"})
    public static class StartWatcherConfiguration {
        @NotNull
        private final FileSystemWatcher fileSystemWatcher;

        public StartWatcherConfiguration(@NotNull FileSystemWatcher fileSystemWatcher) {
            Intrinsics.checkNotNullParameter((Object)fileSystemWatcher, (String)"fileSystemWatcher");
            this.fileSystemWatcher = fileSystemWatcher;
        }

        @NotNull
        public FileSystemWatcher getFileSystemWatcher() {
            return this.fileSystemWatcher;
        }

        @PostConstruct
        public void startWatcher() {
            this.getFileSystemWatcher().start();
        }
    }
}

