/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.util;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.owasp.esapi.reference.crypto.CryptoPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JCAManager {
    private static JCAManager instance = null;
    private boolean bIsInitialized = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(JCAManager.class);
    public static final String DEFAULT_CIPHER_ALGO = "RSA/ECB/PKCS1Padding";
    public static final String DEFAULT_DSA_CIPHER_ALGO = "DSA/ECB/PKCS1Padding";

    private JCAManager() {
    }

    public static synchronized JCAManager getInstance() {
        if (instance == null) {
            instance = new JCAManager();
            instance.init();
        }
        return instance;
    }

    public synchronized void init() {
        if (!this.bIsInitialized) {
            try {
                LOGGER.debug("JCAManager init() : bIsInitialized = false");
                Security.addProvider((Provider)new BouncyCastleProvider());
                Cipher keyCipher = Cipher.getInstance(DEFAULT_CIPHER_ALGO, "BC");
                keyCipher.getAlgorithm();
                Provider[] providers = Security.getProviders();
                for (int i = 0; i < providers.length; ++i) {
                    LOGGER.debug("Provider " + i + " : " + providers[i].getInfo());
                }
                try {
                    if (!CryptoPolicy.isUnlimitedStrengthCryptoAvailable()) {
                        throw new InvalidKeyException("isUnlimitedStrengthCryptoAvailable failed");
                    }
                    LOGGER.debug("---- Unlimited strength crypto available ----");
                }
                catch (InvalidKeyException ike) {
                    String msg = "Unlimited strength cryptography NOT available !";
                    LOGGER.error(msg, (Throwable)ike);
                }
                this.bIsInitialized = true;
            }
            catch (GeneralSecurityException ex) {
                String msg = "Problem while registration of the crypto providers";
                LOGGER.error(msg, (Throwable)ex);
            }
        }
    }

    static {
        JCAManager.getInstance();
        LOGGER.info("JCAManager.getInstance() in static block");
    }
}

