/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.util;

import de.trustable.util.OidNameMapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;

public class AlgorithmInfo {
    private String sigAlgName;
    private String hashAlgName = "undefined";
    private String paddingAlgName = "PKCS1";
    private String mfgName = "";
    static Map<String, String> hashToNormalizedName = new HashMap<String, String>();
    static Map<String, String> signingAlgoToNormalizedName;

    public AlgorithmInfo(String algoNames) {
        this.sigAlgName = OidNameMapper.lookupOid(algoNames).toLowerCase();
        if (this.sigAlgName.equals("ed25519")) {
            this.hashAlgName = "sha-256";
            this.sigAlgName = "ed25519";
        } else if (this.sigAlgName.contains("withrsaencryption")) {
            String[] parts = this.sigAlgName.split("with");
            this.hashAlgName = parts[0];
            if (hashToNormalizedName.containsKey(this.hashAlgName)) {
                this.hashAlgName = hashToNormalizedName.get(this.hashAlgName);
            }
            this.sigAlgName = "rsa";
        } else if (this.sigAlgName.contains("with")) {
            String[] parts = this.sigAlgName.split("with");
            if (parts.length > 1) {
                this.hashAlgName = parts[1];
                if (hashToNormalizedName.containsKey(this.hashAlgName)) {
                    this.hashAlgName = hashToNormalizedName.get(this.hashAlgName);
                }
                if (parts[1].contains("and")) {
                    String[] parts2 = parts[1].split("and");
                    this.sigAlgName = parts2[0];
                    if (parts2.length > 1) {
                        this.paddingAlgName = parts2[1];
                    }
                } else {
                    this.sigAlgName = AlgorithmInfo.getSigAlgoShortName(parts[0]);
                }
            }
        } else if (this.sigAlgName.equals("rsapss")) {
            this.sigAlgName = "rsa";
            this.hashAlgName = "";
            this.paddingAlgName = "pss";
        }
    }

    public AlgorithmInfo(RSASSAPSSparams rsassapssParams) {
        this.paddingAlgName = "pss";
        this.sigAlgName = "rsa";
        this.hashAlgName = OidNameMapper.lookupOid(rsassapssParams.getHashAlgorithm().getAlgorithm().getId());
        this.mfgName = OidNameMapper.lookupOid(rsassapssParams.getMaskGenAlgorithm().getAlgorithm().getId());
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getSigAlgFriendlyName() {
        if ("RSAEncryption".equalsIgnoreCase(this.sigAlgName)) {
            return "rsa";
        }
        return this.sigAlgName;
    }

    public String getHashAlgName() {
        return this.hashAlgName;
    }

    public String getPaddingAlgName() {
        return this.paddingAlgName;
    }

    public String getMfgName() {
        return this.mfgName;
    }

    static String getSigAlgoShortName(String sigAlgName) {
        if (signingAlgoToNormalizedName.containsKey(sigAlgName.toLowerCase(Locale.ROOT))) {
            return signingAlgoToNormalizedName.get(sigAlgName.toLowerCase(Locale.ROOT));
        }
        return sigAlgName;
    }

    static {
        hashToNormalizedName.put("sha1", "sha-1");
        hashToNormalizedName.put("sha256", "sha-256");
        hashToNormalizedName.put("sha384", "sha-384");
        hashToNormalizedName.put("sha512", "sha-512");
        signingAlgoToNormalizedName = new HashMap<String, String>();
        signingAlgoToNormalizedName.put("rsaencryption", "rsa");
        signingAlgoToNormalizedName.put("ecpublickey", "ecdsa");
    }
}

