/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.ssl_utils;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class ExtensionsUtils {
    public static final String CRL_NUMBER_OID = Extension.cRLNumber.toString();
    public static final String AUTHORITY_KEY_IDENTIFIER_OID = Extension.authorityKeyIdentifier.toString();
    public static final String SUBJECT_ALTERNATIVE_NAME_OID = Extension.subjectAlternativeName.toString();
    private static final Map<String, Integer> keyUsageFlags = new HashMap<String, Integer>(){
        {
            this.put("digital_signature", 128);
            this.put("non_repudiation", 64);
            this.put("key_encipherment", 32);
            this.put("data_encipherment", 16);
            this.put("key_agreement", 8);
            this.put("key_cert_sign", 4);
            this.put("crl_sign", 2);
            this.put("encipher_only", 1);
            this.put("decipher_only", 32768);
        }
    };
    private static final Map<Integer, String> generalNameTags = new HashMap<Integer, String>(){
        {
            this.put(0, "other_name");
            this.put(1, "rfc822_name");
            this.put(2, "dns_name");
            this.put(3, "x400_address");
            this.put(4, "directory_name");
            this.put(5, "edi_party_name");
            this.put(6, "uri");
            this.put(7, "ip");
            this.put(8, "registered_id");
        }
    };

    public static boolean isSubtreeOf(String parentOid, String oid) {
        String[] oidParts;
        String[] parentParts = parentOid.split("\\.");
        if (parentParts.length >= (oidParts = oid.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < parentParts.length; ++i) {
            if (parentParts[i].equals(oidParts[i])) continue;
            return false;
        }
        return true;
    }

    public static List<Map<String, Object>> getExtensionList(X509Certificate cert) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(cert);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static List<Map<String, Object>> getExtensionList(X509CRL crl) throws IOException, CRLException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCRL(crl);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static List<Map<String, Object>> getExtensionList(PKCS10CertificationRequest csr) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(csr);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static Map<String, Object> getExtension(X509Certificate cert, String oid) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(cert);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(oid));
        }
        return null;
    }

    public static Map<String, Object> getExtension(X509CRL crl, String oid) throws IOException, CRLException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCRL(crl);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(oid));
        }
        return null;
    }

    public static Map<String, Object> getExtension(PKCS10CertificationRequest csr, String oid) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(csr);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(oid));
        }
        return null;
    }

    public static Map<String, Object> getExtension(List<Map<String, Object>> extList, String oid) {
        for (Map<String, Object> ext : extList) {
            if (!ext.get("oid").equals(oid)) continue;
            return ext;
        }
        return null;
    }

    public static Object getExtensionValue(X509Certificate cert, String oid) throws IOException, CertificateEncodingException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(cert, oid));
    }

    public static Object getExtensionValue(X509CRL crl, String oid) throws IOException, CRLException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(crl, oid));
    }

    public static Object getExtensionValue(PKCS10CertificationRequest csr, String oid) throws IOException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(csr, oid));
    }

    public static Object getExtensionValue(List<Map<String, Object>> extList, String oid) {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(extList, oid));
    }

    public static Object getExtensionValue(Map<String, Object> extMap) {
        if (extMap != null) {
            return extMap.get("value");
        }
        return null;
    }

    private static List<Map<String, Object>> getExtensionList(Extensions exts) throws IOException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (ASN1ObjectIdentifier oid : exts.getCriticalExtensionOIDs()) {
            ret.add(ExtensionsUtils.makeExtensionMap(exts, oid, true));
        }
        for (ASN1ObjectIdentifier oid : exts.getNonCriticalExtensionOIDs()) {
            ret.add(ExtensionsUtils.makeExtensionMap(exts, oid, false));
        }
        return ret;
    }

    private static Map<String, Object> makeExtensionMap(Extensions exts, ASN1ObjectIdentifier oid) throws IOException {
        boolean critical = Arrays.asList(exts.getCriticalExtensionOIDs()).contains(oid);
        return ExtensionsUtils.makeExtensionMap(exts, oid, critical);
    }

    static Extensions getExtensionsFromCSR(PKCS10CertificationRequest csr) {
        Attribute[] attrs;
        for (Attribute attr : attrs = csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) {
            ASN1Set extsAsn1 = attr.getAttrValues();
            if (extsAsn1 == null) continue;
            ASN1Encodable extObj = extsAsn1.getObjectAt(0);
            if (extObj instanceof Extensions) {
                return (Extensions)extObj;
            }
            if (!(extObj instanceof ASN1Sequence) && !(extObj instanceof ASN1Set)) continue;
            return Extensions.getInstance((Object)extObj);
        }
        return null;
    }

    public static Extensions getExtensionsObjFromMap(List<Map<String, Object>> extMapsList) throws IOException, GeneralSecurityException {
        if (extMapsList != null && extMapsList.size() > 0) {
            ArrayList<Extension> ret = new ArrayList<Extension>();
            for (Map<String, Object> extObj : extMapsList) {
                ret.add(ExtensionsUtils.parseExtensionObject(extObj));
            }
            return new Extensions(ret.toArray(new Extension[ret.size()]));
        }
        return null;
    }

    static Extension parseExtensionObject(Map<String, Object> extMap) throws IOException, GeneralSecurityException {
        String oidString = (String)extMap.get("oid");
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(oidString);
        Boolean isCritical = (Boolean)extMap.get("critical");
        try {
            if (oid.equals((ASN1Primitive)Extension.subjectAlternativeName) || oid.equals((ASN1Primitive)Extension.issuerAlternativeName)) {
                Map val = (Map)extMap.get("value");
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToGeneralNames(val)));
            }
            if (oid.equals((ASN1Primitive)MiscObjectIdentifiers.netscapeCertComment)) {
                DERIA5String ia5Str = new DERIA5String((String)extMap.get("value"));
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ia5Str));
            }
            if (oid.equals((ASN1Primitive)Extension.keyUsage)) {
                Set val = (Set)extMap.get("value");
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.setToKeyUsage(val)));
            }
            if (oid.equals((ASN1Primitive)Extension.extendedKeyUsage)) {
                List list = (List)extMap.get("value");
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.listToExtendedKeyUsage(list)));
            }
            if (oid.equals((ASN1Primitive)Extension.basicConstraints)) {
                Map val = (Map)extMap.get("value");
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToBasicConstraints(val)));
            }
            if (oid.equals((ASN1Primitive)Extension.subjectKeyIdentifier)) {
                PublicKey pubKey = (PublicKey)extMap.get("value");
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.publicKeyToSubjectKeyIdentifier(pubKey)));
            }
            if (oid.equals((ASN1Primitive)Extension.authorityKeyIdentifier)) {
                Map val = (Map)extMap.get("value");
                return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToAuthorityKeyIdentifier(val)));
            }
            if (oid.equals((ASN1Primitive)Extension.cRLNumber)) {
                BigInteger number = (BigInteger)extMap.get("value");
                return new Extension(oid, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)new CRLNumber(number)));
            }
            String value = (String)extMap.get("value");
            return new Extension(oid, isCritical.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)new DERUTF8String(value)));
        }
        catch (OperatorCreationException oce) {
            throw new GeneralSecurityException(oce.getLocalizedMessage());
        }
    }

    private static Extensions getExtensionsFromCert(X509Certificate cert) throws CertificateEncodingException, IOException {
        return new X509CertificateHolder(cert.getEncoded()).getExtensions();
    }

    private static Extensions getExtensionsFromCRL(X509CRL crl) throws CRLException, IOException {
        return new X509CRLHolder(crl.getEncoded()).getExtensions();
    }

    private static Map<String, Object> makeExtensionMap(Extensions exts, ASN1ObjectIdentifier oid, boolean critical) throws IOException {
        Extension ext = exts.getExtension(oid);
        if (ext != null) {
            byte[] extensionData = ext.getExtnValue().getOctets();
            ASN1Object asn1Value = ExtensionsUtils.binaryToASN1Object(oid, extensionData);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("oid", oid.getId());
            ret.put("critical", critical);
            ret.put("value", ExtensionsUtils.asn1ObjToObj((ASN1Encodable)asn1Value));
            return ret;
        }
        return null;
    }

    private static ASN1Object binaryToASN1Object(ASN1ObjectIdentifier oid, byte[] data) throws IOException {
        if (oid.equals((ASN1Primitive)Extension.subjectAlternativeName) || oid.equals((ASN1Primitive)Extension.issuerAlternativeName)) {
            return GeneralNames.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.authorityKeyIdentifier)) {
            return AuthorityKeyIdentifier.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.subjectKeyIdentifier)) {
            return SubjectKeyIdentifier.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.basicConstraints)) {
            return BasicConstraints.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.keyUsage)) {
            DERBitString bs = (DERBitString)ASN1Primitive.fromByteArray((byte[])data);
            return KeyUsage.getInstance((Object)bs);
        }
        if (oid.equals((ASN1Primitive)Extension.extendedKeyUsage)) {
            return ExtendedKeyUsage.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)MiscObjectIdentifiers.netscapeCertComment)) {
            try {
                return ASN1Primitive.fromByteArray((byte[])data);
            }
            catch (EOFException e) {
                return new DERIA5String(new String(data, StandardCharsets.US_ASCII));
            }
        }
        if (oid.equals((ASN1Primitive)Extension.cRLNumber)) {
            return CRLNumber.getInstance((Object)data);
        }
        try {
            return DERUTF8String.getInstance((Object)data);
        }
        catch (Exception e) {
            return new DERUTF8String(new String(data, StandardCharsets.US_ASCII));
        }
    }

    private static Object asn1ObjToObj(ASN1Encodable asn1Prim) throws IOException {
        if (asn1Prim instanceof GeneralNames) {
            return ExtensionsUtils.generalNamesToMap((GeneralNames)asn1Prim);
        }
        if (asn1Prim instanceof ASN1ObjectIdentifier) {
            return ((ASN1ObjectIdentifier)asn1Prim).getId();
        }
        if (asn1Prim instanceof AuthorityKeyIdentifier) {
            return ExtensionsUtils.authorityKeyIdToMap((AuthorityKeyIdentifier)asn1Prim);
        }
        if (asn1Prim instanceof BasicConstraints) {
            return ExtensionsUtils.basicConstraintsToMap((BasicConstraints)asn1Prim);
        }
        if (asn1Prim instanceof CRLNumber) {
            CRLNumber crlNumber = (CRLNumber)asn1Prim;
            return crlNumber.getCRLNumber();
        }
        if (asn1Prim instanceof SubjectKeyIdentifier) {
            SubjectKeyIdentifier ski = (SubjectKeyIdentifier)asn1Prim;
            return ski.getKeyIdentifier();
        }
        if (asn1Prim instanceof ExtendedKeyUsage) {
            return ExtensionsUtils.extKeyUsageToList((ExtendedKeyUsage)asn1Prim);
        }
        if (asn1Prim instanceof KeyPurposeId) {
            KeyPurposeId kpi = (KeyPurposeId)asn1Prim;
            return kpi.getId();
        }
        if (asn1Prim instanceof KeyUsage) {
            KeyUsage ku = (KeyUsage)asn1Prim;
            return ExtensionsUtils.keyUsageToSet(ku);
        }
        if (asn1Prim instanceof DERBitString) {
            DERBitString bitString = (DERBitString)asn1Prim;
            return bitString.getString();
        }
        if (asn1Prim instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedObj = (ASN1TaggedObject)asn1Prim;
            return ExtensionsUtils.asn1ObjToObj((ASN1Encodable)taggedObj.getObject());
        }
        if (asn1Prim instanceof ASN1Sequence) {
            return ExtensionsUtils.asn1SeqToList((ASN1Sequence)asn1Prim);
        }
        if (asn1Prim instanceof ASN1String) {
            ASN1String str = (ASN1String)asn1Prim;
            return str.getString();
        }
        if (asn1Prim instanceof ASN1OctetString) {
            ASN1OctetString str = (ASN1OctetString)asn1Prim;
            return new String(str.getOctets(), StandardCharsets.UTF_8);
        }
        if (asn1Prim instanceof X500Name) {
            X500Name name = (X500Name)asn1Prim;
            return name.toString();
        }
        return asn1Prim.toASN1Primitive().getEncoded();
    }

    private static Set<String> keyUsageToSet(KeyUsage ku) {
        HashSet<String> ret = new HashSet<String>();
        for (String key : keyUsageFlags.keySet()) {
            if (!ku.hasUsages(keyUsageFlags.get(key).intValue())) continue;
            ret.add(key);
        }
        return ret;
    }

    private static KeyUsage setToKeyUsage(Set<String> flags) {
        int usageBitString = 0;
        for (String key : flags) {
            Integer flagBit = keyUsageFlags.get(key);
            if (flagBit == null) {
                throw new IllegalArgumentException("The provided usage key does not exist: '" + key + "'");
            }
            usageBitString |= flagBit.intValue();
        }
        return new KeyUsage(usageBitString);
    }

    private static ExtendedKeyUsage listToExtendedKeyUsage(List<String> oidList) {
        ArrayList<KeyPurposeId> usages = new ArrayList<KeyPurposeId>();
        for (String oid : oidList) {
            usages.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(oid)));
        }
        return new ExtendedKeyUsage(usages.toArray(new KeyPurposeId[usages.size()]));
    }

    private static List<Object> extKeyUsageToList(ExtendedKeyUsage eku) throws IOException {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (KeyPurposeId kpid : eku.getUsages()) {
            ret.add(ExtensionsUtils.asn1ObjToObj((ASN1Encodable)kpid));
        }
        return ret;
    }

    private static Map<String, Object> basicConstraintsToMap(BasicConstraints bc) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("is_ca", bc.isCA());
        ret.put("path_len_constraint", bc.getPathLenConstraint());
        return ret;
    }

    private static BasicConstraints mapToBasicConstraints(Map<String, Object> bcMap) {
        BasicConstraints bc;
        Boolean isCa = (Boolean)bcMap.get("is_ca");
        if (isCa == null) {
            throw new IllegalArgumentException("The 'is_ca' key must be present in a basic constraint.");
        }
        Integer pathLenConstraint = (Integer)bcMap.get("path_len_constraint");
        if (pathLenConstraint != null) {
            if (!isCa.booleanValue()) {
                throw new IllegalArgumentException("The 'path_len_constraint' key is not supported for an 'is_ca' value of 'false'");
            }
            bc = new BasicConstraints(pathLenConstraint.intValue());
        } else {
            bc = new BasicConstraints(isCa.booleanValue());
        }
        return bc;
    }

    private static SubjectKeyIdentifier publicKeyToSubjectKeyIdentifier(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        DigestCalculator digCalc = new JcaDigestCalculatorProviderBuilder().build().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils utils = new X509ExtensionUtils(digCalc);
        return utils.createSubjectKeyIdentifier(pubKeyInfo);
    }

    private static AuthorityKeyIdentifier mapToAuthorityKeyIdentifier(Map<String, Object> authKeyIdMap) throws OperatorCreationException {
        AuthorityKeyIdentifier authorityKeyId = null;
        PublicKey pubKey = (PublicKey)authKeyIdMap.get("public_key");
        if (pubKey != null) {
            SubjectPublicKeyInfo authPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
            DigestCalculator digCalc = new JcaDigestCalculatorProviderBuilder().build().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
            X509ExtensionUtils utils = new X509ExtensionUtils(digCalc);
            authorityKeyId = utils.createAuthorityKeyIdentifier(authPubKeyInfo);
        }
        BigInteger serialNumber = (BigInteger)authKeyIdMap.get("serial_number");
        if (pubKey == null && serialNumber == null) {
            throw new IllegalArgumentException("Neither 'public_key' nor 'serial_number' provided for auth key identifier.  At least one of these must be provided.");
        }
        String issuer = (String)authKeyIdMap.get("issuer_dn");
        if (issuer == null) {
            if (serialNumber != null) {
                throw new IllegalArgumentException("'issuer' not provided for auth key identifier but was expected since 'serial_number' was provided");
            }
        } else {
            if (serialNumber == null) {
                throw new IllegalArgumentException("'serial_number' not provided for auth key identifierbut was expected since 'issuer' was provided");
            }
            GeneralNames issuerAsGeneralNames = new GeneralNames(new GeneralName(new X500Name(issuer)));
            authorityKeyId = authorityKeyId != null ? new AuthorityKeyIdentifier(authorityKeyId.getKeyIdentifier(), issuerAsGeneralNames, serialNumber) : new AuthorityKeyIdentifier(issuerAsGeneralNames, serialNumber);
        }
        return authorityKeyId;
    }

    private static Map<String, Object> authorityKeyIdToMap(AuthorityKeyIdentifier akid) throws IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("issuer", ExtensionsUtils.generalNamesToMap(akid.getAuthorityCertIssuer()));
        ret.put("serial_number", akid.getAuthorityCertSerialNumber());
        ret.put("key_identifier", akid.getKeyIdentifier());
        return ret;
    }

    private static List<Object> asn1SeqToList(ASN1Sequence seq) throws IOException {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < seq.size(); ++i) {
            ret.add(ExtensionsUtils.asn1ObjToObj(seq.getObjectAt(i)));
        }
        return ret;
    }

    private static Integer getGnTagFromName(String name) {
        for (int i = 0; i < generalNameTags.size(); ++i) {
            if (!generalNameTags.get(i).equalsIgnoreCase(name)) continue;
            return i;
        }
        return null;
    }

    public static String octetStringToIpString(ASN1OctetString ip) throws UnknownHostException {
        return InetAddress.getByAddress(ip.getOctets()).toString().split("/")[1];
    }

    private static Map<String, List<String>> generalNamesToMap(GeneralNames names) throws IOException {
        if (names != null) {
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            for (GeneralName generalName : names.getNames()) {
                String name;
                String type = generalNameTags.get(generalName.getTagNo());
                if (ret.get(type) == null) {
                    ret.put(type, new ArrayList());
                }
                switch (generalName.getTagNo()) {
                    case 7: {
                        name = ExtensionsUtils.octetStringToIpString((ASN1OctetString)generalName.getName());
                        break;
                    }
                    default: {
                        name = ExtensionsUtils.asn1ObjToObj(generalName.getName()).toString();
                    }
                }
                ((List)ret.get(type)).add(name);
            }
            return ret;
        }
        return null;
    }

    private static GeneralNames mapToGeneralNames(Map<String, List<String>> gnMap) {
        ArrayList<GeneralName> ret = new ArrayList<GeneralName>();
        for (String type : gnMap.keySet()) {
            Integer tag = ExtensionsUtils.getGnTagFromName(type);
            if (tag == null) {
                throw new IllegalArgumentException("Could not find a tag number for the type name '" + type + '\"');
            }
            for (String name : gnMap.get(type)) {
                ret.add(new GeneralName(tag.intValue(), name));
            }
        }
        return new GeneralNames(ret.toArray(new GeneralName[ret.size()]));
    }
}

