/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.util;

import java.util.HashMap;
import java.util.Map;

public class OidNameMapper {
    static Map<String, String> oidToName = new HashMap<String, String>();
    static Map<String, String> nameToOid = new HashMap<String, String>();

    static void insertMap(String oid, String name) {
        String dottedOid = oid.replace(' ', '.');
        oidToName.put(oid, name);
        oidToName.put(dottedOid, name);
        nameToOid.put(name, dottedOid);
    }

    public static String lookupOid(String oid) {
        if (oidToName.containsKey(oid.trim())) {
            return oidToName.get(oid);
        }
        return oid;
    }

    static {
        OidNameMapper.insertMap("0 2 262 1 10", "Telesec");
        OidNameMapper.insertMap("0 2 262 1 10 0", "extension");
        OidNameMapper.insertMap("0 2 262 1 10 1", "mechanism");
        OidNameMapper.insertMap("0 2 262 1 10 1 0", "authentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 1", "passwordAuthentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 2", "protectedPasswordAuthentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 3", "oneWayX509Authentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 4", "twoWayX509Authentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 5", "threeWayX509Authentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 6", "oneWayISO9798Authentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 7", "twoWayISO9798Authentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 0 8", "telekomAuthentication");
        OidNameMapper.insertMap("0 2 262 1 10 1 1", "signature");
        OidNameMapper.insertMap("0 2 262 1 10 1 1 1", "md4WithRSAAndISO9697");
        OidNameMapper.insertMap("0 2 262 1 10 1 1 2", "md4WithRSAAndTelesecSignatureStandard");
        OidNameMapper.insertMap("0 2 262 1 10 1 1 3", "md5WithRSAAndISO9697");
        OidNameMapper.insertMap("0 2 262 1 10 1 1 4", "md5WithRSAAndTelesecSignatureStandard");
        OidNameMapper.insertMap("0 2 262 1 10 1 1 5", "ripemd160WithRSAAndTelekomSignatureStandard");
        OidNameMapper.insertMap("0 2 262 1 10 1 1 9", "hbciRsaSignature");
        OidNameMapper.insertMap("0 2 262 1 10 1 2", "encryption");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 0", "none");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 1", "rsaTelesec");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 2", "des");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 2 1", "desECB");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 2 2", "desCBC");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 2 3", "desOFB");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 2 4", "desCFB8");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 2 5", "desCFB64");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 3", "des3");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 3 1", "des3ECB");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 3 2", "des3CBC");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 3 3", "des3OFB");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 3 4", "des3CFB8");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 3 5", "des3CFB64");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 4", "magenta");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 5", "idea");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 5 1", "ideaECB");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 5 2", "ideaCBC");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 5 3", "ideaOFB");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 5 4", "ideaCFB8");
        OidNameMapper.insertMap("0 2 262 1 10 1 2 5 5", "ideaCFB64");
        OidNameMapper.insertMap("0 2 262 1 10 1 3", "oneWayFunction");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 1", "md4");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 2", "md5");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 3", "sqModNX509");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 4", "sqModNISO");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 5", "ripemd128");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 6", "hashUsingBlockCipher");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 7", "mac");
        OidNameMapper.insertMap("0 2 262 1 10 1 3 8", "ripemd160");
        OidNameMapper.insertMap("0 2 262 1 10 1 4", "fecFunction");
        OidNameMapper.insertMap("0 2 262 1 10 1 4 1", "reedSolomon");
        OidNameMapper.insertMap("0 2 262 1 10 2", "module");
        OidNameMapper.insertMap("0 2 262 1 10 2 0", "algorithms");
        OidNameMapper.insertMap("0 2 262 1 10 2 1", "attributeTypes");
        OidNameMapper.insertMap("0 2 262 1 10 2 2", "certificateTypes");
        OidNameMapper.insertMap("0 2 262 1 10 2 3", "messageTypes");
        OidNameMapper.insertMap("0 2 262 1 10 2 4", "plProtocol");
        OidNameMapper.insertMap("0 2 262 1 10 2 5", "smeAndComponentsOfSme");
        OidNameMapper.insertMap("0 2 262 1 10 2 6", "fec");
        OidNameMapper.insertMap("0 2 262 1 10 2 7", "usefulDefinitions");
        OidNameMapper.insertMap("0 2 262 1 10 2 8", "stefiles");
        OidNameMapper.insertMap("0 2 262 1 10 2 9", "sadmib");
        OidNameMapper.insertMap("0 2 262 1 10 2 10", "electronicOrder");
        OidNameMapper.insertMap("0 2 262 1 10 2 11", "telesecTtpAsymmetricApplication");
        OidNameMapper.insertMap("0 2 262 1 10 2 12", "telesecTtpBasisApplication");
        OidNameMapper.insertMap("0 2 262 1 10 2 13", "telesecTtpMessages");
        OidNameMapper.insertMap("0 2 262 1 10 2 14", "telesecTtpTimeStampApplication");
        OidNameMapper.insertMap("0 2 262 1 10 3", "objectClass");
        OidNameMapper.insertMap("0 2 262 1 10 3 0", "telesecOtherName");
        OidNameMapper.insertMap("0 2 262 1 10 3 1", "directory");
        OidNameMapper.insertMap("0 2 262 1 10 3 2", "directoryType");
        OidNameMapper.insertMap("0 2 262 1 10 3 3", "directoryGroup");
        OidNameMapper.insertMap("0 2 262 1 10 3 4", "directoryUser");
        OidNameMapper.insertMap("0 2 262 1 10 3 5", "symmetricKeyEntry");
        OidNameMapper.insertMap("0 2 262 1 10 4", "package");
        OidNameMapper.insertMap("0 2 262 1 10 5", "parameter");
        OidNameMapper.insertMap("0 2 262 1 10 6", "nameBinding");
        OidNameMapper.insertMap("0 2 262 1 10 7", "attribute");
        OidNameMapper.insertMap("0 2 262 1 10 7 0", "applicationGroupIdentifier");
        OidNameMapper.insertMap("0 2 262 1 10 7 1", "certificateType");
        OidNameMapper.insertMap("0 2 262 1 10 7 2", "telesecCertificate");
        OidNameMapper.insertMap("0 2 262 1 10 7 3", "certificateNumber");
        OidNameMapper.insertMap("0 2 262 1 10 7 4", "certificateRevocationList");
        OidNameMapper.insertMap("0 2 262 1 10 7 5", "creationDate");
        OidNameMapper.insertMap("0 2 262 1 10 7 6", "issuer");
        OidNameMapper.insertMap("0 2 262 1 10 7 7", "namingAuthority");
        OidNameMapper.insertMap("0 2 262 1 10 7 8", "publicKeyDirectory");
        OidNameMapper.insertMap("0 2 262 1 10 7 9", "securityDomain");
        OidNameMapper.insertMap("0 2 262 1 10 7 10", "subject");
        OidNameMapper.insertMap("0 2 262 1 10 7 11", "timeOfRevocation");
        OidNameMapper.insertMap("0 2 262 1 10 7 12", "userGroupReference");
        OidNameMapper.insertMap("0 2 262 1 10 7 13", "validity");
        OidNameMapper.insertMap("0 2 262 1 10 7 14", "zert93");
        OidNameMapper.insertMap("0 2 262 1 10 7 15", "securityMessEnv");
        OidNameMapper.insertMap("0 2 262 1 10 7 16", "anonymizedPublicKeyDirectory");
        OidNameMapper.insertMap("0 2 262 1 10 7 17", "telesecGivenName");
        OidNameMapper.insertMap("0 2 262 1 10 7 18", "nameAdditions");
        OidNameMapper.insertMap("0 2 262 1 10 7 19", "telesecPostalCode");
        OidNameMapper.insertMap("0 2 262 1 10 7 20", "nameDistinguisher");
        OidNameMapper.insertMap("0 2 262 1 10 7 21", "telesecCertificateList");
        OidNameMapper.insertMap("0 2 262 1 10 7 22", "teletrustCertificateList");
        OidNameMapper.insertMap("0 2 262 1 10 7 23", "x509CertificateList");
        OidNameMapper.insertMap("0 2 262 1 10 7 24", "timeOfIssue");
        OidNameMapper.insertMap("0 2 262 1 10 7 25", "physicalCardNumber");
        OidNameMapper.insertMap("0 2 262 1 10 7 26", "fileType");
        OidNameMapper.insertMap("0 2 262 1 10 7 27", "ctlFileIsArchive");
        OidNameMapper.insertMap("0 2 262 1 10 7 28", "emailAddress");
        OidNameMapper.insertMap("0 2 262 1 10 7 29", "certificateTemplateList");
        OidNameMapper.insertMap("0 2 262 1 10 7 30", "directoryName");
        OidNameMapper.insertMap("0 2 262 1 10 7 31", "directoryTypeName");
        OidNameMapper.insertMap("0 2 262 1 10 7 32", "directoryGroupName");
        OidNameMapper.insertMap("0 2 262 1 10 7 33", "directoryUserName");
        OidNameMapper.insertMap("0 2 262 1 10 7 34", "revocationFlag");
        OidNameMapper.insertMap("0 2 262 1 10 7 35", "symmetricKeyEntryName");
        OidNameMapper.insertMap("0 2 262 1 10 7 36", "glNumber");
        OidNameMapper.insertMap("0 2 262 1 10 7 37", "goNumber");
        OidNameMapper.insertMap("0 2 262 1 10 7 38", "gKeyData");
        OidNameMapper.insertMap("0 2 262 1 10 7 39", "zKeyData");
        OidNameMapper.insertMap("0 2 262 1 10 7 40", "ktKeyData");
        OidNameMapper.insertMap("0 2 262 1 10 7 41", "ktKeyNumber");
        OidNameMapper.insertMap("0 2 262 1 10 7 51", "timeOfRevocationGen");
        OidNameMapper.insertMap("0 2 262 1 10 7 52", "liabilityText");
        OidNameMapper.insertMap("0 2 262 1 10 8", "attributeGroup");
        OidNameMapper.insertMap("0 2 262 1 10 9", "action");
        OidNameMapper.insertMap("0 2 262 1 10 10", "notification");
        OidNameMapper.insertMap("0 2 262 1 10 11", "snmp-mibs");
        OidNameMapper.insertMap("0 2 262 1 10 11 1", "securityApplication");
        OidNameMapper.insertMap("0 2 262 1 10 12", "certAndCrlExtensionDefinitions");
        OidNameMapper.insertMap("0 2 262 1 10 12 0", "liabilityLimitationFlag");
        OidNameMapper.insertMap("0 2 262 1 10 12 1", "telesecCertIdExt");
        OidNameMapper.insertMap("0 2 262 1 10 12 2", "Telesec policyIdentifier");
        OidNameMapper.insertMap("0 2 262 1 10 12 3", "telesecPolicyQualifierID");
        OidNameMapper.insertMap("0 2 262 1 10 12 4", "telesecCRLFilteredExt");
        OidNameMapper.insertMap("0 2 262 1 10 12 5", "telesecCRLFilterExt");
        OidNameMapper.insertMap("0 2 262 1 10 12 6", "telesecNamingAuthorityExt");
        OidNameMapper.insertMap("0 4 0 127 0 7", "bsi");
        OidNameMapper.insertMap("0 4 0 127 0 7 1", "bsiEcc");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1", "bsifieldType");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 1", "bsiPrimeField");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2", "bsiCharacteristicTwoField");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2 2", "bsiECTLVKeyFormat");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2 2 1", "bsiECTLVPublicKey");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2 3", "bsiCharacteristicTwoBasis");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2 3 1", "bsiGnBasis");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2 3 2", "bsiTpBasis");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 2 3 3", "bsiPpBasis");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1", "bsiEcdsaSignatures");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1 1", "bsiEcdsaWithSHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1 2", "bsiEcdsaWithSHA224");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1 3", "bsiEcdsaWithSHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1 4", "bsiEcdsaWithSHA384");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1 5", "bsiEcdsaWithSHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 4 1 6", "bsiEcdsaWithRIPEMD160");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1", "bsiEckaEgX963KDF");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1 1", "bsiEckaEgX963KDFWithSHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1 2", "bsiEckaEgX963KDFWithSHA224");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1 3", "bsiEckaEgX963KDFWithSHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1 4", "bsiEckaEgX963KDFWithSHA384");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1 5", "bsiEckaEgX963KDFWithSHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 1 6", "bsiEckaEgX963KDFWithRIPEMD160");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 2", "bsiEckaEgSessionKDF");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 2 1", "bsiEckaEgSessionKDFWith3DES");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 2 2", "bsiEckaEgSessionKDFWithAES128");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 2 3", "bsiEckaEgSessionKDFWithAES192");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 1 2 4", "bsiEckaEgSessionKDFWithAES256");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2", "bsiEckaDH");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1", "bsiEckaDHX963KDF");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1 1", "bsiEckaDHX963KDFWithSHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1 2", "bsiEckaDHX963KDFWithSHA224");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1 3", "bsiEckaDHX963KDFWithSHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1 4", "bsiEckaDHX963KDFWithSHA384");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1 5", "bsiEckaDHX963KDFWithSHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 1 6", "bsiEckaDHX963KDFWithRIPEMD160");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 2", "bsiEckaDHSessionKDF");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 2 1", "bsiEckaDHSessionKDFWith3DES");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 2 2", "bsiEckaDHSessionKDFWithAES128");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 2 3", "bsiEckaDHSessionKDFWithAES192");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 1 5 2 2 4", "bsiEckaDHSessionKDFWithAES256");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 2", "bsiEcKeyType");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 2 1", "bsiEcPublicKey");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 5 1", "bsiKaeg");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 5 1 1", "bsiKaegWithX963KDF");
        OidNameMapper.insertMap("0 4 0 127 0 7 1 5 1 2", "bsiKaegWith3DESKDF");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 1", "bsiPK");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 1 1", "bsiPK_DH");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 1 2", "bsiPK_ECDH");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2", "bsiTA");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1", "bsiTA_RSA");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1 1", "bsiTA_RSAv1_5_SHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1 2", "bsiTA_RSAv1_5_SHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1 3", "bsiTA_RSAPSS_SHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1 4", "bsiTA_RSAPSS_SHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1 5", "bsiTA_RSAv1_5_SHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 1 6", "bsiTA_RSAPSS_SHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 2", "bsiTA_ECDSA");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 2 1", "bsiTA_ECDSA_SHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 2 2", "bsiTA_ECDSA_SHA224");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 2 3", "bsiTA_ECDSA_SHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 2 4", "bsiTA_ECDSA_SHA384");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 2 2 5", "bsiTA_ECDSA_SHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3", "bsiCA");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 1", "bsiCA_DH");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 1 1", "bsiCA_DH_3DES_CBC_CBC");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 1 2", "bsiCA_DH_AES_CBC_CMAC_128");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 1 3", "bsiCA_DH_AES_CBC_CMAC_192");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 1 4", "bsiCA_DH_AES_CBC_CMAC_256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 2", "bsiCA_ECDH");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 2 1", "bsiCA_ECDH_3DES_CBC_CBC");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 2 2", "bsiCA_ECDH_AES_CBC_CMAC_128");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 2 3", "bsiCA_ECDH_AES_CBC_CMAC_192");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 3 2 4", "bsiCA_ECDH_AES_CBC_CMAC_256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4", "bsiPACE");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 1", "bsiPACE_DH_GM");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 1 1", "bsiPACE_DH_GM_3DES_CBC_CBC");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 1 2", "bsiPACE_DH_GM_AES_CBC_CMAC_128");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 1 3", "bsiPACE_DH_GM_AES_CBC_CMAC_192");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 1 4", "bsiPACE_DH_GM_AES_CBC_CMAC_256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 2", "bsiPACE_ECDH_GM");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 2 1", "bsiPACE_ECDH_GM_3DES_CBC_CBC");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 2 2", "bsiPACE_ECDH_GM_AES_CBC_CMAC_128");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 2 3", "bsiPACE_ECDH_GM_AES_CBC_CMAC_192");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 2 4", "bsiPACE_ECDH_GM_AES_CBC_CMAC_256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 3", "bsiPACE_DH_IM");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 3 1", "bsiPACE_DH_IM_3DES_CBC_CBC");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 3 2", "bsiPACE_DH_IM_AES_CBC_CMAC_128");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 3 3", "bsiPACE_DH_IM_AES_CBC_CMAC_192");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 3 4", "bsiPACE_DH_IM_AES_CBC_CMAC_256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 4", "bsiPACE_ECDH_IM");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 4 1", "bsiPACE_ECDH_IM_3DES_CBC_CBC");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 4 2", "bsiPACE_ECDH_IM_AES_CBC_CMAC_128");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 4 3", "bsiPACE_ECDH_IM_AES_CBC_CMAC_192");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 4 4 4", "bsiPACE_ECDH_IM_AES_CBC_CMAC_256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5", "bsiRI");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 1", "bsiRI_DH");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 1 1", "bsiRI_DH_SHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 1 2", "bsiRI_DH_SHA224");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 1 3", "bsiRI_DH_SHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 1 4", "bsiRI_DH_SHA384");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 1 5", "bsiRI_DH_SHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 2", "bsiRI_ECDH");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 2 1", "bsiRI_ECDH_SHA1");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 2 2", "bsiRI_ECDH_SHA224");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 2 3", "bsiRI_ECDH_SHA256");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 2 4", "bsiRI_ECDH_SHA384");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 5 2 5", "bsiRI_ECDH_SHA512");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 6", "bsiCardInfo");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 7", "bsiEidSecurity");
        OidNameMapper.insertMap("0 4 0 127 0 7 2 2 8", "bsiPT");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 2", "bsiEACRoles");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 2 1", "bsiEACRolesIS");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 2 2", "bsiEACRolesAT");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 2 3", "bsiEACRolesST");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 3", "bsiTAv2ce");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 3 1", "bsiTAv2ceDescription");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 3 1 1", "bsiTAv2ceDescriptionPlainText");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 3 1 2", "bsiTAv2ceDescriptionIA5String");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 3 1 3", "bsiTAv2ceDescriptionOctetString");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 3 2", "bsiTAv2ceTerminalSector");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 4", "bsiAuxData");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 4 1", "bsiAuxDataBirthday");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 4 2", "bsiAuxDataExpireDate");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 4 3", "bsiAuxDataCommunityID");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5", "bsiDefectList");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 1", "bsiDefectAuthDefect");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 1 1", "bsiDefectCertRevoked");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 1 2", "bsiDefectCertReplaced");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 1 3", "bsiDefectChipAuthKeyRevoked");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 1 4", "bsiDefectActiveAuthKeyRevoked");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 2", "bsiDefectEPassportDefect");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 2 1", "bsiDefectEPassportDGMalformed");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 2 2", "bsiDefectSODInvalid");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 3", "bsiDefectEIDDefect");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 3 1", "bsiDefectEIDDGMalformed");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 3 2", "bsiDefectEIDIntegrity");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 4", "bsiDefectDocumentDefect");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 4 1", "bsiDefectCardSecurityMalformed");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 4 2", "bsiDefectChipSecurityMalformed");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 5 4 3", "bsiDefectPowerDownReq");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 1 6", "bsiListContentDescription");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 2 1", "bsiSecurityObject");
        OidNameMapper.insertMap("0 4 0 127 0 7 3 2 2", "bsiBlackList");
        OidNameMapper.insertMap("0 4 0 1862", "etsiQcsProfile");
        OidNameMapper.insertMap("0 4 0 1862 1", "etsiQcs");
        OidNameMapper.insertMap("0 4 0 1862 1 1", "etsiQcsCompliance");
        OidNameMapper.insertMap("0 4 0 1862 1 2", "etsiQcsLimitValue");
        OidNameMapper.insertMap("0 4 0 1862 1 3", "etsiQcsRetentionPeriod");
        OidNameMapper.insertMap("0 4 0 1862 1 4", "etsiQcsQcSSCD");
        OidNameMapper.insertMap("0 9 2342 19200300 100 1 1", "userID");
        OidNameMapper.insertMap("0 9 2342 19200300 100 1 3", "rfc822Mailbox");
        OidNameMapper.insertMap("0 9 2342 19200300 100 1 25", "domainComponent");
        OidNameMapper.insertMap("1 0 10118 3 0 49", "ripemd160");
        OidNameMapper.insertMap("1 0 10118 3 0 50", "ripemd128");
        OidNameMapper.insertMap("1 0 10118 3 0 55", "whirlpool");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1", "qgpki");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1", "qgpkiPolicies");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 1", "qgpkiMedIntermedCA");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 1 1", "qgpkiMedIntermedIndividual");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 1 2", "qgpkiMedIntermedDeviceControl");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 1 3", "qgpkiMedIntermedDevice");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 1 4", "qgpkiMedIntermedAuthorisedParty");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 1 5", "qgpkiMedIntermedDeviceSystem");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2", "qgpkiMedIssuingCA");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 1", "qgpkiMedIssuingIndividual");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 2", "qgpkiMedIssuingDeviceControl");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 3", "qgpkiMedIssuingDevice");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 4", "qgpkiMedIssuingAuthorisedParty");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 5", "qgpkiMedIssuingClientAuth");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 6", "qgpkiMedIssuingServerAuth");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 7", "qgpkiMedIssuingDataProt");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 2 8", "qgpkiMedIssuingTokenAuth");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 3", "qgpkiBasicIntermedCA");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 3 1", "qgpkiBasicIntermedDeviceSystem");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 4", "qgpkiBasicIssuingCA");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 4 1", "qgpkiBasicIssuingClientAuth");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 4 2", "qgpkiBasicIssuingServerAuth");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 1 4 3", "qgpkiBasicIssuingDataSigning");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 2", "qgpkiAssuranceLevel");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 2 1", "qgpkiAssuranceRudimentary");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 2 2", "qgpkiAssuranceBasic");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 2 3", "qgpkiAssuranceMedium");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 2 4", "qgpkiAssuranceHigh");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 3", "qgpkiCertFunction");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 3 1", "qgpkiFunctionIndividual");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 3 2", "qgpkiFunctionDevice");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 3 3", "qgpkiFunctionAuthorisedParty");
        OidNameMapper.insertMap("1 2 36 1 3 1 1 1 3 4", "qgpkiFunctionDeviceControl");
        OidNameMapper.insertMap("1 2 36 1 3 1 2", "qpspki");
        OidNameMapper.insertMap("1 2 36 1 3 1 2 1", "qpspkiPolicies");
        OidNameMapper.insertMap("1 2 36 1 3 1 2 1 2", "qpspkiPolicyBasic");
        OidNameMapper.insertMap("1 2 36 1 3 1 2 1 3", "qpspkiPolicyMedium");
        OidNameMapper.insertMap("1 2 36 1 3 1 2 1 4", "qpspkiPolicyHigh");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2", "qtmrpki");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 1", "qtmrpkiPolicies");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 2", "qtmrpkiPurpose");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 2 1", "qtmrpkiIndividual");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 2 2", "qtmrpkiDeviceControl");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 2 3", "qtmrpkiDevice");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 2 4", "qtmrpkiAuthorisedParty");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 2 5", "qtmrpkiDeviceSystem");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 3", "qtmrpkiDevice");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 3 1", "qtmrpkiDriverLicense");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 3 2", "qtmrpkiIndustryAuthority");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 3 3", "qtmrpkiMarineLicense");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 3 4", "qtmrpkiAdultProofOfAge");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 3 5", "qtmrpkiSam");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 4", "qtmrpkiAuthorisedParty");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 4 1", "qtmrpkiTransportInspector");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 4 2", "qtmrpkiPoliceOfficer");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 4 3", "qtmrpkiSystem");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 4 4", "qtmrpkiLiquorLicensingInspector");
        OidNameMapper.insertMap("1 2 36 1 3 1 3 2 4 5", "qtmrpkiMarineEnforcementOfficer");
        OidNameMapper.insertMap("1 2 36 1 333 1", "australianBusinessNumber");
        OidNameMapper.insertMap("1 2 36 68980861 1 1 2", "signetPersonal");
        OidNameMapper.insertMap("1 2 36 68980861 1 1 3", "signetBusiness");
        OidNameMapper.insertMap("1 2 36 68980861 1 1 4", "signetLegal");
        OidNameMapper.insertMap("1 2 36 68980861 1 1 10", "signetPilot");
        OidNameMapper.insertMap("1 2 36 68980861 1 1 11", "signetIntraNet");
        OidNameMapper.insertMap("1 2 36 68980861 1 1 20", "signetPolicy");
        OidNameMapper.insertMap("1 2 36 75878867 1 100 1 1", "certificatesAustraliaPolicy");
        OidNameMapper.insertMap("1 2 392 200011 61 1 1 1", "mitsubishiSecurityAlgorithm");
        OidNameMapper.insertMap("1 2 392 200011 61 1 1 1 1", "misty1-cbc");
        OidNameMapper.insertMap("1 2 410 200004 1", "kisaAlgorithm");
        OidNameMapper.insertMap("1 2 410 200004 1 1", "kcdsa");
        OidNameMapper.insertMap("1 2 410 200004 1 2", "has160");
        OidNameMapper.insertMap("1 2 410 200004 1 3", "seedECB");
        OidNameMapper.insertMap("1 2 410 200004 1 4", "seedCBC");
        OidNameMapper.insertMap("1 2 410 200004 1 5", "seedOFB");
        OidNameMapper.insertMap("1 2 410 200004 1 6", "seedCFB");
        OidNameMapper.insertMap("1 2 410 200004 1 7", "seedMAC");
        OidNameMapper.insertMap("1 2 410 200004 1 8", "kcdsaWithHAS160");
        OidNameMapper.insertMap("1 2 410 200004 1 9", "kcdsaWithSHA1");
        OidNameMapper.insertMap("1 2 410 200004 1 10", "pbeWithHAS160AndSEED-ECB");
        OidNameMapper.insertMap("1 2 410 200004 1 11", "pbeWithHAS160AndSEED-CBC");
        OidNameMapper.insertMap("1 2 410 200004 1 12", "pbeWithHAS160AndSEED-CFB");
        OidNameMapper.insertMap("1 2 410 200004 1 13", "pbeWithHAS160AndSEED-OFB");
        OidNameMapper.insertMap("1 2 410 200004 1 14", "pbeWithSHA1AndSEED-ECB");
        OidNameMapper.insertMap("1 2 410 200004 1 15", "pbeWithSHA1AndSEED-CBC");
        OidNameMapper.insertMap("1 2 410 200004 1 16", "pbeWithSHA1AndSEED-CFB");
        OidNameMapper.insertMap("1 2 410 200004 1 17", "pbeWithSHA1AndSEED-OFB");
        OidNameMapper.insertMap("1 2 410 200004 1 20", "rsaWithHAS160");
        OidNameMapper.insertMap("1 2 410 200004 1 21", "kcdsa1");
        OidNameMapper.insertMap("1 2 410 200004 2", "npkiCP");
        OidNameMapper.insertMap("1 2 410 200004 2 1", "npkiSignaturePolicy");
        OidNameMapper.insertMap("1 2 410 200004 3", "npkiKP");
        OidNameMapper.insertMap("1 2 410 200004 4", "npkiAT");
        OidNameMapper.insertMap("1 2 410 200004 5", "npkiLCA");
        OidNameMapper.insertMap("1 2 410 200004 5 1", "npkiSignKorea");
        OidNameMapper.insertMap("1 2 410 200004 5 2", "npkiSignGate");
        OidNameMapper.insertMap("1 2 410 200004 5 3", "npkiNcaSign");
        OidNameMapper.insertMap("1 2 410 200004 6", "npkiON");
        OidNameMapper.insertMap("1 2 410 200004 7", "npkiAPP");
        OidNameMapper.insertMap("1 2 410 200004 7 1", "npkiSMIME");
        OidNameMapper.insertMap("1 2 410 200004 7 1 1", "npkiSMIMEAlgo");
        OidNameMapper.insertMap("1 2 410 200004 7 1 1 1", "npkiCmsSEEDWrap");
        OidNameMapper.insertMap("1 2 410 200004 10", "npki");
        OidNameMapper.insertMap("1 2 410 200004 10 1", "npkiAttribute");
        OidNameMapper.insertMap("1 2 410 200004 10 1 1", "npkiIdentifyData");
        OidNameMapper.insertMap("1 2 410 200004 10 1 1 1", "npkiVID");
        OidNameMapper.insertMap("1 2 410 200004 10 1 1 2", "npkiEncryptedVID");
        OidNameMapper.insertMap("1 2 410 200004 10 1 1 3", "npkiRandomNum");
        OidNameMapper.insertMap("1 2 410 200004 10 1 1 4", "npkiVID");
        OidNameMapper.insertMap("1 2 410 200046 1 1", "aria1AlgorithmModes");
        OidNameMapper.insertMap("1 2 410 200046 1 1 1", "aria128-ecb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 2", "aria128-cbc");
        OidNameMapper.insertMap("1 2 410 200046 1 1 3", "aria128-cfb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 4", "aria128-ofb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 5", "aria128-ctr");
        OidNameMapper.insertMap("1 2 410 200046 1 1 6", "aria192-ecb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 7", "aria192-cbc");
        OidNameMapper.insertMap("1 2 410 200046 1 1 8", "aria192-cfb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 9", "aria192-ofb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 10", "aria192-ctr");
        OidNameMapper.insertMap("1 2 410 200046 1 1 11", "aria256-ecb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 12", "aria256-cbc");
        OidNameMapper.insertMap("1 2 410 200046 1 1 13", "aria256-cfb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 14", "aria256-ofb");
        OidNameMapper.insertMap("1 2 410 200046 1 1 15", "aria256-ctr");
        OidNameMapper.insertMap("1 2 410 200046 1 1 21", "aria128-cmac");
        OidNameMapper.insertMap("1 2 410 200046 1 1 22", "aria192-cmac");
        OidNameMapper.insertMap("1 2 410 200046 1 1 23", "aria256-cmac");
        OidNameMapper.insertMap("1 2 410 200046 1 1 31", "aria128-ocb2");
        OidNameMapper.insertMap("1 2 410 200046 1 1 32", "aria192-ocb2");
        OidNameMapper.insertMap("1 2 410 200046 1 1 33", "aria256-ocb2");
        OidNameMapper.insertMap("1 2 410 200046 1 1 34", "aria128-gcm");
        OidNameMapper.insertMap("1 2 410 200046 1 1 35", "aria192-gcm");
        OidNameMapper.insertMap("1 2 410 200046 1 1 36", "aria256-gcm");
        OidNameMapper.insertMap("1 2 410 200046 1 1 37", "aria128-ccm");
        OidNameMapper.insertMap("1 2 410 200046 1 1 38", "aria192-ccm");
        OidNameMapper.insertMap("1 2 410 200046 1 1 39", "aria256-ccm");
        OidNameMapper.insertMap("1 2 410 200046 1 1 40", "aria128-keywrap");
        OidNameMapper.insertMap("1 2 410 200046 1 1 41", "aria192-keywrap");
        OidNameMapper.insertMap("1 2 410 200046 1 1 42", "aria256-keywrap");
        OidNameMapper.insertMap("1 2 410 200046 1 1 43", "aria128-keywrapWithPad");
        OidNameMapper.insertMap("1 2 410 200046 1 1 44", "aria192-keywrapWithPad");
        OidNameMapper.insertMap("1 2 410 200046 1 1 45", "aria256-keywrapWithPad");
        OidNameMapper.insertMap("1 2 643 2 2 3", "gostSignature");
        OidNameMapper.insertMap("1 2 643 2 2 4", "gost94Signature");
        OidNameMapper.insertMap("1 2 643 2 2 19", "gostPublicKey");
        OidNameMapper.insertMap("1 2 643 2 2 20", "gost94PublicKey");
        OidNameMapper.insertMap("1 2 643 2 2 21", "gostCipher");
        OidNameMapper.insertMap("1 2 643 2 2 31 0", "testCipherParams");
        OidNameMapper.insertMap("1 2 643 2 2 31 1", "cryptoProCipherA");
        OidNameMapper.insertMap("1 2 643 2 2 31 2", "cryptoProCipherB");
        OidNameMapper.insertMap("1 2 643 2 2 31 3", "cryptoProCipherC");
        OidNameMapper.insertMap("1 2 643 2 2 31 4", "cryptoProCipherD");
        OidNameMapper.insertMap("1 2 643 2 2 31 5", "oscar11Cipher");
        OidNameMapper.insertMap("1 2 643 2 2 31 6", "oscar10Cipher");
        OidNameMapper.insertMap("1 2 643 2 2 31 7", "ric1Cipher");
        OidNameMapper.insertMap("1 2 643 2 2 9", "gostDigest");
        OidNameMapper.insertMap("1 2 643 2 2 30 0", "testDigestParams");
        OidNameMapper.insertMap("1 2 643 2 2 30 1", "cryptoProDigestA");
        OidNameMapper.insertMap("1 2 643 2 2 35 0", "testSignParams");
        OidNameMapper.insertMap("1 2 643 2 2 35 1", "cryptoProSignA");
        OidNameMapper.insertMap("1 2 643 2 2 35 2", "cryptoProSignB");
        OidNameMapper.insertMap("1 2 643 2 2 35 3", "cryptoProSignC");
        OidNameMapper.insertMap("1 2 643 2 2 36 0", "cryptoProSignXA");
        OidNameMapper.insertMap("1 2 643 2 2 36 1", "cryptoProSignXB");
        OidNameMapper.insertMap("1 2 643 2 2 14 0", "nullMeshing");
        OidNameMapper.insertMap("1 2 643 2 2 14 1", "cryptoProMeshing");
        OidNameMapper.insertMap("1 2 643 2 2 10", "hmacGost");
        OidNameMapper.insertMap("1 2 643 2 2 13 0", "gostWrap");
        OidNameMapper.insertMap("1 2 643 2 2 13 1", "cryptoProWrap");
        OidNameMapper.insertMap("1 2 643 2 2 96", "cryptoProECDHWrap");
        OidNameMapper.insertMap("1 2 752 34 1", "seis-cp");
        OidNameMapper.insertMap("1 2 752 34 1 1", "SEIS high-assurance policyIdentifier");
        OidNameMapper.insertMap("1 2 752 34 1 2", "SEIS GAK policyIdentifier");
        OidNameMapper.insertMap("1 2 752 34 2", "SEIS pe");
        OidNameMapper.insertMap("1 2 752 34 3", "SEIS at");
        OidNameMapper.insertMap("1 2 752 34 3 1", "SEIS at-personalIdentifier");
        OidNameMapper.insertMap("1 2 840 10040 1", "module");
        OidNameMapper.insertMap("1 2 840 10040 1 1", "x9f1-cert-mgmt");
        OidNameMapper.insertMap("1 2 840 10040 2", "holdinstruction");
        OidNameMapper.insertMap("1 2 840 10040 2 1", "holdinstruction-none");
        OidNameMapper.insertMap("1 2 840 10040 2 2", "callissuer");
        OidNameMapper.insertMap("1 2 840 10040 2 3", "reject");
        OidNameMapper.insertMap("1 2 840 10040 2 4", "pickupToken");
        OidNameMapper.insertMap("1 2 840 10040 3", "attribute");
        OidNameMapper.insertMap("1 2 840 10040 3 1", "countersignature");
        OidNameMapper.insertMap("1 2 840 10040 3 2", "attribute-cert");
        OidNameMapper.insertMap("1 2 840 10040 4", "algorithm");
        OidNameMapper.insertMap("1 2 840 10040 4 1", "dsa");
        OidNameMapper.insertMap("1 2 840 10040 4 2", "dsa-match");
        OidNameMapper.insertMap("1 2 840 10040 4 3", "dsaWithSha1");
        OidNameMapper.insertMap("1 2 840 10045 1", "fieldType");
        OidNameMapper.insertMap("1 2 840 10045 1 1", "prime-field");
        OidNameMapper.insertMap("1 2 840 10045 1 2", "characteristic-two-field");
        OidNameMapper.insertMap("1 2 840 10045 1 2 3", "characteristic-two-basis");
        OidNameMapper.insertMap("1 2 840 10045 1 2 3 1", "onBasis");
        OidNameMapper.insertMap("1 2 840 10045 1 2 3 2", "tpBasis");
        OidNameMapper.insertMap("1 2 840 10045 1 2 3 3", "ppBasis");
        OidNameMapper.insertMap("1 2 840 10045 2", "publicKeyType");
        OidNameMapper.insertMap("1 2 840 10045 2 1", "ecPublicKey");
        OidNameMapper.insertMap("1 2 840 10045 3 0 1", "c2pnb163v1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 2", "c2pnb163v2");
        OidNameMapper.insertMap("1 2 840 10045 3 0 3", "c2pnb163v3");
        OidNameMapper.insertMap("1 2 840 10045 3 0 5", "c2tnb191v1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 6", "c2tnb191v2");
        OidNameMapper.insertMap("1 2 840 10045 3 0 7", "c2tnb191v3");
        OidNameMapper.insertMap("1 2 840 10045 3 0 10", "c2pnb208w1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 11", "c2tnb239v1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 12", "c2tnb239v2");
        OidNameMapper.insertMap("1 2 840 10045 3 0 13", "c2tnb239v3");
        OidNameMapper.insertMap("1 2 840 10045 3 0 16", "c2pnb272w1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 18", "c2tnb359v1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 19", "c2pnb368w1");
        OidNameMapper.insertMap("1 2 840 10045 3 0 20", "c2tnb431r1");
        OidNameMapper.insertMap("1 2 840 10045 3 1 1", "prime192v1");
        OidNameMapper.insertMap("1 2 840 10045 3 1 2", "prime192v2");
        OidNameMapper.insertMap("1 2 840 10045 3 1 3", "prime192v3");
        OidNameMapper.insertMap("1 2 840 10045 3 1 4", "prime239v1");
        OidNameMapper.insertMap("1 2 840 10045 3 1 5", "prime239v2");
        OidNameMapper.insertMap("1 2 840 10045 3 1 6", "prime239v3");
        OidNameMapper.insertMap("1 2 840 10045 3 1 7", "prime256v1");
        OidNameMapper.insertMap("1 2 840 10045 4 1", "ecdsaWithSHA1");
        OidNameMapper.insertMap("1 2 840 10045 4 2", "ecdsaWithRecommended");
        OidNameMapper.insertMap("1 2 840 10045 4 3", "ecdsaWithSpecified");
        OidNameMapper.insertMap("1 2 840 10045 4 3 1", "ecdsaWithSHA224");
        OidNameMapper.insertMap("1 2 840 10045 4 3 2", "ecdsaWithSHA256");
        OidNameMapper.insertMap("1 2 840 10045 4 3 3", "ecdsaWithSHA384");
        OidNameMapper.insertMap("1 2 840 10045 4 3 4", "ecdsaWithSHA512");
        OidNameMapper.insertMap("1 2 840 10046 1", "fieldType");
        OidNameMapper.insertMap("1 2 840 10046 1 1", "gf-prime");
        OidNameMapper.insertMap("1 2 840 10046 2", "numberType");
        OidNameMapper.insertMap("1 2 840 10046 2 1", "dhPublicKey");
        OidNameMapper.insertMap("1 2 840 10046 3", "scheme");
        OidNameMapper.insertMap("1 2 840 10046 3 1", "dhStatic");
        OidNameMapper.insertMap("1 2 840 10046 3 2", "dhEphem");
        OidNameMapper.insertMap("1 2 840 10046 3 3", "dhHybrid1");
        OidNameMapper.insertMap("1 2 840 10046 3 4", "dhHybrid2");
        OidNameMapper.insertMap("1 2 840 10046 3 5", "mqv2");
        OidNameMapper.insertMap("1 2 840 10046 3 6", "mqv1");
        OidNameMapper.insertMap("1 2 840 10065 2 2", "?");
        OidNameMapper.insertMap("1 2 840 10065 2 3", "healthcareLicense");
        OidNameMapper.insertMap("1 2 840 10065 2 3 1 1", "license?");
        OidNameMapper.insertMap("1 2 840 10070 ", "iec62351");
        OidNameMapper.insertMap("1 2 840 10070 8", "iec62351_8");
        OidNameMapper.insertMap("1 2 840 10070 8 1", "iecUserRoles");
        OidNameMapper.insertMap("1 2 840 113533 7", "nsn");
        OidNameMapper.insertMap("1 2 840 113533 7 65", "nsn-ce");
        OidNameMapper.insertMap("1 2 840 113533 7 65 0", "entrustVersInfo");
        OidNameMapper.insertMap("1 2 840 113533 7 66", "nsn-alg");
        OidNameMapper.insertMap("1 2 840 113533 7 66 3", "cast3CBC");
        OidNameMapper.insertMap("1 2 840 113533 7 66 10", "cast5CBC");
        OidNameMapper.insertMap("1 2 840 113533 7 66 11", "cast5MAC");
        OidNameMapper.insertMap("1 2 840 113533 7 66 12", "pbeWithMD5AndCAST5-CBC");
        OidNameMapper.insertMap("1 2 840 113533 7 66 13", "passwordBasedMac");
        OidNameMapper.insertMap("1 2 840 113533 7 67", "nsn-oc");
        OidNameMapper.insertMap("1 2 840 113533 7 67 0", "entrustUser");
        OidNameMapper.insertMap("1 2 840 113533 7 68", "nsn-at");
        OidNameMapper.insertMap("1 2 840 113533 7 68 0", "entrustCAInfo");
        OidNameMapper.insertMap("1 2 840 113533 7 68 10", "attributeCertificate");
        OidNameMapper.insertMap("1 2 840 113549 1 1", "pkcs-1");
        OidNameMapper.insertMap("1 2 840 113549 1 1 1", "rsaEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 2", "md2WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 3", "md4WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 4", "md5WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 5", "sha1WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 7", "rsaOAEP");
        OidNameMapper.insertMap("1 2 840 113549 1 1 8", "pkcs1-MGF");
        OidNameMapper.insertMap("1 2 840 113549 1 1 9", "rsaOAEP-pSpecified");
        OidNameMapper.insertMap("1 2 840 113549 1 1 10", "rsaPSS");
        OidNameMapper.insertMap("1 2 840 113549 1 1 11", "sha256WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 12", "sha384WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 13", "sha512WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 14", "sha224WithRSAEncryption");
        OidNameMapper.insertMap("1 2 840 113549 1 1 6", "rsaOAEPEncryptionSET");
        OidNameMapper.insertMap("1 2 840 113549 1 2", "bsafeRsaEncr");
        OidNameMapper.insertMap("1 2 840 113549 1 3", "pkcs-3");
        OidNameMapper.insertMap("1 2 840 113549 1 3 1", "dhKeyAgreement");
        OidNameMapper.insertMap("1 2 840 113549 1 5", "pkcs-5");
        OidNameMapper.insertMap("1 2 840 113549 1 5 1", "pbeWithMD2AndDES-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 5 3", "pbeWithMD5AndDES-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 5 4", "pbeWithMD2AndRC2-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 5 6", "pbeWithMD5AndRC2-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 5 9", "pbeWithMD5AndXOR");
        OidNameMapper.insertMap("1 2 840 113549 1 5 10", "pbeWithSHAAndDES-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 5 12", "pkcs5PBKDF2");
        OidNameMapper.insertMap("1 2 840 113549 1 5 13", "pkcs5PBES2");
        OidNameMapper.insertMap("1 2 840 113549 1 5 14", "pkcs5PBMAC1");
        OidNameMapper.insertMap("1 2 840 113549 1 7", "pkcs-7");
        OidNameMapper.insertMap("1 2 840 113549 1 7 1", "data");
        OidNameMapper.insertMap("1 2 840 113549 1 7 2", "signedData");
        OidNameMapper.insertMap("1 2 840 113549 1 7 3", "envelopedData");
        OidNameMapper.insertMap("1 2 840 113549 1 7 4", "signedAndEnvelopedData");
        OidNameMapper.insertMap("1 2 840 113549 1 7 5", "digestedData");
        OidNameMapper.insertMap("1 2 840 113549 1 7 6", "encryptedData");
        OidNameMapper.insertMap("1 2 840 113549 1 7 7", "dataWithAttributes");
        OidNameMapper.insertMap("1 2 840 113549 1 7 8", "encryptedPrivateKeyInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9", "pkcs-9");
        OidNameMapper.insertMap("1 2 840 113549 1 9 1", "emailAddress");
        OidNameMapper.insertMap("1 2 840 113549 1 9 2", "unstructuredName");
        OidNameMapper.insertMap("1 2 840 113549 1 9 3", "contentType");
        OidNameMapper.insertMap("1 2 840 113549 1 9 4", "messageDigest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 5", "signingTime");
        OidNameMapper.insertMap("1 2 840 113549 1 9 6", "countersignature");
        OidNameMapper.insertMap("1 2 840 113549 1 9 7", "challengePassword");
        OidNameMapper.insertMap("1 2 840 113549 1 9 8", "unstructuredAddress");
        OidNameMapper.insertMap("1 2 840 113549 1 9 9", "extendedCertificateAttributes");
        OidNameMapper.insertMap("1 2 840 113549 1 9 10", "issuerAndSerialNumber");
        OidNameMapper.insertMap("1 2 840 113549 1 9 11", "passwordCheck");
        OidNameMapper.insertMap("1 2 840 113549 1 9 12", "publicKey");
        OidNameMapper.insertMap("1 2 840 113549 1 9 13", "signingDescription");
        OidNameMapper.insertMap("1 2 840 113549 1 9 14", "extensionRequest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15", "sMIMECapabilities");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15 1", "preferSignedData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15 2", "canNotDecryptAny");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15 3", "receiptRequest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15 4", "receipt");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15 5", "contentHints");
        OidNameMapper.insertMap("1 2 840 113549 1 9 15 6", "mlExpansionHistory");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16", "id-sMIME");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0", "id-mod");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 1", "id-mod-cms");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 2", "id-mod-ess");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 3", "id-mod-oid");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 4", "id-mod-msg-v3");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 5", "id-mod-ets-eSignature-88");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 6", "id-mod-ets-eSignature-97");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 7", "id-mod-ets-eSigPolicy-88");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 0 8", "id-mod-ets-eSigPolicy-88");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1", "contentType");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 1", "receipt");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 2", "authData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 3", "publishCert");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 4", "tSTInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 5", "tDTInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 6", "contentInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 7", "dVCSRequestData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 8", "dVCSResponseData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 9", "compressedData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 10", "scvpCertValRequest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 11", "scvpCertValResponse");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 12", "scvpValPolRequest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 13", "scvpValPolResponse");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 14", "attrCertEncAttrs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 15", "tSReq");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 16", "firmwarePackage");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 17", "firmwareLoadReceipt");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 18", "firmwareLoadError");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 19", "contentCollection");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 20", "contentWithAttrs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 21", "encKeyWithID");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 22", "encPEPSI");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 23", "authEnvelopedData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 24", "routeOriginAttest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 25", "symmetricKeyPackage");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 26", "rpkiManifest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 27", "asciiTextWithCRLF");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 28", "xml");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 29", "pdf");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 30", "postscript");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 31", "timestampedData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 32", "asAdjacencyAttest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 33", "rpkiTrustAnchor");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 1 34", "trustAnchorList");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2", "authenticatedAttributes");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 1", "receiptRequest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 2", "securityLabel");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 3", "mlExpandHistory");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 4", "contentHint");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 5", "msgSigDigest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 6", "encapContentType");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 7", "contentIdentifier");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 8", "macValue");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 9", "equivalentLabels");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 10", "contentReference");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 11", "encrypKeyPref");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 12", "signingCertificate");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 13", "smimeEncryptCerts");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 14", "timeStampToken");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 15", "sigPolicyId");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 16", "commitmentType");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 17", "signerLocation");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 18", "signerAttr");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 19", "otherSigCert");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 20", "contentTimestamp");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 21", "certificateRefs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 22", "revocationRefs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 23", "certValues");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 24", "revocationValues");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 25", "escTimeStamp");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 26", "certCRLTimestamp");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 27", "archiveTimeStamp");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 28", "signatureType");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 29", "dvcsDvc");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 30", "cekReference");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 31", "maxCEKDecrypts");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 32", "kekDerivationAlg");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 33", "intendedRecipients");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 34", "cmcUnsignedData");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 35", "fwPackageID");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 36", "fwTargetHardwareIDs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 37", "fwDecryptKeyID");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 38", "fwImplCryptAlgs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 39", "fwWrappedFirmwareKey");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 40", "fwCommunityIdentifiers");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 41", "fwPkgMessageDigest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 42", "fwPackageInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 43", "fwImplCompressAlgs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 44", "etsAttrCertificateRefs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 45", "etsAttrRevocationRefs");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 46", "binarySigningTime");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 47", "signingCertificateV2");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 48", "etsArchiveTimeStampV2");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 49", "erInternal");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 50", "erExternal");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 2 51", "multipleSignatures");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 1", "esDHwith3DES");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 2", "esDHwithRC2");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 3", "3desWrap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 4", "rc2Wrap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 5", "esDH");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 6", "cms3DESwrap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 7", "cmsRC2wrap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 8", "zlib");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 9", "pwriKEK");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 10", "ssDH");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 11", "hmacWith3DESwrap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 12", "hmacWithAESwrap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 13", "md5XorExperiment");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 14", "rsaKEM");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 15", "authEnc128");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 3 16", "authEnc256");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 4 1", "certDist-ldap");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 5 1", "sigPolicyQualifier-spuri x");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 5 2", "sigPolicyQualifier-spUserNotice");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 6 1", "proofOfOrigin");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 6 2", "proofOfReceipt");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 6 3", "proofOfDelivery");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 6 4", "proofOfSender");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 6 5", "proofOfApproval");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 6 6", "proofOfCreation");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 1", "glUseKEK");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 2", "glDelete");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 3", "glAddMember");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 4", "glDeleteMember");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 5", "glRekey");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 6", "glAddOwner");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 7", "glRemoveOwner");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 8", "glkCompromise");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 9", "glkRefresh");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 10", "glFailInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 11", "glaQueryRequest");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 12", "glaQueryResponse");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 13", "glProvideCert");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 14", "glUpdateCert");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 8 15", "glKey");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 9", "signatureTypeIdentifier");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 9 1", "originatorSig");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 9 2", "domainSig");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 9 3", "additionalAttributesSig");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 9 4", "reviewSig");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 11", "capabilities");
        OidNameMapper.insertMap("1 2 840 113549 1 9 16 11 1", "preferBinaryInside");
        OidNameMapper.insertMap("1 2 840 113549 1 9 20", "friendlyName (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 21", "localKeyID (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 22", "certTypes (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 22 1", "x509Certificate (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 22 2", "sdsiCertificate (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 23", "crlTypes (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 23 1", "x509Crl (for PKCS #12)");
        OidNameMapper.insertMap("1 2 840 113549 1 9 24", "pkcs9objectClass");
        OidNameMapper.insertMap("1 2 840 113549 1 9 25", "pkcs9attributes");
        OidNameMapper.insertMap("1 2 840 113549 1 9 25 1", "pkcs15Token");
        OidNameMapper.insertMap("1 2 840 113549 1 9 25 2", "encryptedPrivateKeyInfo");
        OidNameMapper.insertMap("1 2 840 113549 1 9 25 3", "randomNonce");
        OidNameMapper.insertMap("1 2 840 113549 1 9 25 4", "sequenceNumber");
        OidNameMapper.insertMap("1 2 840 113549 1 9 25 5", "pkcs7PDU");
        OidNameMapper.insertMap("1 2 840 113549 1 9 26", "pkcs9syntax");
        OidNameMapper.insertMap("1 2 840 113549 1 9 27", "pkcs9matchingRules");
        OidNameMapper.insertMap("1 2 840 113549 1 12", "pkcs-12");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1", "pkcs-12-PbeIds");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1 1", "pbeWithSHAAnd128BitRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1 2", "pbeWithSHAAnd40BitRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1 3", "pbeWithSHAAnd3-KeyTripleDES-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1 4", "pbeWithSHAAnd2-KeyTripleDES-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1 5", "pbeWithSHAAnd128BitRC2-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 1 6", "pbeWithSHAAnd40BitRC2-CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 2", "pkcs-12-ESPVKID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 2 1", "pkcs-12-PKCS8KeyShrouding");
        OidNameMapper.insertMap("1 2 840 113549 1 12 3", "pkcs-12-BagIds");
        OidNameMapper.insertMap("1 2 840 113549 1 12 3 1", "pkcs-12-keyBagId");
        OidNameMapper.insertMap("1 2 840 113549 1 12 3 2", "pkcs-12-certAndCRLBagId");
        OidNameMapper.insertMap("1 2 840 113549 1 12 3 3", "pkcs-12-secretBagId");
        OidNameMapper.insertMap("1 2 840 113549 1 12 3 4", "pkcs-12-safeContentsId");
        OidNameMapper.insertMap("1 2 840 113549 1 12 3 5", "pkcs-12-pkcs-8ShroudedKeyBagId");
        OidNameMapper.insertMap("1 2 840 113549 1 12 4", "pkcs-12-CertBagID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 4 1", "pkcs-12-X509CertCRLBagID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 4 2", "pkcs-12-SDSICertBagID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5", "pkcs-12-OID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1", "pkcs-12-PBEID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 1", "pkcs-12-PBEWithSha1And128BitRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 2", "pkcs-12-PBEWithSha1And40BitRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 3", "pkcs-12-PBEWithSha1AndTripleDESCBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 4", "pkcs-12-PBEWithSha1And128BitRC2CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 5", "pkcs-12-PBEWithSha1And40BitRC2CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 6", "pkcs-12-PBEWithSha1AndRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 1 7", "pkcs-12-PBEWithSha1AndRC2CBC");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 2", "pkcs-12-EnvelopingID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 2 1", "pkcs-12-RSAEncryptionWith128BitRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 2 2", "pkcs-12-RSAEncryptionWith40BitRC4");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 2 3", "pkcs-12-RSAEncryptionWithTripleDES");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 3", "pkcs-12-SignatureID");
        OidNameMapper.insertMap("1 2 840 113549 1 12 5 3 1", "pkcs-12-RSASignatureWithSHA1Digest");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10", "pkcs-12Version1");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1", "pkcs-12BadIds");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1 1", "pkcs-12-keyBag");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1 2", "pkcs-12-pkcs-8ShroudedKeyBag");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1 3", "pkcs-12-certBag");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1 4", "pkcs-12-crlBag");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1 5", "pkcs-12-secretBag");
        OidNameMapper.insertMap("1 2 840 113549 1 12 10 1 6", "pkcs-12-safeContentsBag");
        OidNameMapper.insertMap("1 2 840 113549 1 15 1", "pkcs15modules");
        OidNameMapper.insertMap("1 2 840 113549 1 15 2", "pkcs15attributes");
        OidNameMapper.insertMap("1 2 840 113549 1 15 3", "pkcs15contentType");
        OidNameMapper.insertMap("1 2 840 113549 1 15 3 1", "pkcs15content");
        OidNameMapper.insertMap("1 2 840 113549 2", "digestAlgorithm");
        OidNameMapper.insertMap("1 2 840 113549 2 2", "md2");
        OidNameMapper.insertMap("1 2 840 113549 2 4", "md4");
        OidNameMapper.insertMap("1 2 840 113549 2 5", "md5");
        OidNameMapper.insertMap("1 2 840 113549 2 7", "hmacWithSHA1");
        OidNameMapper.insertMap("1 2 840 113549 2 8", "hmacWithSHA224");
        OidNameMapper.insertMap("1 2 840 113549 2 9", "hmacWithSHA256");
        OidNameMapper.insertMap("1 2 840 113549 2 10", "hmacWithSHA384");
        OidNameMapper.insertMap("1 2 840 113549 2 11", "hmacWithSHA512");
        OidNameMapper.insertMap("1 2 840 113549 3", "encryptionAlgorithm");
        OidNameMapper.insertMap("1 2 840 113549 3 2", "rc2CBC");
        OidNameMapper.insertMap("1 2 840 113549 3 3", "rc2ECB");
        OidNameMapper.insertMap("1 2 840 113549 3 4", "rc4");
        OidNameMapper.insertMap("1 2 840 113549 3 5", "rc4WithMAC");
        OidNameMapper.insertMap("1 2 840 113549 3 6", "desx-CBC");
        OidNameMapper.insertMap("1 2 840 113549 3 7", "des-EDE3-CBC");
        OidNameMapper.insertMap("1 2 840 113549 3 8", "rc5CBC");
        OidNameMapper.insertMap("1 2 840 113549 3 9", "rc5-CBCPad");
        OidNameMapper.insertMap("1 2 840 113549 3 10", "desCDMF");
        OidNameMapper.insertMap("1 2 840 114021 1 6 1", "Identrus unknown policyIdentifier");
        OidNameMapper.insertMap("1 2 840 114021 4 1", "identrusOCSP");
        OidNameMapper.insertMap("1 2 840 113556 1 2 241", "deliveryMechanism");
        OidNameMapper.insertMap("1 2 840 113556 1 2 281", "ntSecurityDescriptor");
        OidNameMapper.insertMap("1 2 840 113556 1 3 0", "site-Addressing");
        OidNameMapper.insertMap("1 2 840 113556 1 3 13", "classSchema");
        OidNameMapper.insertMap("1 2 840 113556 1 3 14", "attributeSchema");
        OidNameMapper.insertMap("1 2 840 113556 1 3 17", "mailbox-Agent");
        OidNameMapper.insertMap("1 2 840 113556 1 3 22", "mailbox");
        OidNameMapper.insertMap("1 2 840 113556 1 3 23", "container");
        OidNameMapper.insertMap("1 2 840 113556 1 3 46", "mailRecipient");
        OidNameMapper.insertMap("1 2 840 113556 1 4 145", "revision");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1327", "pKIDefaultKeySpec");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1328", "pKIKeyUsage");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1329", "pKIMaxIssuingDepth");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1330", "pKICriticalExtensions");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1331", "pKIExpirationPeriod");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1332", "pKIOverlapPeriod");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1333", "pKIExtendedKeyUsage");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1334", "pKIDefaultCSPs");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1335", "pKIEnrollmentAccess");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1429", "msPKI-RA-Signature");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1430", "msPKI-Enrollment-Flag");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1431", "msPKI-Private-Key-Flag");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1432", "msPKI-Certificate-Name-Flag");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1433", "msPKI-Minimal-Key-Size");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1434", "msPKI-Template-Schema-Version");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1435", "msPKI-Template-Minor-Revision");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1436", "msPKI-Cert-Template-OID");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1437", "msPKI-Supersede-Templates");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1438", "msPKI-RA-Policies");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1439", "msPKI-Certificate-Policy");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1674", "msPKI-Certificate-Application-Policy");
        OidNameMapper.insertMap("1 2 840 113556 1 4 1675", "msPKI-RA-Application-Policies");
        OidNameMapper.insertMap("1 2 840 113556 4 3", "microsoftExcel");
        OidNameMapper.insertMap("1 2 840 113556 4 4", "titledWithOID");
        OidNameMapper.insertMap("1 2 840 113556 4 5", "microsoftPowerPoint");
        OidNameMapper.insertMap("1 2 840 113583 1", "adobeAcrobat");
        OidNameMapper.insertMap("1 2 840 113583 1 1", "acrobatSecurity");
        OidNameMapper.insertMap("1 2 840 113583 1 1 1", "pdfPassword");
        OidNameMapper.insertMap("1 2 840 113583 1 1 2", "pdfDefaultSigningCredential");
        OidNameMapper.insertMap("1 2 840 113583 1 1 3", "pdfDefaultEncryptionCredential");
        OidNameMapper.insertMap("1 2 840 113583 1 1 4", "pdfPasswordTimeout");
        OidNameMapper.insertMap("1 2 840 113583 1 1 5", "pdfAuthenticDocumentsTrust");
        OidNameMapper.insertMap("1 2 840 113583 1 1 6", "pdfDynamicContentTrust");
        OidNameMapper.insertMap("1 2 840 113583 1 1 7", "pdfUbiquityTrust");
        OidNameMapper.insertMap("1 2 840 113583 1 1 8", "pdfRevocationInfoArchival");
        OidNameMapper.insertMap("1 2 840 113583 1 1 9", "pdfX509Extension");
        OidNameMapper.insertMap("1 2 840 113583 1 1 9 1", "pdfTimeStamp");
        OidNameMapper.insertMap("1 2 840 113583 1 1 9 2", "pdfArchiveRevInfo");
        OidNameMapper.insertMap("1 2 840 113583 1 1 10", "pdfPPLKLiteCredential");
        OidNameMapper.insertMap("1 2 840 113583 1 2 ", "acrobatCPS");
        OidNameMapper.insertMap("1 2 840 113583 1 2 1", "pdfAuthenticDocumentsCPS");
        OidNameMapper.insertMap("1 2 840 113583 1 2 2", "pdfTestCPS");
        OidNameMapper.insertMap("1 2 840 113583 1 2 3", "pdfUbiquityCPS");
        OidNameMapper.insertMap("1 2 840 113583 1 2 4", "pdfAdhocCPS");
        OidNameMapper.insertMap("1 2 840 113583 1 7", "acrobatUbiquity");
        OidNameMapper.insertMap("1 2 840 113583 1 7 1", "pdfUbiquitySubRights");
        OidNameMapper.insertMap("1 2 840 113583 1 9", "acrobatExtension");
        OidNameMapper.insertMap("1 2 840 113628 114 1 7", "adobePKCS7");
        OidNameMapper.insertMap("1 2 840 113635 100", "appleDataSecurity");
        OidNameMapper.insertMap("1 2 840 113635 100 1", "appleTrustPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 1", "appleISignTP");
        OidNameMapper.insertMap("1 2 840 113635 100 1 2", "appleX509Basic");
        OidNameMapper.insertMap("1 2 840 113635 100 1 3", "appleSSLPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 4", "appleLocalCertGenPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 5", "appleCSRGenPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 6", "appleCRLPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 7", "appleOCSPPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 8", "appleSMIMEPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 9", "appleEAPPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 10", "appleSWUpdateSigningPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 11", "appleIPSecPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 12", "appleIChatPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 13", "appleResourceSignPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 14", "applePKINITClientPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 15", "applePKINITServerPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 16", "appleCodeSigningPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 1 17", "applePackageSigningPolicy");
        OidNameMapper.insertMap("1 2 840 113635 100 2", "appleSecurityAlgorithm");
        OidNameMapper.insertMap("1 2 840 113635 100 2 1", "appleFEE");
        OidNameMapper.insertMap("1 2 840 113635 100 2 2", "appleASC");
        OidNameMapper.insertMap("1 2 840 113635 100 2 3", "appleFEE_MD5");
        OidNameMapper.insertMap("1 2 840 113635 100 2 4", "appleFEE_SHA1");
        OidNameMapper.insertMap("1 2 840 113635 100 2 5", "appleFEED");
        OidNameMapper.insertMap("1 2 840 113635 100 2 6", "appleFEEDEXP");
        OidNameMapper.insertMap("1 2 840 113635 100 2 7", "appleECDSA");
        OidNameMapper.insertMap("1 2 840 113635 100 3", "appleDotMacCertificate");
        OidNameMapper.insertMap("1 2 840 113635 100 3 1", "appleDotMacCertificateRequest");
        OidNameMapper.insertMap("1 2 840 113635 100 3 2", "appleDotMacCertificateExtension");
        OidNameMapper.insertMap("1 2 840 113635 100 3 3", "appleDotMacCertificateRequestValues");
        OidNameMapper.insertMap("1 2 840 113635 100 4", "appleExtendedKeyUsage");
        OidNameMapper.insertMap("1 2 840 113635 100 4 1", "appleCodeSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 4 1 1", "appleCodeSigningDevelopment");
        OidNameMapper.insertMap("1 2 840 113635 100 4 1 2", "appleSoftwareUpdateSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 4 1 3", "appleCodeSigningThirdParty");
        OidNameMapper.insertMap("1 2 840 113635 100 4 1 4", "appleResourceSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 4 2", "appleIChatSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 4 3", "appleIChatEncryption");
        OidNameMapper.insertMap("1 2 840 113635 100 4 4", "appleSystemIdentity");
        OidNameMapper.insertMap("1 2 840 113635 100 4 5", "appleCryptoEnv");
        OidNameMapper.insertMap("1 2 840 113635 100 4 5 1", "appleCryptoProductionEnv");
        OidNameMapper.insertMap("1 2 840 113635 100 4 5 2", "appleCryptoMaintenanceEnv");
        OidNameMapper.insertMap("1 2 840 113635 100 4 5 3", "appleCryptoTestEnv");
        OidNameMapper.insertMap("1 2 840 113635 100 4 5 4", "appleCryptoDevelopmentEnv");
        OidNameMapper.insertMap("1 2 840 113635 100 4 6", "appleCryptoQoS");
        OidNameMapper.insertMap("1 2 840 113635 100 4 6 1", "appleCryptoTier0QoS");
        OidNameMapper.insertMap("1 2 840 113635 100 4 6 2", "appleCryptoTier1QoS");
        OidNameMapper.insertMap("1 2 840 113635 100 4 6 3", "appleCryptoTier2QoS");
        OidNameMapper.insertMap("1 2 840 113635 100 4 6 4", "appleCryptoTier3QoS");
        OidNameMapper.insertMap("1 2 840 113635 100 5", "appleCertificatePolicies");
        OidNameMapper.insertMap("1 2 840 113635 100 5 1", "appleCertificatePolicyID");
        OidNameMapper.insertMap("1 2 840 113635 100 5 2", "appleDotMacCertificatePolicyID");
        OidNameMapper.insertMap("1 2 840 113635 100 5 3", "appleADCCertificatePolicyID");
        OidNameMapper.insertMap("1 2 840 113635 100 6", "appleCertificateExtensions");
        OidNameMapper.insertMap("1 2 840 113635 100 6 1", "appleCertificateExtensionCodeSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 6 1 1", "appleCertificateExtensionAppleSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 6 1 2", "appleCertificateExtensionADCDeveloperSigning");
        OidNameMapper.insertMap("1 2 840 113635 100 6 1 3", "appleCertificateExtensionADCAppleSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 4", "spcIndirectDataContext");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 10", "spcAgencyInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 11", "spcStatementType");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 12", "spcSpOpusInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 14", "certReqExtensions");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 15", "spcPEImageData");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 18", "spcRawFileData");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 19", "spcStructuredStorageData");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 20", "spcJavaClassData (type 1)");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 21", "individualCodeSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 22", "commercialCodeSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 25", "spcLink (type 2)");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 26", "spcMinimalCriteriaInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 27", "spcFinancialCriteriaInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 28", "spcLink (type 3)");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 29", "spcHashInfoObjID");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 1 30", "spcSipInfoObjID");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 2", "ctl");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 2 1", "ctlTrustedCodesigningCAList");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 2 2", "ctlTrustedClientAuthCAList");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 2 2 3", "ctlTrustedServerAuthCAList");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 3 2 1", "timestampRequest");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 1", "certTrustList");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 1 1", "sortedCtl");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 2", "nextUpdateLocation");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 1", "certTrustListSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 2", "timeStampSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 3", "serverGatedCrypto");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 3 1", "serialized");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 4", "encryptedFileSystem");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 5", "whqlCrypto");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 6", "nt5Crypto");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 7", "oemWHQLCrypto");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 8", "embeddedNTCrypto");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 9", "rootListSigner");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 10", "qualifiedSubordination");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 11", "keyRecovery");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 12", "documentSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 13", "lifetimeSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 14", "mobileDeviceSoftware");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 15", "smartDisplay");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 16", "cspSignature");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 3 4 1", "efsRecovery");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 4 1", "yesnoTrustAttr");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 5 1", "drm");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 5 2", "drmIndividualization");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 6 1", "licenses");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 6 2", "licenseServer");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 7 1", "keyidRdn");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 8 1", "removeCertificate");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 9 1", "crossCertDistPoints");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 10 1", "cmcAddAttributes");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 11", "certPropIdPrefix");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 11 4", "certMd5HashPropId");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 11 20", "certKeyIdentifierPropId");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 11 28", "certIssuerSerialNumberMd5HashPropId");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 11 29", "certSubjectNameMd5HashPropId");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 10 12 1", "anyApplicationPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 12", "catalog");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 12 1 1", "catalogList");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 12 1 2", "catalogListMember");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 12 2 1", "catalogNameValueObjID");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 12 2 2", "catalogMemberInfoObjID");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 13 1", "renewalCertificate");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 13 2 1", "enrolmentNameValuePair");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 13 2 2", "enrolmentCSP");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 13 2 3", "osVersion");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 16 4", "microsoftRecipientInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 17 1", "pkcs12KeyProviderNameAttr");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 17 2", "localMachineKeyset");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 17 3", "pkcs12ExtendedAttributes");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 20 1", "autoEnrollCtlUsage");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 20 2", "enrollCerttypeExtension");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 20 2 1", "enrollmentAgent");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 20 2 2", "smartcardLogon");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 20 2 3", "universalPrincipalName");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 20 3", "certManifold");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 1", "cAKeyCertIndexPair");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 2", "certSrvPreviousCertHash");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 3", "crlVirtualBase");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 4", "crlNextPublish");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 5", "caExchange");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 6", "keyRecovery");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 7", "certificateTemplate");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 9", "rdnDummySigner");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 10", "applicationCertPolicies");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 11", "applicationPolicyMappings");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 12", "applicationPolicyConstraints");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 13", "archivedKey");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 14", "crlSelfCDP");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 15", "requireCertChainPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 16", "archivedKeyCertHash");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 17", "issuedCertHash");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 19", "dsEmailReplication");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 20", "requestClientInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 21", "encryptedKeyHash");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 21 22", "certsrvCrossCaVersion");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 25 1", "ntdsReplication");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 31 1", "productUpdate");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 47 1 1", "systemHealth");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 47 1 3", "systemHealthLoophole");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 60 1 1", "rootProgramFlags");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 61 1 1", "kernelModeCodeSigning");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 60 2 1 1", "jurisdictionOfIncorporationL");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 60 2 1 2", "jurisdictionOfIncorporationSP");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 60 2 1 3", "jurisdictionOfIncorporationC");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88", "capiCom");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88 1", "capiComVersion");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88 2", "capiComAttribute");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88 2 1", "capiComDocumentName");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88 2 2", "capiComDocumentDescription");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88 3", "capiComEncryptedData");
        OidNameMapper.insertMap("1 3 6 1 4 1 311 88 3 1", "capiComEncryptedContent");
        OidNameMapper.insertMap("1 3 6 1 4 1 188 7 1 1", "ascom");
        OidNameMapper.insertMap("1 3 6 1 4 1 188 7 1 1 1", "ideaECB");
        OidNameMapper.insertMap("1 3 6 1 4 1 188 7 1 1 2", "ideaCBC");
        OidNameMapper.insertMap("1 3 6 1 4 1 188 7 1 1 3", "ideaCFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 188 7 1 1 4", "ideaOFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 2428 10 1 1", "UNINETT policyIdentifier");
        OidNameMapper.insertMap("1 3 6 1 4 1 2712 10", "ICE-TEL policyIdentifier");
        OidNameMapper.insertMap("1 3 6 1 4 1 2786 1 1 1", "ICE-TEL Italian policyIdentifier");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 1 1", "blowfishECB");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 1 2", "blowfishCBC");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 1 3", "blowfishCFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 1 4", "blowfishOFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 2 1", "elgamal");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 2 1 1", "elgamalWithSHA-1");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 1 2 1 2", "elgamalWithRIPEMD-160");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 3 1 1", "cryptlibPresenceCheck");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 3 1 2", "pkiBoot");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 3 1 4", "crlExtReason");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 3 1 5", "keyFeatures");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1", "cryptlibContent");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1 1", "cryptlibConfigData");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1 2", "cryptlibUserIndex");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1 3", "cryptlibUserInfo");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1 4", "rtcsRequest");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1 5", "rtcsResponse");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 4 1 6", "rtcsResponseExt");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 42 11172 1", "mpeg-1");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 54 11940 54", "TSA policy 'Anything that arrives, we sign'");
        OidNameMapper.insertMap("1 3 6 1 4 1 3029 88 89 90 90 89", "xYZZY policyIdentifier");
        OidNameMapper.insertMap("1 3 6 1 4 1 3401 8 1 1", "pgpExtension");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 7", "eciaAscX12Edi");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 7 1", "plainEDImessage");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 7 2", "signedEDImessage");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 7 5", "integrityEDImessage");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 7 65", "iaReceiptMessage");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 7 97", "iaStatusMessage");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 8", "eciaEdifact");
        OidNameMapper.insertMap("1 3 6 1 4 1 3576 9", "eciaNonEdi");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146", "Globalsign");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1", "globalsignPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 10", "globalsignDVPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 20", "globalsignOVPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 30", "globalsignTSAPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 40", "globalsignClientCertPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 50", "globalsignCodeSignPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 60", "globalsignRootSignPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 70", "globalsignTrustedRootPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 80", "globalsignEDIClientPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 81", "globalsignEDIServerPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 90", "globalsignTPMRootPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 95", "globalsignOCSPPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 5309 1", "edelWebPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 5309 1 2", "edelWebCustomerPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 5309 1 2 1", "edelWebClepsydrePolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 5309 1 2 2", "edelWebExperimentalTSAPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 5309 1 2 3", "edelWebOpenEvidenceTSAPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 5472", "timeproof");
        OidNameMapper.insertMap("1 3 6 1 4 1 5472 1", "tss");
        OidNameMapper.insertMap("1 3 6 1 4 1 5472 1 1", "tss80");
        OidNameMapper.insertMap("1 3 6 1 4 1 5472 1 2", "tss380");
        OidNameMapper.insertMap("1 3 6 1 4 1 5472 1 3", "tss400");
        OidNameMapper.insertMap("1 3 6 1 4 1 5770 0 3", "secondaryPractices");
        OidNameMapper.insertMap("1 3 6 1 4 1 5770 0 4", "physicianIdentifiers");
        OidNameMapper.insertMap("1 3 6 1 4 1 6449 1 2 1 3 1", "comodoPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 6449 1 2 2 15", "wotrustPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 6449 1 3 5 2", "comodoCertifiedDeliveryService");
        OidNameMapper.insertMap("1 3 6 1 4 1 6449 2 1 1", "comodoTimestampingPolicy");
        OidNameMapper.insertMap("1 3 6 1 4 1 8301 3 5 1", "validityModelChain");
        OidNameMapper.insertMap("1 3 6 1 4 1 8301 3 5 2", "validityModelShell");
        OidNameMapper.insertMap("1 3 6 1 4 1 8231 1", "rolUnicoNacional");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591", "gnu");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 1", "gnuRadius");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 3", "gnuRadar");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 12", "gnuDigestAlgorithm");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 12 2", "tiger");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13", "gnuEncryptionAlgorithm");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2", "serpent");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 1", "serpent128_ECB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 2", "serpent128_CBC");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 3", "serpent128_OFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 4", "serpent128_CFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 21", "serpent192_ECB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 22", "serpent192_CBC");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 23", "serpent192_OFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 24", "serpent192_CFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 41", "serpent256_ECB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 42", "serpent256_CBC");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 43", "serpent256_OFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 11591 13 2 44", "serpent256_CFB");
        OidNameMapper.insertMap("1 3 6 1 4 1 16334 509 1 1", "Northrop Grumman extKeyUsage?");
        OidNameMapper.insertMap("1 3 6 1 4 1 16334 509 2 1", "ngcClass1");
        OidNameMapper.insertMap("1 3 6 1 4 1 16334 509 2 2", "ngcClass2");
        OidNameMapper.insertMap("1 3 6 1 4 1 16334 509 2 3", "ngcClass3");
        OidNameMapper.insertMap("1 3 6 1 4 1 23629 1 4 2 1 1", "safenetUsageLimit");
        OidNameMapper.insertMap("1 3 6 1 4 1 23629 1 4 2 1 2", "safenetEndDate");
        OidNameMapper.insertMap("1 3 6 1 4 1 23629 1 4 2 1 3", "safenetStartDate");
        OidNameMapper.insertMap("1 3 6 1 4 1 23629 1 4 2 1 4", "safenetAdminCert");
        OidNameMapper.insertMap("1 3 6 1 4 1 23629 1 4 2 2 1", "safenetKeyDigest");
        OidNameMapper.insertMap("1 3 6 1 5 5 7", "pkix");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 0 12", "attributeCert");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1", "privateExtension");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 1", "authorityInfoAccess");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 2", "biometricInfo");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 3", "qcStatements");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 4", "acAuditIdentity");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 5", "acTargeting");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 6", "acAaControls");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 7", "ipAddrBlocks");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 8", "autonomousSysIds");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 9", "routerIdentifier");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 10", "acProxying");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 11", "subjectInfoAccess");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 12", "logoType");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 1 13", "wlanSSID");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 2", "policyQualifierIds");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 2 1", "cps");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 2 2", "unotice");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 2 3", "textNotice");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3", "keyPurpose");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 1", "serverAuth");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 2", "clientAuth");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 3", "codeSigning");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 4", "emailProtection");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 5", "ipsecEndSystem");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 6", "ipsecTunnel");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 7", "ipsecUser");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 8", "timeStamping");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 9", "ocspSigning");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 10", "dvcs");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 11", "sbgpCertAAServerAuth");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 13", "eapOverPPP");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 3 14", "eapOverLAN");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4", "cmpInformationTypes");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 1", "caProtEncCert");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 2", "signKeyPairTypes");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 3", "encKeyPairTypes");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 4", "preferredSymmAlg");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 5", "caKeyUpdateInfo");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 6", "currentCRL");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 7", "unsupportedOIDs");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 10", "keyPairParamReq");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 11", "keyPairParamRep");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 12", "revPassphrase");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 13", "implicitConfirm");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 14", "confirmWaitTime");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 15", "origPKIMessage");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 4 16", "suppLangTags");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5", "crmfRegistration");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1", "regCtrl");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 1", "regToken");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 2", "authenticator");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 3", "pkiPublicationInfo");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 4", "pkiArchiveOptions");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 5", "oldCertID");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 6", "protocolEncrKey");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 7", "altCertTemplate");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 1 8", "wtlsTemplate");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 2", "utf8Pairs");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 2 1", "utf8Pairs");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 5 2 2", "certReq");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 6", "algorithms");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 6 1", "des40");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 6 2", "noSignature");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 6 3", "dh-sig-hmac-sha1");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 6 4", "dh-pop");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 7", "cmcControls");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 8", "otherNames");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 8 1", "personalData");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 8 2", "userGroup");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 8 5", "xmppAddr");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 9", "personalData");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 9 1", "dateOfBirth");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 9 2", "placeOfBirth");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 9 3", "gender");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 9 4", "countryOfCitizenship");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 9 5", "countryOfResidence");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10", "attributeCertificate");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10 1", "authenticationInfo");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10 2", "accessIdentity");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10 3", "chargingIdentity");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10 4", "group");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10 5", "role");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 10 6", "wlanSSID");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 11", "personalData");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 11 1", "pkixQCSyntax-v1");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 14 2", "resourceCertificatePolicy");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 20", "logo");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 20 1", "logoLoyalty");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 20 2", "logoBackground");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1", "ocsp");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 1", "ocspBasic");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 2", "ocspNonce");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 3", "ocspCRL");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 4", "ocspResponse");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 5", "ocspNoCheck");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 6", "ocspArchiveCutoff");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 1 7", "ocspServiceLocator");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 2", "caIssuers");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 3", "timeStamping");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 4", "dvcs");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 5", "caRepository");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 7", "signedObjectRepository");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 10", "rpkiManifest");
        OidNameMapper.insertMap("1 3 6 1 5 5 7 48 11", "signedObject");
        OidNameMapper.insertMap("1 3 6 1 5 5 8 1 1", "hmacMD5");
        OidNameMapper.insertMap("1 3 6 1 5 5 8 1 2", "hmacSHA");
        OidNameMapper.insertMap("1 3 6 1 5 5 8 1 3", "hmacTiger");
        OidNameMapper.insertMap("1 3 6 1 5 5 8 2 2", "iKEIntermediate");
        OidNameMapper.insertMap("1 3 12 2 1011 7 1", "decEncryptionAlgorithm");
        OidNameMapper.insertMap("1 3 12 2 1011 7 1 2", "decDEA");
        OidNameMapper.insertMap("1 3 12 2 1011 7 2", "decHashAlgorithm");
        OidNameMapper.insertMap("1 3 12 2 1011 7 2 1", "decMD2");
        OidNameMapper.insertMap("1 3 12 2 1011 7 2 2", "decMD4");
        OidNameMapper.insertMap("1 3 12 2 1011 7 3", "decSignatureAlgorithm");
        OidNameMapper.insertMap("1 3 12 2 1011 7 3 1", "decMD2withRSA");
        OidNameMapper.insertMap("1 3 12 2 1011 7 3 2", "decMD4withRSA");
        OidNameMapper.insertMap("1 3 12 2 1011 7 3 3", "decDEAMAC");
        OidNameMapper.insertMap("1 3 14 2 26 5", "sha");
        OidNameMapper.insertMap("1 3 14 3 2 1 1", "rsa");
        OidNameMapper.insertMap("1 3 14 3 2 2", "md4WitRSA");
        OidNameMapper.insertMap("1 3 14 3 2 3", "md5WithRSA");
        OidNameMapper.insertMap("1 3 14 3 2 4", "md4WithRSAEncryption");
        OidNameMapper.insertMap("1 3 14 3 2 2 1", "sqmod-N");
        OidNameMapper.insertMap("1 3 14 3 2 3 1", "sqmod-NwithRSA");
        OidNameMapper.insertMap("1 3 14 3 2 6", "desECB");
        OidNameMapper.insertMap("1 3 14 3 2 7", "desCBC");
        OidNameMapper.insertMap("1 3 14 3 2 8", "desOFB");
        OidNameMapper.insertMap("1 3 14 3 2 9", "desCFB");
        OidNameMapper.insertMap("1 3 14 3 2 10", "desMAC");
        OidNameMapper.insertMap("1 3 14 3 2 11", "rsaSignature");
        OidNameMapper.insertMap("1 3 14 3 2 12", "dsa");
        OidNameMapper.insertMap("1 3 14 3 2 13", "dsaWithSHA");
        OidNameMapper.insertMap("1 3 14 3 2 14", "mdc2WithRSASignature");
        OidNameMapper.insertMap("1 3 14 3 2 15", "shaWithRSASignature");
        OidNameMapper.insertMap("1 3 14 3 2 16", "dhWithCommonModulus");
        OidNameMapper.insertMap("1 3 14 3 2 17", "desEDE");
        OidNameMapper.insertMap("1 3 14 3 2 18", "sha");
        OidNameMapper.insertMap("1 3 14 3 2 19", "mdc-2");
        OidNameMapper.insertMap("1 3 14 3 2 20", "dsaCommon");
        OidNameMapper.insertMap("1 3 14 3 2 21", "dsaCommonWithSHA");
        OidNameMapper.insertMap("1 3 14 3 2 22", "rsaKeyTransport");
        OidNameMapper.insertMap("1 3 14 3 2 23", "keyed-hash-seal");
        OidNameMapper.insertMap("1 3 14 3 2 24", "md2WithRSASignature");
        OidNameMapper.insertMap("1 3 14 3 2 25", "md5WithRSASignature");
        OidNameMapper.insertMap("1 3 14 3 2 26", "sha1");
        OidNameMapper.insertMap("1 3 14 3 2 27", "dsaWithSHA1");
        OidNameMapper.insertMap("1 3 14 3 2 28", "dsaWithCommonSHA1");
        OidNameMapper.insertMap("1 3 14 3 2 29", "sha-1WithRSAEncryption");
        OidNameMapper.insertMap("1 3 14 3 3 1", "simple-strong-auth-mechanism");
        OidNameMapper.insertMap("1 3 14 7 2 1 1", "ElGamal");
        OidNameMapper.insertMap("1 3 14 7 2 3 1", "md2WithRSA");
        OidNameMapper.insertMap("1 3 14 7 2 3 2", "md2WithElGamal");
        OidNameMapper.insertMap("1 3 36 1", "document");
        OidNameMapper.insertMap("1 3 36 1 1", "finalVersion");
        OidNameMapper.insertMap("1 3 36 1 2", "draft");
        OidNameMapper.insertMap("1 3 36 2", "sio");
        OidNameMapper.insertMap("1 3 36 2 1", "sedu");
        OidNameMapper.insertMap("1 3 36 3", "algorithm");
        OidNameMapper.insertMap("1 3 36 3 1", "encryptionAlgorithm");
        OidNameMapper.insertMap("1 3 36 3 1 1", "des");
        OidNameMapper.insertMap("1 3 36 3 1 1 1", "desECB_pad");
        OidNameMapper.insertMap("1 3 36 3 1 1 1 1", "desECB_ISOpad");
        OidNameMapper.insertMap("1 3 36 3 1 1 2 1", "desCBC_pad");
        OidNameMapper.insertMap("1 3 36 3 1 1 2 1 1", "desCBC_ISOpad");
        OidNameMapper.insertMap("1 3 36 3 1 3", "des_3");
        OidNameMapper.insertMap("1 3 36 3 1 3 1 1", "des_3ECB_pad");
        OidNameMapper.insertMap("1 3 36 3 1 3 1 1 1", "des_3ECB_ISOpad");
        OidNameMapper.insertMap("1 3 36 3 1 3 2 1", "des_3CBC_pad");
        OidNameMapper.insertMap("1 3 36 3 1 3 2 1 1", "des_3CBC_ISOpad");
        OidNameMapper.insertMap("1 3 36 3 1 2", "idea");
        OidNameMapper.insertMap("1 3 36 3 1 2 1", "ideaECB");
        OidNameMapper.insertMap("1 3 36 3 1 2 1 1", "ideaECB_pad");
        OidNameMapper.insertMap("1 3 36 3 1 2 1 1 1", "ideaECB_ISOpad");
        OidNameMapper.insertMap("1 3 36 3 1 2 2", "ideaCBC");
        OidNameMapper.insertMap("1 3 36 3 1 2 2 1", "ideaCBC_pad");
        OidNameMapper.insertMap("1 3 36 3 1 2 2 1 1", "ideaCBC_ISOpad");
        OidNameMapper.insertMap("1 3 36 3 1 2 3", "ideaOFB");
        OidNameMapper.insertMap("1 3 36 3 1 2 4", "ideaCFB");
        OidNameMapper.insertMap("1 3 36 3 1 4", "rsaEncryption");
        OidNameMapper.insertMap("1 3 36 3 1 4 512 17", "rsaEncryptionWithlmod512expe17");
        OidNameMapper.insertMap("1 3 36 3 1 5", "bsi-1");
        OidNameMapper.insertMap("1 3 36 3 1 5 1", "bsi_1ECB_pad");
        OidNameMapper.insertMap("1 3 36 3 1 5 2", "bsi_1CBC_pad");
        OidNameMapper.insertMap("1 3 36 3 1 5 2 1", "bsi_1CBC_PEMpad");
        OidNameMapper.insertMap("1 3 36 3 2", "hashAlgorithm");
        OidNameMapper.insertMap("1 3 36 3 2 1", "ripemd160");
        OidNameMapper.insertMap("1 3 36 3 2 2", "ripemd128");
        OidNameMapper.insertMap("1 3 36 3 2 3", "ripemd256");
        OidNameMapper.insertMap("1 3 36 3 2 4", "mdc2singleLength");
        OidNameMapper.insertMap("1 3 36 3 2 5", "mdc2doubleLength");
        OidNameMapper.insertMap("1 3 36 3 3", "signatureAlgorithm");
        OidNameMapper.insertMap("1 3 36 3 3 1", "rsaSignature");
        OidNameMapper.insertMap("1 3 36 3 3 1 1", "rsaSignatureWithsha1");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 512 2", "rsaSignatureWithsha1_l512_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 640 2", "rsaSignatureWithsha1_l640_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 768 2", "rsaSignatureWithsha1_l768_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 896 2", "rsaSignatureWithsha1_l896_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 1024 2", "rsaSignatureWithsha1_l1024_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 512 3", "rsaSignatureWithsha1_l512_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 640 3", "rsaSignatureWithsha1_l640_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 768 3", "rsaSignatureWithsha1_l768_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 896 3", "rsaSignatureWithsha1_l896_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 1024 3", "rsaSignatureWithsha1_l1024_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 512 5", "rsaSignatureWithsha1_l512_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 640 5", "rsaSignatureWithsha1_l640_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 768 5", "rsaSignatureWithsha1_l768_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 896 5", "rsaSignatureWithsha1_l896_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 1024 5", "rsaSignatureWithsha1_l1024_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 512 9", "rsaSignatureWithsha1_l512_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 640 9", "rsaSignatureWithsha1_l640_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 768 9", "rsaSignatureWithsha1_l768_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 896 9", "rsaSignatureWithsha1_l896_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 1024 9", "rsaSignatureWithsha1_l1024_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 512 11", "rsaSignatureWithsha1_l512_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 640 11", "rsaSignatureWithsha1_l640_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 768 11", "rsaSignatureWithsha1_l768_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 896 11", "rsaSignatureWithsha1_l896_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 1 1024 11", "rsaSignatureWithsha1_l1024_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 2", "rsaSignatureWithripemd160");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 512 2", "rsaSignatureWithripemd160_l512_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 640 2", "rsaSignatureWithripemd160_l640_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 768 2", "rsaSignatureWithripemd160_l768_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 896 2", "rsaSignatureWithripemd160_l896_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 1024 2", "rsaSignatureWithripemd160_l1024_l2");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 512 3", "rsaSignatureWithripemd160_l512_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 640 3", "rsaSignatureWithripemd160_l640_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 768 3", "rsaSignatureWithripemd160_l768_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 896 3", "rsaSignatureWithripemd160_l896_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 1024 3", "rsaSignatureWithripemd160_l1024_l3");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 512 5", "rsaSignatureWithripemd160_l512_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 640 5", "rsaSignatureWithripemd160_l640_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 768 5", "rsaSignatureWithripemd160_l768_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 896 5", "rsaSignatureWithripemd160_l896_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 1024 5", "rsaSignatureWithripemd160_l1024_l5");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 512 9", "rsaSignatureWithripemd160_l512_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 640 9", "rsaSignatureWithripemd160_l640_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 768 9", "rsaSignatureWithripemd160_l768_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 896 9", "rsaSignatureWithripemd160_l896_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 1024 9", "rsaSignatureWithripemd160_l1024_l9");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 512 11", "rsaSignatureWithripemd160_l512_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 640 11", "rsaSignatureWithripemd160_l640_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 768 11", "rsaSignatureWithripemd160_l768_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 896 11", "rsaSignatureWithripemd160_l896_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 2 1024 11", "rsaSignatureWithripemd160_l1024_l11");
        OidNameMapper.insertMap("1 3 36 3 3 1 3", "rsaSignatureWithrimpemd128");
        OidNameMapper.insertMap("1 3 36 3 3 1 4", "rsaSignatureWithrimpemd256");
        OidNameMapper.insertMap("1 3 36 3 3 2", "ecsieSign");
        OidNameMapper.insertMap("1 3 36 3 3 2 1", "ecsieSignWithsha1");
        OidNameMapper.insertMap("1 3 36 3 3 2 2", "ecsieSignWithripemd160");
        OidNameMapper.insertMap("1 3 36 3 3 2 3", "ecsieSignWithmd2");
        OidNameMapper.insertMap("1 3 36 3 3 2 4", "ecsieSignWithmd5");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 1", "brainpoolP160r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 2", "brainpoolP160t1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 3", "brainpoolP192r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 4", "brainpoolP192t1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 5", "brainpoolP224r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 6", "brainpoolP224t1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 7", "brainpoolP256r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 8", "brainpoolP256t1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 9", "brainpoolP320r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 10", "brainpoolP320t1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 11", "brainpoolP384r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 12", "brainpoolP384t1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 13", "brainpoolP512r1");
        OidNameMapper.insertMap("1 3 36 3 3 2 8 1 1 14", "brainpoolP512t1");
        OidNameMapper.insertMap("1 3 36 3 4", "signatureScheme");
        OidNameMapper.insertMap("1 3 36 3 4 1", "sigS_ISO9796-1");
        OidNameMapper.insertMap("1 3 36 3 4 2", "sigS_ISO9796-2");
        OidNameMapper.insertMap("1 3 36 3 4 2 1", "sigS_ISO9796-2Withred");
        OidNameMapper.insertMap("1 3 36 3 4 2 2", "sigS_ISO9796-2Withrsa");
        OidNameMapper.insertMap("1 3 36 3 4 2 3", "sigS_ISO9796-2Withrnd");
        OidNameMapper.insertMap("1 3 36 4", "attribute");
        OidNameMapper.insertMap("1 3 36 5", "policy");
        OidNameMapper.insertMap("1 3 36 6", "api");
        OidNameMapper.insertMap("1 3 36 6 1", "manufacturer-specific_api");
        OidNameMapper.insertMap("1 3 36 6 1 1", "utimaco-api");
        OidNameMapper.insertMap("1 3 36 6 2", "functionality-specific_api");
        OidNameMapper.insertMap("1 3 36 7", "keymgmnt");
        OidNameMapper.insertMap("1 3 36 7 1", "keyagree");
        OidNameMapper.insertMap("1 3 36 7 1 1", "bsiPKE");
        OidNameMapper.insertMap("1 3 36 7 2", "keytrans");
        OidNameMapper.insertMap("1 3 36 7 2 1", "encISO9796-2Withrsa");
        OidNameMapper.insertMap("1 3 36 8 1 1", "Teletrust SigGConform policyIdentifier");
        OidNameMapper.insertMap("1 3 36 8 2 1", "directoryService");
        OidNameMapper.insertMap("1 3 36 8 3 1", "dateOfCertGen");
        OidNameMapper.insertMap("1 3 36 8 3 2", "procuration");
        OidNameMapper.insertMap("1 3 36 8 3 3", "admission");
        OidNameMapper.insertMap("1 3 36 8 3 4", "monetaryLimit");
        OidNameMapper.insertMap("1 3 36 8 3 5", "declarationOfMajority");
        OidNameMapper.insertMap("1 3 36 8 3 6", "integratedCircuitCardSerialNumber");
        OidNameMapper.insertMap("1 3 36 8 3 7", "pKReference");
        OidNameMapper.insertMap("1 3 36 8 3 8", "restriction");
        OidNameMapper.insertMap("1 3 36 8 3 9", "retrieveIfAllowed");
        OidNameMapper.insertMap("1 3 36 8 3 10", "requestedCertificate");
        OidNameMapper.insertMap("1 3 36 8 3 11", "namingAuthorities");
        OidNameMapper.insertMap("1 3 36 8 3 11 1", "rechtWirtschaftSteuern");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 1", "rechtsanwaeltin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 2", "rechtsanwalt");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 3", "rechtsBeistand");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 4", "steuerBeraterin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 5", "steuerBerater");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 6", "steuerBevollmaechtigte");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 7", "steuerBevollmaechtigter");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 8", "notarin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 9", "notar");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 10", "notarVertreterin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 11", "notarVertreter");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 12", "notariatsVerwalterin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 13", "notariatsVerwalter");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 14", "wirtschaftsPrueferin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 15", "wirtschaftsPruefer");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 16", "vereidigteBuchprueferin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 17", "vereidigterBuchpruefer");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 18", "patentAnwaeltin");
        OidNameMapper.insertMap("1 3 36 8 3 11 1 19", "patentAnwalt");
        OidNameMapper.insertMap("1 3 36 8 3 12", "certInDirSince");
        OidNameMapper.insertMap("1 3 36 8 3 13", "certHash");
        OidNameMapper.insertMap("1 3 36 8 3 14", "nameAtBirth");
        OidNameMapper.insertMap("1 3 36 8 3 15", "additionalInformation");
        OidNameMapper.insertMap("1 3 36 8 4 1", "personalData");
        OidNameMapper.insertMap("1 3 36 8 4 8", "restriction");
        OidNameMapper.insertMap("1 3 36 8 5 1 1 1", "rsaIndicateSHA1");
        OidNameMapper.insertMap("1 3 36 8 5 1 1 2", "rsaIndicateRIPEMD160");
        OidNameMapper.insertMap("1 3 36 8 5 1 1 3", "rsaWithSHA1");
        OidNameMapper.insertMap("1 3 36 8 5 1 1 4", "rsaWithRIPEMD160");
        OidNameMapper.insertMap("1 3 36 8 5 1 2 1", "dsaExtended");
        OidNameMapper.insertMap("1 3 36 8 5 1 2 2", "dsaWithRIPEMD160");
        OidNameMapper.insertMap("1 3 36 8 6 1", "cert");
        OidNameMapper.insertMap("1 3 36 8 6 2", "certRef");
        OidNameMapper.insertMap("1 3 36 8 6 3", "attrCert");
        OidNameMapper.insertMap("1 3 36 8 6 4", "attrRef");
        OidNameMapper.insertMap("1 3 36 8 6 5", "fileName");
        OidNameMapper.insertMap("1 3 36 8 6 6", "storageTime");
        OidNameMapper.insertMap("1 3 36 8 6 7", "fileSize");
        OidNameMapper.insertMap("1 3 36 8 6 8", "location");
        OidNameMapper.insertMap("1 3 36 8 6 9", "sigNumber");
        OidNameMapper.insertMap("1 3 36 8 6 10", "autoGen");
        OidNameMapper.insertMap("1 3 36 8 7 1 1", "ptAdobeILL");
        OidNameMapper.insertMap("1 3 36 8 7 1 2", "ptAmiPro");
        OidNameMapper.insertMap("1 3 36 8 7 1 3", "ptAutoCAD");
        OidNameMapper.insertMap("1 3 36 8 7 1 4", "ptBinary");
        OidNameMapper.insertMap("1 3 36 8 7 1 5", "ptBMP");
        OidNameMapper.insertMap("1 3 36 8 7 1 6", "ptCGM");
        OidNameMapper.insertMap("1 3 36 8 7 1 7", "ptCorelCRT");
        OidNameMapper.insertMap("1 3 36 8 7 1 8", "ptCorelDRW");
        OidNameMapper.insertMap("1 3 36 8 7 1 9", "ptCorelEXC");
        OidNameMapper.insertMap("1 3 36 8 7 1 10", "ptCorelPHT");
        OidNameMapper.insertMap("1 3 36 8 7 1 11", "ptDraw");
        OidNameMapper.insertMap("1 3 36 8 7 1 12", "ptDVI");
        OidNameMapper.insertMap("1 3 36 8 7 1 13", "ptEPS");
        OidNameMapper.insertMap("1 3 36 8 7 1 14", "ptExcel");
        OidNameMapper.insertMap("1 3 36 8 7 1 15", "ptGEM");
        OidNameMapper.insertMap("1 3 36 8 7 1 16", "ptGIF");
        OidNameMapper.insertMap("1 3 36 8 7 1 17", "ptHPGL");
        OidNameMapper.insertMap("1 3 36 8 7 1 18", "ptJPEG");
        OidNameMapper.insertMap("1 3 36 8 7 1 19", "ptKodak");
        OidNameMapper.insertMap("1 3 36 8 7 1 20", "ptLaTeX");
        OidNameMapper.insertMap("1 3 36 8 7 1 21", "ptLotus");
        OidNameMapper.insertMap("1 3 36 8 7 1 22", "ptLotusPIC");
        OidNameMapper.insertMap("1 3 36 8 7 1 23", "ptMacPICT");
        OidNameMapper.insertMap("1 3 36 8 7 1 24", "ptMacWord");
        OidNameMapper.insertMap("1 3 36 8 7 1 25", "ptMSWfD");
        OidNameMapper.insertMap("1 3 36 8 7 1 26", "ptMSWord");
        OidNameMapper.insertMap("1 3 36 8 7 1 27", "ptMSWord2");
        OidNameMapper.insertMap("1 3 36 8 7 1 28", "ptMSWord6");
        OidNameMapper.insertMap("1 3 36 8 7 1 29", "ptMSWord8");
        OidNameMapper.insertMap("1 3 36 8 7 1 30", "ptPDF");
        OidNameMapper.insertMap("1 3 36 8 7 1 31", "ptPIF");
        OidNameMapper.insertMap("1 3 36 8 7 1 32", "ptPostscript");
        OidNameMapper.insertMap("1 3 36 8 7 1 33", "ptRTF");
        OidNameMapper.insertMap("1 3 36 8 7 1 34", "ptSCITEX");
        OidNameMapper.insertMap("1 3 36 8 7 1 35", "ptTAR");
        OidNameMapper.insertMap("1 3 36 8 7 1 36", "ptTarga");
        OidNameMapper.insertMap("1 3 36 8 7 1 37", "ptTeX");
        OidNameMapper.insertMap("1 3 36 8 7 1 38", "ptText");
        OidNameMapper.insertMap("1 3 36 8 7 1 39", "ptTIFF");
        OidNameMapper.insertMap("1 3 36 8 7 1 40", "ptTIFF-FC");
        OidNameMapper.insertMap("1 3 36 8 7 1 41", "ptUID");
        OidNameMapper.insertMap("1 3 36 8 7 1 42", "ptUUEncode");
        OidNameMapper.insertMap("1 3 36 8 7 1 43", "ptWMF");
        OidNameMapper.insertMap("1 3 36 8 7 1 44", "ptWordPerfect");
        OidNameMapper.insertMap("1 3 36 8 7 1 45", "ptWPGrph");
        OidNameMapper.insertMap("1 3 101 1 4", "thawte-ce");
        OidNameMapper.insertMap("1 3 101 1 4 1", "strongExtranet");
        OidNameMapper.insertMap("1 3 132 0 1", "sect163k1");
        OidNameMapper.insertMap("1 3 132 0 2", "sect163r1");
        OidNameMapper.insertMap("1 3 132 0 3", "sect239k1");
        OidNameMapper.insertMap("1 3 132 0 4", "sect113r1");
        OidNameMapper.insertMap("1 3 132 0 5", "sect113r2");
        OidNameMapper.insertMap("1 3 132 0 6", "secp112r1");
        OidNameMapper.insertMap("1 3 132 0 7", "secp112r2");
        OidNameMapper.insertMap("1 3 132 0 8", "secp160r1");
        OidNameMapper.insertMap("1 3 132 0 9", "secp160k1");
        OidNameMapper.insertMap("1 3 132 0 10", "secp256k1");
        OidNameMapper.insertMap("1 3 132 0 15", "sect163r2");
        OidNameMapper.insertMap("1 3 132 0 16", "sect283k1");
        OidNameMapper.insertMap("1 3 132 0 17", "sect283r1");
        OidNameMapper.insertMap("1 3 132 0 22", "sect131r1");
        OidNameMapper.insertMap("1 3 132 0 23", "sect131r2");
        OidNameMapper.insertMap("1 3 132 0 24", "sect193r1");
        OidNameMapper.insertMap("1 3 132 0 25", "sect193r2");
        OidNameMapper.insertMap("1 3 132 0 26", "sect233k1");
        OidNameMapper.insertMap("1 3 132 0 27", "sect233r1");
        OidNameMapper.insertMap("1 3 132 0 28", "secp128r1");
        OidNameMapper.insertMap("1 3 132 0 29", "secp128r2");
        OidNameMapper.insertMap("1 3 132 0 30", "secp160r2");
        OidNameMapper.insertMap("1 3 132 0 31", "secp192k1");
        OidNameMapper.insertMap("1 3 132 0 32", "secp224k1");
        OidNameMapper.insertMap("1 3 132 0 33", "secp224r1");
        OidNameMapper.insertMap("1 3 132 0 34", "secp384r1");
        OidNameMapper.insertMap("1 3 132 0 35", "secp521r1");
        OidNameMapper.insertMap("1 3 132 0 36", "sect409k1");
        OidNameMapper.insertMap("1 3 132 0 37", "sect409r1");
        OidNameMapper.insertMap("1 3 132 0 38", "sect571k1");
        OidNameMapper.insertMap("1 3 132 0 39", "sect571r1");
        OidNameMapper.insertMap("1 3 133 16 840 9 84", "x984");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 0", "x984Module");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 0 1", "x984Biometrics");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 0 2", "x984CMS");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 0 3", "x984Identifiers");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1", "x984Biometric");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 0", "biometricUnknownType");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 1", "biometricBodyOdor");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 2", "biometricDNA");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 3", "biometricEarShape");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 4", "biometricFacialFeatures");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 5", "biometricFingerImage");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 6", "biometricFingerGeometry");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 7", "biometricHandGeometry");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 8", "biometricIrisFeatures");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 9", "biometricKeystrokeDynamics");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 10", "biometricPalm");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 11", "biometricRetina");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 12", "biometricSignature");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 13", "biometricSpeechPattern");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 14", "biometricThermalImage");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 15", "biometricVeinPattern");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 16", "biometricThermalFaceImage");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 17", "biometricThermalHandImage");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 18", "biometricLipMovement");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1 19", "biometricGait");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 1", "x984ProcessingAlgorithm");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 3", "x984MatchingMethod");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4", "x984FormatOwner");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 0", "x984CbeffOwner");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1", "x984IbiaOwner");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 1", "ibiaOwnerSAFLINK");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 2", "ibiaOwnerBioscrypt");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 3", "ibiaOwnerVisionics");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 4", "ibiaOwnerInfineonTechnologiesAG");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 5", "ibiaOwnerIridianTechnologies");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 6", "ibiaOwnerVeridicom");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 7", "ibiaOwnerCyberSIGN");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 8", "ibiaOwnereCryp");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 9", "ibiaOwnerFingerprintCardsAB");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 10", "ibiaOwnerSecuGen");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 11", "ibiaOwnerPreciseBiometric");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 12", "ibiaOwnerIdentix");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 13", "ibiaOwnerDERMALOG");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 14", "ibiaOwnerLOGICO");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 15", "ibiaOwnerNIST");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 16", "ibiaOwnerA3Vision");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 17", "ibiaOwnerNEC");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1 18", "ibiaOwnerSTMicroelectronics");
        OidNameMapper.insertMap("1 3 133 16 840 9 84 4 1", "x984X9Owner");
        OidNameMapper.insertMap("2 5 4 0", "objectClass");
        OidNameMapper.insertMap("2 5 4 1", "aliasedEntryName");
        OidNameMapper.insertMap("2 5 4 2", "knowledgeInformation");
        OidNameMapper.insertMap("2 5 4 3", "commonName");
        OidNameMapper.insertMap("2 5 4 4", "surname");
        OidNameMapper.insertMap("2 5 4 5", "serialNumber");
        OidNameMapper.insertMap("2 5 4 6", "countryName");
        OidNameMapper.insertMap("2 5 4 7", "localityName");
        OidNameMapper.insertMap("2 5 4 7 1", "collectiveLocalityName");
        OidNameMapper.insertMap("2 5 4 8", "stateOrProvinceName");
        OidNameMapper.insertMap("2 5 4 8 1", "collectiveStateOrProvinceName");
        OidNameMapper.insertMap("2 5 4 9", "streetAddress");
        OidNameMapper.insertMap("2 5 4 9 1", "collectiveStreetAddress");
        OidNameMapper.insertMap("2 5 4 10", "organizationName");
        OidNameMapper.insertMap("2 5 4 10 1", "collectiveOrganizationName");
        OidNameMapper.insertMap("2 5 4 11", "organizationalUnitName");
        OidNameMapper.insertMap("2 5 4 11 1", "collectiveOrganizationalUnitName");
        OidNameMapper.insertMap("2 5 4 12", "title");
        OidNameMapper.insertMap("2 5 4 13", "description");
        OidNameMapper.insertMap("2 5 4 14", "searchGuide");
        OidNameMapper.insertMap("2 5 4 15", "businessCategory");
        OidNameMapper.insertMap("2 5 4 16", "postalAddress");
        OidNameMapper.insertMap("2 5 4 16 1", "collectivePostalAddress");
        OidNameMapper.insertMap("2 5 4 17", "postalCode");
        OidNameMapper.insertMap("2 5 4 17 1", "collectivePostalCode");
        OidNameMapper.insertMap("2 5 4 18", "postOfficeBox");
        OidNameMapper.insertMap("2 5 4 18 1", "collectivePostOfficeBox");
        OidNameMapper.insertMap("2 5 4 19", "physicalDeliveryOfficeName");
        OidNameMapper.insertMap("2 5 4 19 1", "collectivePhysicalDeliveryOfficeName");
        OidNameMapper.insertMap("2 5 4 20", "telephoneNumber");
        OidNameMapper.insertMap("2 5 4 20 1", "collectiveTelephoneNumber");
        OidNameMapper.insertMap("2 5 4 21", "telexNumber");
        OidNameMapper.insertMap("2 5 4 21 1", "collectiveTelexNumber");
        OidNameMapper.insertMap("2 5 4 22", "teletexTerminalIdentifier");
        OidNameMapper.insertMap("2 5 4 22 1", "collectiveTeletexTerminalIdentifier");
        OidNameMapper.insertMap("2 5 4 23", "facsimileTelephoneNumber");
        OidNameMapper.insertMap("2 5 4 23 1", "collectiveFacsimileTelephoneNumber");
        OidNameMapper.insertMap("2 5 4 24", "x121Address");
        OidNameMapper.insertMap("2 5 4 25", "internationalISDNNumber");
        OidNameMapper.insertMap("2 5 4 25 1", "collectiveInternationalISDNNumber");
        OidNameMapper.insertMap("2 5 4 26", "registeredAddress");
        OidNameMapper.insertMap("2 5 4 27", "destinationIndicator");
        OidNameMapper.insertMap("2 5 4 28", "preferredDeliveryMehtod");
        OidNameMapper.insertMap("2 5 4 29", "presentationAddress");
        OidNameMapper.insertMap("2 5 4 30", "supportedApplicationContext");
        OidNameMapper.insertMap("2 5 4 31", "member");
        OidNameMapper.insertMap("2 5 4 32", "owner");
        OidNameMapper.insertMap("2 5 4 33", "roleOccupant");
        OidNameMapper.insertMap("2 5 4 34", "seeAlso");
        OidNameMapper.insertMap("2 5 4 35", "userPassword");
        OidNameMapper.insertMap("2 5 4 36", "userCertificate");
        OidNameMapper.insertMap("2 5 4 37", "caCertificate");
        OidNameMapper.insertMap("2 5 4 38", "authorityRevocationList");
        OidNameMapper.insertMap("2 5 4 39", "certificateRevocationList");
        OidNameMapper.insertMap("2 5 4 40", "crossCertificatePair");
        OidNameMapper.insertMap("2 5 4 41", "name");
        OidNameMapper.insertMap("2 5 4 42", "givenName");
        OidNameMapper.insertMap("2 5 4 43", "initials");
        OidNameMapper.insertMap("2 5 4 44", "generationQualifier");
        OidNameMapper.insertMap("2 5 4 45", "uniqueIdentifier");
        OidNameMapper.insertMap("2 5 4 46", "dnQualifier");
        OidNameMapper.insertMap("2 5 4 47", "enhancedSearchGuide");
        OidNameMapper.insertMap("2 5 4 48", "protocolInformation");
        OidNameMapper.insertMap("2 5 4 49", "distinguishedName");
        OidNameMapper.insertMap("2 5 4 50", "uniqueMember");
        OidNameMapper.insertMap("2 5 4 51", "houseIdentifier");
        OidNameMapper.insertMap("2 5 4 52", "supportedAlgorithms");
        OidNameMapper.insertMap("2 5 4 53", "deltaRevocationList");
        OidNameMapper.insertMap("2 5 4 54", "dmdName");
        OidNameMapper.insertMap("2 5 4 55", "clearance");
        OidNameMapper.insertMap("2 5 4 56", "defaultDirQop");
        OidNameMapper.insertMap("2 5 4 57", "attributeIntegrityInfo");
        OidNameMapper.insertMap("2 5 4 58", "attributeCertificate");
        OidNameMapper.insertMap("2 5 4 59", "attributeCertificateRevocationList");
        OidNameMapper.insertMap("2 5 4 60", "confKeyInfo");
        OidNameMapper.insertMap("2 5 4 61", "aACertificate");
        OidNameMapper.insertMap("2 5 4 62", "attributeDescriptorCertificate");
        OidNameMapper.insertMap("2 5 4 63", "attributeAuthorityRevocationList");
        OidNameMapper.insertMap("2 5 4 64", "familyInformation");
        OidNameMapper.insertMap("2 5 4 65", "pseudonym");
        OidNameMapper.insertMap("2 5 4 66", "communicationsService");
        OidNameMapper.insertMap("2 5 4 67", "communicationsNetwork");
        OidNameMapper.insertMap("2 5 4 68", "certificationPracticeStmt");
        OidNameMapper.insertMap("2 5 4 69", "certificatePolicy");
        OidNameMapper.insertMap("2 5 4 70", "pkiPath");
        OidNameMapper.insertMap("2 5 4 71", "privPolicy");
        OidNameMapper.insertMap("2 5 4 72", "role");
        OidNameMapper.insertMap("2 5 4 73", "delegationPath");
        OidNameMapper.insertMap("2 5 4 74", "protPrivPolicy");
        OidNameMapper.insertMap("2 5 4 75", "xMLPrivilegeInfo");
        OidNameMapper.insertMap("2 5 4 76", "xmlPrivPolicy");
        OidNameMapper.insertMap("2 5 4 82", "permission");
        OidNameMapper.insertMap("2 5 6 0", "top");
        OidNameMapper.insertMap("2 5 6 1", "alias");
        OidNameMapper.insertMap("2 5 6 2", "country");
        OidNameMapper.insertMap("2 5 6 3", "locality");
        OidNameMapper.insertMap("2 5 6 4", "organization");
        OidNameMapper.insertMap("2 5 6 5", "organizationalUnit");
        OidNameMapper.insertMap("2 5 6 6", "person");
        OidNameMapper.insertMap("2 5 6 7", "organizationalPerson");
        OidNameMapper.insertMap("2 5 6 8", "organizationalRole");
        OidNameMapper.insertMap("2 5 6 9", "groupOfNames");
        OidNameMapper.insertMap("2 5 6 10", "residentialPerson");
        OidNameMapper.insertMap("2 5 6 11", "applicationProcess");
        OidNameMapper.insertMap("2 5 6 12", "applicationEntity");
        OidNameMapper.insertMap("2 5 6 13", "dSA");
        OidNameMapper.insertMap("2 5 6 14", "device");
        OidNameMapper.insertMap("2 5 6 15", "strongAuthenticationUser");
        OidNameMapper.insertMap("2 5 6 16", "certificateAuthority");
        OidNameMapper.insertMap("2 5 6 17", "groupOfUniqueNames");
        OidNameMapper.insertMap("2 5 6 21", "pkiUser");
        OidNameMapper.insertMap("2 5 6 22", "pkiCA");
        OidNameMapper.insertMap("2 5 8 1 1", "rsa");
        OidNameMapper.insertMap("2 5 29 1", "authorityKeyIdentifier");
        OidNameMapper.insertMap("2 5 29 2", "keyAttributes");
        OidNameMapper.insertMap("2 5 29 3", "certificatePolicies");
        OidNameMapper.insertMap("2 5 29 4", "keyUsageRestriction");
        OidNameMapper.insertMap("2 5 29 5", "policyMapping");
        OidNameMapper.insertMap("2 5 29 6", "subtreesConstraint");
        OidNameMapper.insertMap("2 5 29 7", "subjectAltName");
        OidNameMapper.insertMap("2 5 29 8", "issuerAltName");
        OidNameMapper.insertMap("2 5 29 9", "subjectDirectoryAttributes");
        OidNameMapper.insertMap("2 5 29 10", "basicConstraints");
        OidNameMapper.insertMap("2 5 29 11", "nameConstraints");
        OidNameMapper.insertMap("2 5 29 12", "policyConstraints");
        OidNameMapper.insertMap("2 5 29 13", "basicConstraints");
        OidNameMapper.insertMap("2 5 29 14", "subjectKeyIdentifier");
        OidNameMapper.insertMap("2 5 29 15", "keyUsage");
        OidNameMapper.insertMap("2 5 29 16", "privateKeyUsagePeriod");
        OidNameMapper.insertMap("2 5 29 17", "subjectAltName");
        OidNameMapper.insertMap("2 5 29 18", "issuerAltName");
        OidNameMapper.insertMap("2 5 29 19", "basicConstraints");
        OidNameMapper.insertMap("2 5 29 20", "cRLNumber");
        OidNameMapper.insertMap("2 5 29 21", "cRLReason");
        OidNameMapper.insertMap("2 5 29 22", "expirationDate");
        OidNameMapper.insertMap("2 5 29 23", "instructionCode");
        OidNameMapper.insertMap("2 5 29 24", "invalidityDate");
        OidNameMapper.insertMap("2 5 29 25", "cRLDistributionPoints");
        OidNameMapper.insertMap("2 5 29 26", "issuingDistributionPoint");
        OidNameMapper.insertMap("2 5 29 27", "deltaCRLIndicator");
        OidNameMapper.insertMap("2 5 29 28", "issuingDistributionPoint");
        OidNameMapper.insertMap("2 5 29 29", "certificateIssuer");
        OidNameMapper.insertMap("2 5 29 30", "nameConstraints");
        OidNameMapper.insertMap("2 5 29 31", "cRLDistributionPoints");
        OidNameMapper.insertMap("2 5 29 32", "certificatePolicies");
        OidNameMapper.insertMap("2 5 29 32 0", "anyPolicy");
        OidNameMapper.insertMap("2 5 29 33", "policyMappings");
        OidNameMapper.insertMap("2 5 29 34", "policyConstraints");
        OidNameMapper.insertMap("2 5 29 35", "authorityKeyIdentifier");
        OidNameMapper.insertMap("2 5 29 36", "policyConstraints");
        OidNameMapper.insertMap("2 5 29 37", "extKeyUsage");
        OidNameMapper.insertMap("2 5 29 37 0", "anyExtendedKeyUsage");
        OidNameMapper.insertMap("2 5 29 38", "authorityAttributeIdentifier");
        OidNameMapper.insertMap("2 5 29 39", "roleSpecCertIdentifier");
        OidNameMapper.insertMap("2 5 29 40", "cRLStreamIdentifier");
        OidNameMapper.insertMap("2 5 29 41", "basicAttConstraints");
        OidNameMapper.insertMap("2 5 29 42", "delegatedNameConstraints");
        OidNameMapper.insertMap("2 5 29 43", "timeSpecification");
        OidNameMapper.insertMap("2 5 29 44", "cRLScope");
        OidNameMapper.insertMap("2 5 29 45", "statusReferrals");
        OidNameMapper.insertMap("2 5 29 46", "freshestCRL");
        OidNameMapper.insertMap("2 5 29 47", "orderedList");
        OidNameMapper.insertMap("2 5 29 48", "attributeDescriptor");
        OidNameMapper.insertMap("2 5 29 49", "userNotice");
        OidNameMapper.insertMap("2 5 29 50", "sOAIdentifier");
        OidNameMapper.insertMap("2 5 29 51", "baseUpdateTime");
        OidNameMapper.insertMap("2 5 29 52", "acceptableCertPolicies");
        OidNameMapper.insertMap("2 5 29 53", "deltaInfo");
        OidNameMapper.insertMap("2 5 29 54", "inhibitAnyPolicy");
        OidNameMapper.insertMap("2 5 29 55", "targetInformation");
        OidNameMapper.insertMap("2 5 29 56", "noRevAvail");
        OidNameMapper.insertMap("2 5 29 57", "acceptablePrivilegePolicies");
        OidNameMapper.insertMap("2 5 29 58", "toBeRevoked");
        OidNameMapper.insertMap("2 5 29 59", "revokedGroups");
        OidNameMapper.insertMap("2 5 29 60", "expiredCertsOnCRL");
        OidNameMapper.insertMap("2 5 29 61", "indirectIssuer");
        OidNameMapper.insertMap("2 5 29 62", "noAssertion");
        OidNameMapper.insertMap("2 5 29 63", "aAissuingDistributionPoint");
        OidNameMapper.insertMap("2 5 29 64", "issuedOnBehalfOf");
        OidNameMapper.insertMap("2 5 29 65", "singleUse");
        OidNameMapper.insertMap("2 5 29 66", "groupAC");
        OidNameMapper.insertMap("2 5 29 67", "allowedAttAss");
        OidNameMapper.insertMap("2 5 29 68", "attributeMappings");
        OidNameMapper.insertMap("2 5 29 69", "holderNameConstraints");
        OidNameMapper.insertMap("2 16 724 1 2 2 4 1", "personalDataInfo");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 1", "sdnsSignatureAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 2", "fortezzaSignatureAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 3", "sdnsConfidentialityAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 4", "fortezzaConfidentialityAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 5", "sdnsIntegrityAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 6", "fortezzaIntegrityAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 7", "sdnsTokenProtectionAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 8", "fortezzaTokenProtectionAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 9", "sdnsKeyManagementAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 10", "fortezzaKeyManagementAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 11", "sdnsKMandSigAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 12", "fortezzaKMandSigAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 13", "suiteASignatureAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 14", "suiteAConfidentialityAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 15", "suiteAIntegrityAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 16", "suiteATokenProtectionAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 17", "suiteAKeyManagementAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 18", "suiteAKMandSigAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 19", "fortezzaUpdatedSigAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 20", "fortezzaKMandUpdSigAlgorithms");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 21", "fortezzaUpdatedIntegAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 22", "keyExchangeAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 23", "fortezzaWrap80Algorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 1 24", "kEAKeyEncryptionAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 1", "rfc822MessageFormat");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 2", "emptyContent");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 3", "cspContentType");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 42", "mspRev3ContentType");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 48", "mspContentType");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 49", "mspRekeyAgentProtocol");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 50", "mspMMP");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 66", "mspRev3-1ContentType");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 72", "forwardedMSPMessageBodyPart");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 73", "mspForwardedMessageParameters");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 74", "forwardedCSPMsgBodyPart");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 75", "cspForwardedMessageParameters");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 2 76", "mspMMP2");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 1", "sdnsSecurityPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 2", "sdnsPRBAC");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 3", "mosaicPRBAC");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10", "siSecurityPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 0", "siNASP");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 1", "siELCO");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 2", "siTK");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 3", "siDSAP");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 4", "siSSSS");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 5", "siDNASP");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 6", "siBYEMAN");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 7", "siREL-US");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 8", "siREL-AUS");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 9", "siREL-CAN");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 10", "siREL_UK");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 11", "siREL-NZ");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 10 12", "siGeneric");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 11", "genser");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 11 0", "genserNations");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 11 1", "genserComsec");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 11 2", "genserAcquisition");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 11 3", "genserSecurityCategories");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 11 3 0", "genserTagSetName");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 12", "defaultSecurityPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 13", "capcoMarkings");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 13 0", "capcoSecurityCategories");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 13 0 1", "capcoTagSetName1");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 13 0 2", "capcoTagSetName2");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 13 0 3", "capcoTagSetName3");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 3 13 0 4", "capcoTagSetName4");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 1", "sdnsKeyManagementCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 2", "sdnsUserSignatureCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 3", "sdnsKMandSigCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 4", "fortezzaKeyManagementCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 5", "fortezzaKMandSigCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 6", "fortezzaUserSignatureCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 7", "fortezzaCASignatureCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 8", "sdnsCASignatureCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 10", "auxiliaryVector");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 11", "mlReceiptPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 12", "mlMembership");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 13", "mlAdministrators");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 14", "alid");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 20", "janUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 21", "febUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 22", "marUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 23", "aprUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 24", "mayUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 25", "junUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 26", "julUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 27", "augUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 28", "sepUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 29", "octUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 30", "novUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 31", "decUKMs");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 40", "metaSDNSckl");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 41", "sdnsCKL");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 42", "metaSDNSsignatureCKL");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 43", "sdnsSignatureCKL");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 44", "sdnsCertificateRevocationList");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 45", "fortezzaCertificateRevocationList");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 46", "fortezzaCKL");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 47", "alExemptedAddressProcessor");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 48", "guard");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 49", "algorithmsSupported");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 50", "suiteAKeyManagementCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 51", "suiteAKMandSigCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 52", "suiteAUserSignatureCertificate");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 53", "prbacInfo");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 54", "prbacCAConstraints");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 55", "sigOrKMPrivileges");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 56", "commPrivileges");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 57", "labeledAttribute");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 58", "policyInformationFile");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 59", "secPolicyInformationFile");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 5 60", "cAClearanceConstraint");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 7 1", "cspExtns");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 7 1 0", "cspCsExtn");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 8 1", "mISSISecurityCategories");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 8 2", "standardSecurityLabelPrivileges");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 10 1", "sigPrivileges");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 10 2", "kmPrivileges");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 10 3", "namedTagSetPrivilege");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 11 1", "ukDemo");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 11 2", "usDODClass2");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 11 3", "usMediumPilot");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 11 4", "usDODClass4");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 11 5", "usDODClass3");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 11 6", "usDODClass5");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0", "testSecurityPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 1", "tsp1");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 1 0", "tsp1SecurityCategories");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 1 0 0", "tsp1TagSetZero");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 1 0 1", "tsp1TagSetOne");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 1 0 2", "tsp1TagSetTwo");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 2", "tsp2");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 2 0", "tsp2SecurityCategories");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 2 0 0", "tsp2TagSetZero");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 2 0 1", "tsp2TagSetOne");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 2 0 2", "tsp2TagSetTwo");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 3", "kafka");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 3 0", "kafkaSecurityCategories");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 3 0 1", "kafkaTagSetName1");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 3 0 2", "kafkaTagSetName2");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 0 3 0 3", "kafkaTagSetName3");
        OidNameMapper.insertMap("2 16 840 1 101 2 1 12 1 1", "tcp1");
        OidNameMapper.insertMap("2 16 840 1 101 3 1", "slabel");
        OidNameMapper.insertMap("2 16 840 1 101 3 2", "pki");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1", "NIST policyIdentifier");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 3 1", "fbcaRudimentaryPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 3 2", "fbcaBasicPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 3 3", "fbcaMediumPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 3 4", "fbcaHighPolicy");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 48 1", "nistTestPolicy1");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 48 2", "nistTestPolicy2");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 48 3", "nistTestPolicy3");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 48 4", "nistTestPolicy4");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 48 5", "nistTestPolicy5");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 1 48 6", "nistTestPolicy6");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 2", "gak");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 2 1", "kRAKey");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 3", "extensions");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 3 1", "kRTechnique");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 3 2", "kRecoveryCapable");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 3 3", "kR");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 4", "keyRecoverySchemes");
        OidNameMapper.insertMap("2 16 840 1 101 3 2 5", "krapola");
        OidNameMapper.insertMap("2 16 840 1 101 3 3", "arpa");
        OidNameMapper.insertMap("2 16 840 1 101 3 4", "nistAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1", "aes");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 1", "aes128-ECB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 2", "aes128-CBC");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 3", "aes128-OFB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 4", "aes128-CFB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 5", "aes128-wrap");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 6", "aes128-GCM");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 7", "aes128-CCM");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 8", "aes128-wrap-pad");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 21", "aes192-ECB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 22", "aes192-CBC");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 23", "aes192-OFB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 24", "aes192-CFB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 25", "aes192-wrap");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 26", "aes192-GCM");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 27", "aes192-CCM");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 28", "aes192-wrap-pad");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 41", "aes256-ECB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 42", "aes256-CBC");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 43", "aes256-OFB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 44", "aes256-CFB");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 45", "aes256-wrap");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 46", "aes256-GCM");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 47", "aes256-CCM");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 1 48", "aes256-wrap-pad");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 2", "hashAlgos");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 2 1", "sha-256");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 2 2", "sha-384");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 2 3", "sha-512");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 2 4", "sha-224");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 3 1", "dsaWithSha224");
        OidNameMapper.insertMap("2 16 840 1 101 3 4 3 2", "dsaWithSha256");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8", "novellAlgorithm");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 22", "desCbcIV8");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 23", "desCbcPadIV8");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 24", "desEDE2CbcIV8");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 25", "desEDE2CbcPadIV8");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 26", "desEDE3CbcIV8");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 27", "desEDE3CbcPadIV8");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 28", "rc5CbcPad");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 29", "md2WithRSAEncryptionBSafe1");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 30", "md5WithRSAEncryptionBSafe1");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 31", "sha1WithRSAEncryptionBSafe1");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 32", "lmDigest");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 40", "md2");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 50", "md5");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 51", "ikeHmacWithSHA1-RSA");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 52", "ikeHmacWithMD5-RSA");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 69", "rc2CbcPad");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 82", "sha-1");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 92", "rc2BSafe1Cbc");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 95", "md4");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 130", "md4Packet");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 131", "rsaEncryptionBsafe1");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 132", "nwPassword");
        OidNameMapper.insertMap("2 16 840 1 113719 1 2 8 133", "novellObfuscate-1");
        OidNameMapper.insertMap("2 16 840 1 113719 1 9", "pki");
        OidNameMapper.insertMap("2 16 840 1 113719 1 9 4", "pkiAttributeType");
        OidNameMapper.insertMap("2 16 840 1 113719 1 9 4 1", "securityAttributes");
        OidNameMapper.insertMap("2 16 840 1 113719 1 9 4 2", "relianceLimit");
        OidNameMapper.insertMap("2 16 840 1 113730 1", "cert-extension");
        OidNameMapper.insertMap("2 16 840 1 113730 1 1", "netscape-cert-type");
        OidNameMapper.insertMap("2 16 840 1 113730 1 2", "netscape-base-url");
        OidNameMapper.insertMap("2 16 840 1 113730 1 3", "netscape-revocation-url");
        OidNameMapper.insertMap("2 16 840 1 113730 1 4", "netscape-ca-revocation-url");
        OidNameMapper.insertMap("2 16 840 1 113730 1 7", "netscape-cert-renewal-url");
        OidNameMapper.insertMap("2 16 840 1 113730 1 8", "netscape-ca-policy-url");
        OidNameMapper.insertMap("2 16 840 1 113730 1 9", "HomePage-url");
        OidNameMapper.insertMap("2 16 840 1 113730 1 10", "EntityLogo");
        OidNameMapper.insertMap("2 16 840 1 113730 1 11", "UserPicture");
        OidNameMapper.insertMap("2 16 840 1 113730 1 12", "netscape-ssl-server-name");
        OidNameMapper.insertMap("2 16 840 1 113730 1 13", "netscape-comment");
        OidNameMapper.insertMap("2 16 840 1 113730 2", "data-type");
        OidNameMapper.insertMap("2 16 840 1 113730 2 1", "dataGIF");
        OidNameMapper.insertMap("2 16 840 1 113730 2 2", "dataJPEG");
        OidNameMapper.insertMap("2 16 840 1 113730 2 3", "dataURL");
        OidNameMapper.insertMap("2 16 840 1 113730 2 4", "dataHTML");
        OidNameMapper.insertMap("2 16 840 1 113730 2 5", "certSequence");
        OidNameMapper.insertMap("2 16 840 1 113730 2 6", "certURL");
        OidNameMapper.insertMap("2 16 840 1 113730 3", "directory");
        OidNameMapper.insertMap("2 16 840 1 113730 3 1", "ldapDefinitions");
        OidNameMapper.insertMap("2 16 840 1 113730 3 1 1", "carLicense");
        OidNameMapper.insertMap("2 16 840 1 113730 3 1 2", "departmentNumber");
        OidNameMapper.insertMap("2 16 840 1 113730 3 1 3", "employeeNumber");
        OidNameMapper.insertMap("2 16 840 1 113730 3 1 4", "employeeType");
        OidNameMapper.insertMap("2 16 840 1 113730 3 2 2", "inetOrgPerson");
        OidNameMapper.insertMap("2 16 840 1 113730 4 1", "serverGatedCrypto");
        OidNameMapper.insertMap("2 16 840 1 113733 1 6 3", "verisignCZAG");
        OidNameMapper.insertMap("2 16 840 1 113733 1 6 6", "verisignInBox");
        OidNameMapper.insertMap("2 16 840 1 113733 1 6 11", "verisignOnsiteJurisdictionHash");
        OidNameMapper.insertMap("2 16 840 1 113733 1 6 13", "Unknown Verisign VPN extension");
        OidNameMapper.insertMap("2 16 840 1 113733 1 6 15", "verisignServerID");
        OidNameMapper.insertMap("2 16 840 1 113733 1 7 1 1", "verisignCertPolicies95Qualifier1");
        OidNameMapper.insertMap("2 16 840 1 113733 1 7 1 1 1", "verisignCPSv1notice");
        OidNameMapper.insertMap("2 16 840 1 113733 1 7 1 1 2", "verisignCPSv1nsi");
        OidNameMapper.insertMap("2 16 840 1 113733 1 8 1", "verisignISSStrongCrypto");
        OidNameMapper.insertMap("2 16 840 1 113733 1", "pki");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9", "pkcs7Attribute");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 2", "messageType");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 3", "pkiStatus");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 4", "failInfo");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 5", "senderNonce");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 6", "recipientNonce");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 7", "transID");
        OidNameMapper.insertMap("2 16 840 1 113733 1 9 8", "extensionReq");
        OidNameMapper.insertMap("2 16 840 1 113741 2", "intelCDSA");
        OidNameMapper.insertMap("2 16 840 1 114412 1", "digiCertNonEVCerts");
        OidNameMapper.insertMap("2 16 840 1 114412 1 1", "digiCertOVCert");
        OidNameMapper.insertMap("2 16 840 1 114412 1 2", "digiCertDVCert");
        OidNameMapper.insertMap("2 16 840 1 114412 1 11", "digiCertFederatedDeviceCert");
        OidNameMapper.insertMap("2 16 840 1 114412 1 3 0 1", "digiCertGlobalCAPolicy");
        OidNameMapper.insertMap("2 16 840 1 114412 1 3 0 2", "digiCertHighAssuranceEVCAPolicy");
        OidNameMapper.insertMap("2 16 840 1 114412 1 3 0 3", "digiCertGlobalRootCAPolicy");
        OidNameMapper.insertMap("2 16 840 1 114412 1 3 0 4", "digiCertAssuredIDRootCAPolicy");
        OidNameMapper.insertMap("2 16 840 1 114412 2 2", "digiCertEVCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 3", "digiCertObjectSigningCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 3 1", "digiCertCodeSigningCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 3 2", "digiCertEVCodeSigningCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 3 11", "digiCertKernelCodeSigningCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 3 21", "digiCertDocumentSigningCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4", "digiCertClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 1 1", "digiCertLevel1PersonalClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 1 2", "digiCertLevel1EnterpriseClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 2", "digiCertLevel2ClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 3 1", "digiCertLevel3USClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 3 2", "digiCertLevel3CBPClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 4 1", "digiCertLevel4USClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 4 2", "digiCertLevel4CBPClientCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 5 1", "digiCertPIVHardwareCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 5 2", "digiCertPIVCardAuthCert");
        OidNameMapper.insertMap("2 16 840 1 114412 2 4 5 3", "digiCertPIVContentSigningCert");
        OidNameMapper.insertMap("2 16 840 1 114412 4 31", "digiCertGridClassicCert");
        OidNameMapper.insertMap("2 16 840 1 114412 4 31 5", "digiCertGridIntegratedCert");
        OidNameMapper.insertMap("2 16 840 1 114412 31 4 31 1", "digiCertGridHostCert");
        OidNameMapper.insertMap("2 23 42 0", "contentType");
        OidNameMapper.insertMap("2 23 42 0 0", "panData");
        OidNameMapper.insertMap("2 23 42 0 1", "panToken");
        OidNameMapper.insertMap("2 23 42 0 2", "panOnly");
        OidNameMapper.insertMap("2 23 42 1", "msgExt");
        OidNameMapper.insertMap("2 23 42 2", "field");
        OidNameMapper.insertMap("2 23 42 2 0", "fullName");
        OidNameMapper.insertMap("2 23 42 2 1", "givenName");
        OidNameMapper.insertMap("2 23 42 2 2", "familyName");
        OidNameMapper.insertMap("2 23 42 2 3", "birthFamilyName");
        OidNameMapper.insertMap("2 23 42 2 4", "placeName");
        OidNameMapper.insertMap("2 23 42 2 5", "identificationNumber");
        OidNameMapper.insertMap("2 23 42 2 6", "month");
        OidNameMapper.insertMap("2 23 42 2 7", "date");
        OidNameMapper.insertMap("2 23 42 2 8", "address");
        OidNameMapper.insertMap("2 23 42 2 9", "telephone");
        OidNameMapper.insertMap("2 23 42 2 10", "amount");
        OidNameMapper.insertMap("2 23 42 2 11", "accountNumber");
        OidNameMapper.insertMap("2 23 42 2 12", "passPhrase");
        OidNameMapper.insertMap("2 23 42 3", "attribute");
        OidNameMapper.insertMap("2 23 42 3 0", "cert");
        OidNameMapper.insertMap("2 23 42 3 0 0", "rootKeyThumb");
        OidNameMapper.insertMap("2 23 42 3 0 1", "additionalPolicy");
        OidNameMapper.insertMap("2 23 42 4", "algorithm");
        OidNameMapper.insertMap("2 23 42 5", "policy");
        OidNameMapper.insertMap("2 23 42 5 0", "root");
        OidNameMapper.insertMap("2 23 42 6", "module");
        OidNameMapper.insertMap("2 23 42 7", "certExt");
        OidNameMapper.insertMap("2 23 42 7 0", "hashedRootKey");
        OidNameMapper.insertMap("2 23 42 7 1", "certificateType");
        OidNameMapper.insertMap("2 23 42 7 2", "merchantData");
        OidNameMapper.insertMap("2 23 42 7 3", "cardCertRequired");
        OidNameMapper.insertMap("2 23 42 7 4", "tunneling");
        OidNameMapper.insertMap("2 23 42 7 5", "setExtensions");
        OidNameMapper.insertMap("2 23 42 7 6", "setQualifier");
        OidNameMapper.insertMap("2 23 42 8", "brand");
        OidNameMapper.insertMap("2 23 42 8 1", "IATA-ATA");
        OidNameMapper.insertMap("2 23 42 8 4", "VISA");
        OidNameMapper.insertMap("2 23 42 8 5", "MasterCard");
        OidNameMapper.insertMap("2 23 42 8 30", "Diners");
        OidNameMapper.insertMap("2 23 42 8 34", "AmericanExpress");
        OidNameMapper.insertMap("2 23 42 8 6011", "Novus");
        OidNameMapper.insertMap("2 23 42 9", "vendor");
        OidNameMapper.insertMap("2 23 42 9 0", "GlobeSet");
        OidNameMapper.insertMap("2 23 42 9 1", "IBM");
        OidNameMapper.insertMap("2 23 42 9 2", "CyberCash");
        OidNameMapper.insertMap("2 23 42 9 3", "Terisa");
        OidNameMapper.insertMap("2 23 42 9 4", "RSADSI");
        OidNameMapper.insertMap("2 23 42 9 5", "VeriFone");
        OidNameMapper.insertMap("2 23 42 9 6", "TrinTech");
        OidNameMapper.insertMap("2 23 42 9 7", "BankGate");
        OidNameMapper.insertMap("2 23 42 9 8", "GTE");
        OidNameMapper.insertMap("2 23 42 9 9", "CompuSource");
        OidNameMapper.insertMap("2 23 42 9 10", "Griffin");
        OidNameMapper.insertMap("2 23 42 9 11", "Certicom");
        OidNameMapper.insertMap("2 23 42 9 12", "OSS");
        OidNameMapper.insertMap("2 23 42 9 13", "TenthMountain");
        OidNameMapper.insertMap("2 23 42 9 14", "Antares");
        OidNameMapper.insertMap("2 23 42 9 15", "ECC");
        OidNameMapper.insertMap("2 23 42 9 16", "Maithean");
        OidNameMapper.insertMap("2 23 42 9 17", "Netscape");
        OidNameMapper.insertMap("2 23 42 9 18", "Verisign");
        OidNameMapper.insertMap("2 23 42 9 19", "BlueMoney");
        OidNameMapper.insertMap("2 23 42 9 20", "Lacerte");
        OidNameMapper.insertMap("2 23 42 9 21", "Fujitsu");
        OidNameMapper.insertMap("2 23 42 9 22", "eLab");
        OidNameMapper.insertMap("2 23 42 9 23", "Entrust");
        OidNameMapper.insertMap("2 23 42 9 24", "VIAnet");
        OidNameMapper.insertMap("2 23 42 9 25", "III");
        OidNameMapper.insertMap("2 23 42 9 26", "OpenMarket");
        OidNameMapper.insertMap("2 23 42 9 27", "Lexem");
        OidNameMapper.insertMap("2 23 42 9 28", "Intertrader");
        OidNameMapper.insertMap("2 23 42 9 29", "Persimmon");
        OidNameMapper.insertMap("2 23 42 9 30", "NABLE");
        OidNameMapper.insertMap("2 23 42 9 31", "espace-net");
        OidNameMapper.insertMap("2 23 42 9 32", "Hitachi");
        OidNameMapper.insertMap("2 23 42 9 33", "Microsoft");
        OidNameMapper.insertMap("2 23 42 9 34", "NEC");
        OidNameMapper.insertMap("2 23 42 9 35", "Mitsubishi");
        OidNameMapper.insertMap("2 23 42 9 36", "NCR");
        OidNameMapper.insertMap("2 23 42 9 37", "e-COMM");
        OidNameMapper.insertMap("2 23 42 9 38", "Gemplus");
        OidNameMapper.insertMap("2 23 42 10", "national");
        OidNameMapper.insertMap("2 23 42 10 392", "Japan");
        OidNameMapper.insertMap("2 23 133", "tCPA");
        OidNameMapper.insertMap("2 23 133 1", "tcpaSpecVersion");
        OidNameMapper.insertMap("2 23 133 2", "tcpaAttribute");
        OidNameMapper.insertMap("2 23 133 2 1", "tcpaTpmManufacturer");
        OidNameMapper.insertMap("2 23 133 2 2", "tcpaTpmModel");
        OidNameMapper.insertMap("2 23 133 2 3", "tcpaTpmVersion");
        OidNameMapper.insertMap("2 23 133 2 4", "tcpaPlatformManufacturer");
        OidNameMapper.insertMap("2 23 133 2 5", "tcpaPlatformModel");
        OidNameMapper.insertMap("2 23 133 2 6", "tcpaPlatformVersion");
        OidNameMapper.insertMap("2 23 133 2 7", "tcpaComponentManufacturer");
        OidNameMapper.insertMap("2 23 133 2 8", "tcpaComponentModel");
        OidNameMapper.insertMap("2 23 133 2 9", "tcpaComponentVersion");
        OidNameMapper.insertMap("2 23 133 2 10", "tcpaSecurityQualities");
        OidNameMapper.insertMap("2 23 133 2 11", "tcpaTpmProtectionProfile");
        OidNameMapper.insertMap("2 23 133 2 12", "tcpaTpmSecurityTarget");
        OidNameMapper.insertMap("2 23 133 2 13", "tcpaFoundationProtectionProfile");
        OidNameMapper.insertMap("2 23 133 2 14", "tcpaFoundationSecurityTarget");
        OidNameMapper.insertMap("2 23 133 2 15", "tcpaTpmIdLabel");
        OidNameMapper.insertMap("2 23 133 3", "tcpaProtocol");
        OidNameMapper.insertMap("2 23 133 3 1", "tcpaPrttTpmIdProtocol");
        OidNameMapper.insertMap("2 23 134 1 4 2 1", "postSignumRootQCA  ");
        OidNameMapper.insertMap("2 23 134 1 2 2 3", "postSignumPublicCA ");
        OidNameMapper.insertMap("2 23 134 1 2 1 8 210", "postSignumCommercialServerPolicy");
        OidNameMapper.insertMap("2 23 136 1 1 1", "mRTDSignatureData");
        OidNameMapper.insertMap("2 54 1775 2", "hashedRootKey");
        OidNameMapper.insertMap("2 54 1775 3", "certificateType");
        OidNameMapper.insertMap("2 54 1775 4", "merchantData");
        OidNameMapper.insertMap("2 54 1775 5", "cardCertRequired");
        OidNameMapper.insertMap("2 54 1775 6", "tunneling");
        OidNameMapper.insertMap("2 54 1775 7", "setQualifier");
        OidNameMapper.insertMap("2 54 1775 99", "setData");
        OidNameMapper.insertMap("1 2 40 0 17 1 22", "A-Trust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 34697 2 1", "AffirmTrust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 34697 2 2", "AffirmTrust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 34697 2 3", "AffirmTrust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 34697 2 4", "AffirmTrust EV policy");
        OidNameMapper.insertMap("2 16 578 1 26 1 3 3", "BuyPass EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 17326 10 14 2 1 2", "Camerfirma EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 17326 10 8 12 1 2", "Camerfirma EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 22234 2 5 2 3 1", "CertPlus EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 6449 1 2 1 5 1", "Comodo EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 6334 1 100 1", "Cybertrust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4788 2 202 1", "D-TRUST EV policy");
        OidNameMapper.insertMap("2 16 840 1 114412 2 1", "DigiCert EV policy");
        OidNameMapper.insertMap("2 16 528 1 1001 1 1 1 12 6 1 1 1", "DigiNotar EV policy");
        OidNameMapper.insertMap("2 16 840 1 114028 10 1 2", "Entrust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 14370 1 6", "GeoTrust EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 4146 1 1", "GlobalSign EV policy");
        OidNameMapper.insertMap("2 16 840 1 114413 1 7 23 3", "GoDaddy EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 14777 6 1 1", "Izenpe EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 14777 6 1 2", "Izenpe EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 782 1 2 1 8 1", "Network Solutions EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 8024 0 2 100 1 2", "QuoVadis EV policy");
        OidNameMapper.insertMap("1 2 392 200091 100 721 1", "Security Communication (SECOM) EV policy");
        OidNameMapper.insertMap("2 16 840 1 114414 1 7 23 3", "Starfield EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 23223 1 1 1", "StartCom EV policy");
        OidNameMapper.insertMap("2 16 756 1 89 1 2 1 1", "SwissSign EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 7879 13 24 1", "T-TeleSec EV policy");
        OidNameMapper.insertMap("2 16 840 1 113733 1 7 48 1", "Thawte EV policy");
        OidNameMapper.insertMap("2 16 840 1 114404 1 1 2 4 1", "TrustWave EV policy");
        OidNameMapper.insertMap("1 3 6 1 4 1 40869 1 1 22 3", "TWCA EV policy");
        OidNameMapper.insertMap("2 16 840 1 113733 1 7 23 6", "VeriSign EV policy");
        OidNameMapper.insertMap("2 16 840 1 114171 500 9", "Wells Fargo EV policy");
    }
}

