/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.util;

import de.trustable.util.OidNameMapper;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;

public class AlgorithmInfo {
    private String sigAlgName;
    private String hashAlgName = "undefined";
    private String paddingAlgName = "PKCS1";
    private String mfgName = "";
    static Map<String, String> hashToNormalizedName = new HashMap<String, String>();
    static Map<String, String> signingAlgoToNormalizedName;

    public AlgorithmInfo(String algoNames) {
        String[] parts;
        this.sigAlgName = OidNameMapper.lookupOid(algoNames).toLowerCase();
        if (this.sigAlgName.contains("with") && (parts = this.sigAlgName.split("with")).length > 1) {
            this.hashAlgName = parts[0];
            if (hashToNormalizedName.containsKey(this.hashAlgName)) {
                this.hashAlgName = hashToNormalizedName.get(this.hashAlgName);
            }
            if (parts[1].contains("and")) {
                String[] parts2 = parts[1].split("and");
                this.sigAlgName = parts2[0];
                if (parts2.length > 1) {
                    this.paddingAlgName = parts2[1];
                }
            } else {
                this.sigAlgName = parts[1];
                if (signingAlgoToNormalizedName.containsKey(this.sigAlgName)) {
                    this.sigAlgName = signingAlgoToNormalizedName.get(this.sigAlgName);
                }
            }
        }
    }

    public AlgorithmInfo(RSASSAPSSparams rsassapssParams) {
        this.paddingAlgName = "pss";
        this.sigAlgName = "rsa";
        this.hashAlgName = OidNameMapper.lookupOid(rsassapssParams.getHashAlgorithm().getAlgorithm().getId());
        this.mfgName = OidNameMapper.lookupOid(rsassapssParams.getMaskGenAlgorithm().getAlgorithm().getId());
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getSigAlgFriendlyName() {
        if ("RSAEncryption".equalsIgnoreCase(this.sigAlgName)) {
            return "rsa";
        }
        return this.sigAlgName;
    }

    public String getHashAlgName() {
        return this.hashAlgName;
    }

    public String getPaddingAlgName() {
        return this.paddingAlgName;
    }

    public String getMfgName() {
        return this.mfgName;
    }

    static {
        hashToNormalizedName.put("sha1", "sha-1");
        hashToNormalizedName.put("sha256", "sha-256");
        hashToNormalizedName.put("sha384", "sha-384");
        hashToNormalizedName.put("sha512", "sha-512");
        signingAlgoToNormalizedName = new HashMap<String, String>();
        signingAlgoToNormalizedName.put("rsaencryption", "rsa");
    }
}

