/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.RequestProxyConfigService;
import de.trustable.ca3s.core.service.dto.RequestProxyConfigView;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RequestProxyConfigAdministration {
    private final Logger LOG = LoggerFactory.getLogger(RequestProxyConfigAdministration.class);
    public static final String PLAIN_SECRET_PLACEHOLDER = "******";
    private static final String ENTITY_NAME = "requestProxyConfig";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RequestProxyConfigService requestProxyConfigService;
    private final ProtectedContentUtil protUtil;
    private final ProtectedContentRepository protContentRepository;
    private final AuditService auditService;

    public RequestProxyConfigAdministration(RequestProxyConfigService requestProxyConfigService, ProtectedContentUtil protUtil, ProtectedContentRepository protContentRepository, AuditService auditService) {
        this.requestProxyConfigService = requestProxyConfigService;
        this.protUtil = protUtil;
        this.protContentRepository = protContentRepository;
        this.auditService = auditService;
    }

    @PostMapping(value={"/request-proxy-config"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Void> createRequestProxyConfig(@Valid @RequestBody RequestProxyConfigView requestProxyConfigView) throws URISyntaxException {
        this.LOG.debug("REST request to save RequestProxyConfig : {}", (Object)requestProxyConfigView);
        if (requestProxyConfigView.getId() != null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RequestProxyConfig requestProxyConfig = this.from(requestProxyConfigView);
        this.logNewRequestProxyConfig(requestProxyConfig);
        requestProxyConfig = this.requestProxyConfigService.save(requestProxyConfig);
        if (requestProxyConfigView.getPlainSecret() != null && requestProxyConfigView.getPlainSecret().trim().length() != 0) {
            this.LOG.debug("REST request to create RequestProxyConfig : PlainSecret != null");
            ProtectedContent protSecret = this.protUtil.createProtectedContent(requestProxyConfigView.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, requestProxyConfig.getId().longValue());
            this.protContentRepository.save((Object)protSecret);
        }
        requestProxyConfig = this.requestProxyConfigService.save(requestProxyConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)requestProxyConfig.getId().toString()))).build();
    }

    @PutMapping(value={"/request-proxy-config"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Void> updateRequestProxyConfigView(@Valid @RequestBody RequestProxyConfigView requestProxyConfigView) throws URISyntaxException {
        this.LOG.debug("REST request to update RequestProxyConfig : {}", (Object)requestProxyConfigView);
        if (requestProxyConfigView.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        Optional requestProxyConfigOptional = this.requestProxyConfigService.findOne(requestProxyConfigView.getId());
        if (requestProxyConfigOptional.isEmpty()) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RequestProxyConfig requestProxyConfig = (RequestProxyConfig)requestProxyConfigOptional.get();
        requestProxyConfig.setName(requestProxyConfigView.getName());
        requestProxyConfig.setActive(requestProxyConfigView.getActive());
        requestProxyConfig.setRequestProxyUrl(requestProxyConfigView.getRequestProxyUrl());
        if (requestProxyConfigView.getPlainSecret() == null || requestProxyConfigView.getPlainSecret().trim().length() == 0) {
            this.LOG.warn("REST request to update RequestProxyConfig : cAConnectorConfig.getPlainSecret() == null no functionality!!");
        } else {
            String secret = requestProxyConfigView.getPlainSecret().trim();
            if (PLAIN_SECRET_PLACEHOLDER.equals(secret)) {
                this.LOG.debug("REST request to update RequestProxyConfig : PLAIN_SECRET_PLACEHOLDER.equals(RequestProxyConfig.getPlainSecret())");
            } else {
                this.LOG.debug("REST request to update RequestProxyConfig : PlainSecret modified");
                List protectedContents = this.protUtil.retrieveProtectedContent(ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, requestProxyConfigView.getId().longValue());
                if (protectedContents.stream().anyMatch(p -> secret.equals(this.protUtil.unprotectString(p.getContentBase64())))) {
                    this.LOG.debug("REST request to update RequestProxyConfig : PlainSecret already known");
                } else {
                    ProtectedContent protSecret = this.protUtil.createProtectedContent(requestProxyConfigView.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, requestProxyConfigView.getId().longValue());
                    this.protContentRepository.save((Object)protSecret);
                    this.LOG.debug("REST request to update RequestProxyConfig : new PlainSecret created");
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceRequestProxyConfigSecretChanged(requestProxyConfig));
                }
            }
        }
        this.logChangesRequestProxyConfig(requestProxyConfig);
        this.requestProxyConfigService.save(requestProxyConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)requestProxyConfigView.getId().toString()))).build();
    }

    @GetMapping(value={"/request-proxy-config"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<RequestProxyConfigView> getAllRequestProxyConfig() {
        this.LOG.debug("REST request to get all RequestProxyConfig");
        ArrayList<RequestProxyConfigView> requestProxyConfigViewList = new ArrayList<RequestProxyConfigView>();
        for (RequestProxyConfig requestProxyConfig : this.requestProxyConfigService.findAll()) {
            requestProxyConfigViewList.add(this.from(requestProxyConfig));
        }
        return requestProxyConfigViewList;
    }

    @GetMapping(value={"/request-proxy-config/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<RequestProxyConfigView> getRequestProxyConfig(@PathVariable Long id) {
        this.LOG.debug("REST request to get RequestProxyConfigView : {}", (Object)id);
        Optional requestProxyConfig = this.requestProxyConfigService.findOne(id);
        Optional<Object> optionalRequestProxyConfigView = Optional.empty();
        if (requestProxyConfig.isPresent()) {
            optionalRequestProxyConfigView = Optional.of(this.from((RequestProxyConfig)requestProxyConfig.get()));
        }
        return ResponseUtil.wrapOrNotFound(optionalRequestProxyConfigView);
    }

    private RequestProxyConfig from(RequestProxyConfigView requestProxyConfigView) {
        RequestProxyConfig requestProxyConfig = new RequestProxyConfig();
        requestProxyConfig.setId(requestProxyConfigView.getId());
        requestProxyConfig.setName(requestProxyConfigView.getName());
        requestProxyConfig.setActive(requestProxyConfigView.getActive());
        requestProxyConfig.setRequestProxyUrl(requestProxyConfigView.getRequestProxyUrl());
        return requestProxyConfig;
    }

    private RequestProxyConfigView from(RequestProxyConfig requestProxyConfig) {
        RequestProxyConfigView requestProxyConfigView = new RequestProxyConfigView();
        requestProxyConfigView.setId(requestProxyConfig.getId());
        requestProxyConfigView.setName(requestProxyConfig.getName());
        requestProxyConfigView.setRequestProxyUrl(requestProxyConfig.getRequestProxyUrl());
        requestProxyConfigView.setActive(requestProxyConfig.getActive());
        requestProxyConfigView.setPlainSecret(PLAIN_SECRET_PLACEHOLDER);
        return requestProxyConfigView;
    }

    void logNewRequestProxyConfig(RequestProxyConfig requestProxyConfig) {
        this.logDiff("Name", "", requestProxyConfig.getName(), requestProxyConfig);
        this.logDiff("RequestProxyUrl", "", requestProxyConfig.getRequestProxyUrl(), requestProxyConfig);
        this.logDiff("Active", "", requestProxyConfig.getActive() == null ? "" : requestProxyConfig.getActive().toString(), requestProxyConfig);
    }

    void logChangesRequestProxyConfig(RequestProxyConfig requestProxyConfig) {
        Optional requestProxyConfigOptional = this.requestProxyConfigService.findOne(requestProxyConfig.getId());
        if (requestProxyConfigOptional.isPresent()) {
            RequestProxyConfig oldRequestProxyConfig = (RequestProxyConfig)requestProxyConfigOptional.get();
            this.logDiff("Name", oldRequestProxyConfig.getName(), requestProxyConfig.getName(), requestProxyConfig);
            this.logDiff("RequestProxyUrl", oldRequestProxyConfig.getRequestProxyUrl(), requestProxyConfig.getRequestProxyUrl(), requestProxyConfig);
            this.logDiff("Active", oldRequestProxyConfig.getActive() == null ? "" : oldRequestProxyConfig.getActive().toString(), requestProxyConfig.getActive() == null ? "" : requestProxyConfig.getActive().toString(), requestProxyConfig);
        }
    }

    void logDiff(String attributeName, String oldVal, String newVal, RequestProxyConfig cAConnectorConfig) {
        if (oldVal != null) {
            if (!oldVal.equals(newVal)) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceRequestProxyConfigChange(attributeName, oldVal, newVal, cAConnectorConfig));
            }
        } else if (newVal != null) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceRequestProxyConfigChange(attributeName, "", newVal, cAConnectorConfig));
        }
    }
}

