/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CRLExpirationNotification;
import de.trustable.ca3s.core.repository.CRLExpirationNotificationRepository;
import de.trustable.ca3s.core.service.CRLExpirationNotificationService;
import de.trustable.ca3s.core.service.dto.CRLExpirationNotificationView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.PaginationUtil;

@RestController
@RequestMapping(value={"/api"})
public class CRLExpirationNotificationViewResource {
    private final Logger log = LoggerFactory.getLogger(CRLExpirationNotificationViewResource.class);
    private static final String ENTITY_NAME = "cRLExpirationNotification";
    private final CRLExpirationNotificationService cRLExpirationNotificationService;
    private final CRLExpirationNotificationRepository cRLExpirationNotificationRepository;

    public CRLExpirationNotificationViewResource(CRLExpirationNotificationService cRLExpirationNotificationService, CRLExpirationNotificationRepository cRLExpirationNotificationRepository) {
        this.cRLExpirationNotificationService = cRLExpirationNotificationService;
        this.cRLExpirationNotificationRepository = cRLExpirationNotificationRepository;
    }

    @GetMapping(value={"/crl-expiration-notification-views"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<List<CRLExpirationNotificationView>> getAllCertificates(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CRLExpirationNotificationView");
        Page page = this.cRLExpirationNotificationRepository.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        List cenList = this.getFullCRLExpirationNotificationViews(page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)cenList);
    }

    private List<CRLExpirationNotificationView> getFullCRLExpirationNotificationViews(Page<CRLExpirationNotification> page) {
        ArrayList<CRLExpirationNotificationView> crlExpirationNotificationViewList = new ArrayList<CRLExpirationNotificationView>();
        for (CRLExpirationNotification crlExpirationNotification : page.getContent()) {
            crlExpirationNotificationViewList.add(new CRLExpirationNotificationView(crlExpirationNotification));
        }
        return crlExpirationNotificationViewList;
    }

    @GetMapping(value={"/crl-expiration-notification-views/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CRLExpirationNotificationView> getCRLExpirationNotificationView(@PathVariable Long id) {
        this.log.debug("REST request to get CRLExpirationNotification : {}", (Object)id);
        Optional crlExpirationNotificationOptional = this.cRLExpirationNotificationService.findOne(id);
        if (crlExpirationNotificationOptional.isPresent()) {
            return ResponseEntity.ok((Object)new CRLExpirationNotificationView((CRLExpirationNotification)crlExpirationNotificationOptional.get()));
        }
        return ResponseEntity.notFound().build();
    }
}

