/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CRLExpirationNotification;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.CRLExpirationNotificationRepository;
import de.trustable.ca3s.core.service.CRLExpirationNotificationService;
import de.trustable.ca3s.core.web.rest.CRLExpirationNotificationViewResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class CRLExpirationNotificationResource {
    private final Logger log = LoggerFactory.getLogger(CRLExpirationNotificationViewResource.class);
    private static final String ENTITY_NAME = "cRLExpirationNotification";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CRLExpirationNotificationService cRLExpirationNotificationService;
    private final CRLExpirationNotificationRepository cRLExpirationNotificationRepository;

    public CRLExpirationNotificationResource(CRLExpirationNotificationService cRLExpirationNotificationService, CRLExpirationNotificationRepository cRLExpirationNotificationRepository) {
        this.cRLExpirationNotificationService = cRLExpirationNotificationService;
        this.cRLExpirationNotificationRepository = cRLExpirationNotificationRepository;
    }

    @PostMapping(value={"/crl-expiration-notifications"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CRLExpirationNotification> createCRLExpirationNotification(@Valid @RequestBody CRLExpirationNotification cRLExpirationNotification) throws URISyntaxException {
        this.log.debug("REST request to save CRLExpirationNotification : {}", (Object)cRLExpirationNotification);
        if (cRLExpirationNotification.getId() != null) {
            throw new BadRequestAlertException("A new cRLExpirationNotification cannot already have an ID", ENTITY_NAME, "idexists");
        }
        CRLExpirationNotification result = this.cRLExpirationNotificationService.save(cRLExpirationNotification);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/crl-expiration-notifications/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PostMapping(value={"/crl-expiration-notifications/certificate"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<List<CRLExpirationNotification>> createCRLExpirationNotification(@Valid @RequestBody Long certificateId) {
        this.log.debug("REST request to create CRLExpirationNotification by certificate id: {}", (Object)certificateId);
        if (certificateId == null) {
            throw new BadRequestAlertException("Invalid certificate id", ENTITY_NAME, "idnull");
        }
        List result = this.cRLExpirationNotificationService.createByCertificateId(certificateId);
        return ResponseEntity.ok().body((Object)result);
    }

    @PutMapping(value={"/crl-expiration-notifications/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CRLExpirationNotification> updateCRLExpirationNotification(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody CRLExpirationNotification cRLExpirationNotification) {
        this.log.debug("REST request to update CRLExpirationNotification : {}, {}", (Object)id, (Object)cRLExpirationNotification);
        if (cRLExpirationNotification.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, cRLExpirationNotification.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.cRLExpirationNotificationRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        CRLExpirationNotification result = this.cRLExpirationNotificationService.update(cRLExpirationNotification);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)cRLExpirationNotification.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/crl-expiration-notifications"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<CRLExpirationNotification> getAllCRLExpirationNotifications() {
        this.log.debug("REST request to get all CRLExpirationNotifications");
        return this.cRLExpirationNotificationService.findAll();
    }

    @GetMapping(value={"/crl-expiration-notifications/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CRLExpirationNotification> getCRLExpirationNotification(@PathVariable Long id) {
        this.log.debug("REST request to get CRLExpirationNotification : {}", (Object)id);
        Optional cRLExpirationNotification = this.cRLExpirationNotificationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)cRLExpirationNotification);
    }

    @DeleteMapping(value={"/crl-expiration-notifications/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteCRLExpirationNotification(@PathVariable Long id) {
        this.log.debug("REST request to delete CRLExpirationNotification : {}", (Object)id);
        this.cRLExpirationNotificationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

