/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.service.AuditEventService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/management/audits"})
public class AuditResource {
    private final AuditEventService auditEventService;

    public AuditResource(AuditEventService auditEventService) {
        this.auditEventService = auditEventService;
    }

    @GetMapping
    public ResponseEntity<List<AuditEvent>> getAll(Pageable pageable) {
        Page page = this.auditEventService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(params={"fromDate", "toDate"})
    public ResponseEntity<List<AuditEvent>> getByDates(@RequestParam(value="fromDate") LocalDate fromDate, @RequestParam(value="toDate") LocalDate toDate, Pageable pageable) {
        Instant from = fromDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant to = toDate.atStartOfDay(ZoneId.systemDefault()).plusDays(1L).toInstant();
        Page page = this.auditEventService.findByDates(from, to, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/{id:.+}"})
    public ResponseEntity<AuditEvent> get(@PathVariable Long id) {
        return ResponseUtil.wrapOrNotFound((Optional)this.auditEventService.find(id));
    }
}

