/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app/help"})
public class HelpController {
    static final String prefixHTML = "<html>\n<head>\n<meta charset=\"UTF-8\">\n<title>ca3s {role} Help</title>\n<link rel=\"stylesheet\" href=\"../../css/modest.css\">\n</head>\n<body>\n";
    static final String postfixHTML = "\n</body>\n</html>";
    private final Resource helpResourceEn;
    private final Resource helpResourceDe;
    private final Resource helpAdminResourceEn;
    private final Resource helpAdminResourceDe;

    public HelpController(@Value(value="${ca3s.help.en:classpath:help/help_en.md}") Resource helpResourceEn, @Value(value="${ca3s.help.de:classpath:help/help_de.md}") Resource helpResourceDe, @Value(value="${ca3s.help.admin.en:classpath:help/helpAdmin_en.md}") Resource helpAdminResourceEn, @Value(value="${ca3s.help.admin.de:classpath:help/helpAdmin_de.md}") Resource helpAdminResourceDe) {
        this.helpResourceEn = helpResourceEn;
        this.helpResourceDe = helpResourceDe;
        this.helpAdminResourceEn = helpAdminResourceEn;
        this.helpAdminResourceDe = helpAdminResourceDe;
    }

    @GetMapping(value={"/help-{lang}.html"}, produces={"text/html"})
    @ResponseBody
    public String helpAsHTML(@PathVariable String lang) throws IOException {
        Resource helpResource = this.helpResourceEn;
        if ("de".equalsIgnoreCase(lang)) {
            helpResource = this.helpResourceDe;
        }
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parseReader((Reader)new InputStreamReader(helpResource.getInputStream(), "UTF-8"));
        return this.getPrefixForRole("") + renderer.render((Node)document) + postfixHTML;
    }

    @GetMapping(value={"/helpAdmin-{lang}.html"}, produces={"text/html"})
    @ResponseBody
    public String helpAdminAsHTML(@PathVariable String lang) throws IOException {
        Resource helpResource = this.helpAdminResourceEn;
        if ("de".equalsIgnoreCase(lang)) {
            helpResource = this.helpAdminResourceDe;
        }
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parseReader((Reader)new InputStreamReader(helpResource.getInputStream(), "UTF-8"));
        return this.getPrefixForRole("Admin") + renderer.render((Node)document) + postfixHTML;
    }

    @GetMapping(value={"/help-{lang}.md"}, produces={"text/markdown; charset=UTF-8"})
    @ResponseBody
    public String helpAsMD(@PathVariable String lang) throws IOException {
        Resource helpResource = this.helpResourceEn;
        if ("de".equalsIgnoreCase(lang)) {
            helpResource = this.helpResourceDe;
        }
        return IOUtils.toString((Reader)new InputStreamReader(helpResource.getInputStream(), "UTF-8"));
    }

    private String getPrefixForRole(String role) {
        return prefixHTML.replace("{role}", role);
    }
}

